/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation.diff;

import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.treetable.TreeTableCellRenderer;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.BeforeAfter;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.nodejs.run.profile.cpu.view.TreeTableModelWithCustomRenderer;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.AggregateDifferenceEmphasizer;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.AggregatesViewDiff;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.DiffCellRenderer;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.V8DiffCachingReader;
import com.jetbrains.nodejs.run.profile.heap.view.components.ColoredTable;
import com.jetbrains.nodejs.run.profile.heap.view.models.V8HeapContainmentTreeTableModel;
import com.jetbrains.nodejs.run.profile.heap.view.renderers.SizeRenderer;
import java.awt.Color;
import java.util.List;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AggregatesDiffTableModel
implements TreeTableModelWithCustomRenderer,
ColoredTable {
    private final Object myRoot;
    private final ColumnInfo[] myColumns;
    private final Project myProject;
    @NotNull
    private final V8DiffCachingReader myReader;
    private DiffCellRenderer myRenderer;
    private final EditorColorsScheme myGlobalScheme;

    public AggregatesDiffTableModel(Project project, @NotNull V8DiffCachingReader reader) {
        if (reader == null) {
            AggregatesDiffTableModel.$$$reportNull$$$0(0);
        }
        this.myRoot = new Object();
        this.myProject = project;
        this.myReader = reader;
        this.myColumns = new ColumnInfo[6];
        this.myGlobalScheme = EditorColorsManager.getInstance().getGlobalScheme();
        this.fillColumns();
    }

    @Override
    public Color getLineColor(Object value, boolean selected) {
        Color defaultColor;
        Color color = defaultColor = selected ? UIUtil.getTableSelectionBackground() : UIUtil.getTableBackground();
        if (value instanceof AggregatesViewDiff.AggregateDifference) {
            AggregatesViewDiff.AggregateDifference diff = (AggregatesViewDiff.AggregateDifference)value;
            if (diff.getBase() == null) {
                return this.myGlobalScheme.getColor(EditorColors.ADDED_LINES_COLOR);
            }
            if (diff.getChanged() == null) {
                return this.myGlobalScheme.getColor(EditorColors.DELETED_LINES_COLOR);
            }
            return defaultColor;
        }
        if (value instanceof BeforeAfter) {
            BeforeAfter beforeAfter = (BeforeAfter)value;
            if (beforeAfter.getBefore() == null) {
                return this.myGlobalScheme.getColor(EditorColors.ADDED_LINES_COLOR);
            }
            if (beforeAfter.getAfter() == null) {
                return this.myGlobalScheme.getColor(EditorColors.DELETED_LINES_COLOR);
            }
            return defaultColor;
        }
        return defaultColor;
    }

    private void fillColumns() {
        AggregateDifferenceEmphasizer emphasizer = AggregateDifferenceEmphasizer.getInstance();
        this.myRenderer = new DiffCellRenderer(this.myProject, this.myReader.getBaseReader(), this.myReader.getChangedReader(), emphasizer);
        this.myColumns[0] = new ColumnInfo<Object, Object>("Constructor"){

            @Nullable
            public Object valueOf(Object o) {
                return o;
            }

            public TableCellRenderer getCustomizedRenderer(Object o, TableCellRenderer renderer) {
                if (renderer instanceof TreeTableCellRenderer) {
                    ((TreeTableCellRenderer)renderer).setCellRenderer((TreeCellRenderer)((Object)AggregatesDiffTableModel.this.myRenderer));
                }
                return super.getCustomizedRenderer(o, renderer);
            }
        };
        DiffSizesTableCellRenderer alignedRenderer = new DiffSizesTableCellRenderer(emphasizer);
        this.myColumns[1] = new ColumnInfo<Object, Object>("Count Diff", (TableCellRenderer)((Object)alignedRenderer)){
            final /* synthetic */ TableCellRenderer val$alignedRenderer;
            {
                this.val$alignedRenderer = tableCellRenderer;
                super(x0);
            }

            @Nullable
            public Object valueOf(Object o) {
                if (o instanceof AggregatesViewDiff.AggregateDifference) {
                    AggregatesViewDiff.AggregateDifference difference = (AggregatesViewDiff.AggregateDifference)o;
                    return new ValueAndPercent(difference.objectsDiff(), difference.selfSizePercent());
                }
                return "";
            }

            public TableCellRenderer getCustomizedRenderer(Object o, TableCellRenderer renderer) {
                return this.val$alignedRenderer;
            }
        };
        this.myColumns[2] = new ColumnInfo<Object, Object>("Count", (TableCellRenderer)((Object)alignedRenderer)){
            final /* synthetic */ TableCellRenderer val$alignedRenderer;
            {
                this.val$alignedRenderer = tableCellRenderer;
                super(x0);
            }

            @Nullable
            public Object valueOf(Object o) {
                if (o instanceof AggregatesViewDiff.AggregateDifference) {
                    AggregatesViewDiff.AggregateDifference difference = (AggregatesViewDiff.AggregateDifference)o;
                    return AggregatesDiffTableModel.withSign('+', difference.getAddedCnt()) + "/" + AggregatesDiffTableModel.withSign('-', difference.getRemovedCnt());
                }
                return "";
            }

            public TableCellRenderer getCustomizedRenderer(Object o, TableCellRenderer renderer) {
                return this.val$alignedRenderer;
            }
        };
        this.myColumns[3] = new ColumnInfo<Object, Object>("Size Diff", (TableCellRenderer)((Object)alignedRenderer)){
            final /* synthetic */ TableCellRenderer val$alignedRenderer;
            {
                this.val$alignedRenderer = tableCellRenderer;
                super(x0);
            }

            @Nullable
            public Object valueOf(Object o) {
                if (o instanceof AggregatesViewDiff.AggregateDifference) {
                    AggregatesViewDiff.AggregateDifference difference = (AggregatesViewDiff.AggregateDifference)o;
                    return new ValueAndPercent(difference.selfSizeDiff(), difference.objectsPercent());
                }
                return "";
            }

            public TableCellRenderer getCustomizedRenderer(Object o, TableCellRenderer renderer) {
                return this.val$alignedRenderer;
            }
        };
        this.myColumns[4] = new ColumnInfo<Object, Object>("Size", (TableCellRenderer)((Object)alignedRenderer)){
            final /* synthetic */ TableCellRenderer val$alignedRenderer;
            {
                this.val$alignedRenderer = tableCellRenderer;
                super(x0);
            }

            @Nullable
            public Object valueOf(Object o) {
                if (o instanceof AggregatesViewDiff.AggregateDifference) {
                    AggregatesViewDiff.AggregateDifference difference = (AggregatesViewDiff.AggregateDifference)o;
                    return AggregatesDiffTableModel.withSign('+', difference.getAddedSize()) + "/" + AggregatesDiffTableModel.withSign('-', difference.getRemovedSize());
                }
                if (o instanceof BeforeAfter) {
                    BeforeAfter beforeAfter = (BeforeAfter)o;
                    if (beforeAfter.getBefore() == null) {
                        return AggregatesDiffTableModel.withSign('+', ((V8HeapContainmentTreeTableModel.NamedEntry)beforeAfter.getAfter()).getEntry().getSize());
                    }
                    if (beforeAfter.getAfter() == null) {
                        return AggregatesDiffTableModel.withSign('-', ((V8HeapContainmentTreeTableModel.NamedEntry)beforeAfter.getBefore()).getEntry().getSize());
                    }
                    return ((V8HeapContainmentTreeTableModel.NamedEntry)beforeAfter.getBefore()).getEntry().getSize() + "->" + ((V8HeapContainmentTreeTableModel.NamedEntry)beforeAfter.getAfter()).getEntry().getSize();
                }
                return "";
            }

            public TableCellRenderer getCustomizedRenderer(Object o, TableCellRenderer renderer) {
                return this.val$alignedRenderer;
            }
        };
        this.myColumns[5] = new ColumnInfo<Object, Object>("Retained Size", (TableCellRenderer)((Object)alignedRenderer)){
            final /* synthetic */ TableCellRenderer val$alignedRenderer;
            {
                this.val$alignedRenderer = tableCellRenderer;
                super(x0);
            }

            @Nullable
            public Object valueOf(Object o) {
                if (o instanceof AggregatesViewDiff.AggregateDifference) {
                    return "";
                }
                if (o instanceof BeforeAfter) {
                    BeforeAfter beforeAfter = (BeforeAfter)o;
                    if (beforeAfter.getBefore() == null) {
                        return AggregatesDiffTableModel.withSign('+', AggregatesDiffTableModel.this.myReader.getChangedReader().getRetainedSize((int)((V8HeapContainmentTreeTableModel.NamedEntry)beforeAfter.getAfter()).getEntry().getId()));
                    }
                    if (beforeAfter.getAfter() == null) {
                        return AggregatesDiffTableModel.withSign('-', AggregatesDiffTableModel.this.myReader.getBaseReader().getRetainedSize((int)((V8HeapContainmentTreeTableModel.NamedEntry)beforeAfter.getBefore()).getEntry().getId()));
                    }
                    long changed = AggregatesDiffTableModel.this.myReader.getChangedReader().getRetainedSize((int)((V8HeapContainmentTreeTableModel.NamedEntry)beforeAfter.getAfter()).getEntry().getId());
                    long base = AggregatesDiffTableModel.this.myReader.getBaseReader().getRetainedSize((int)((V8HeapContainmentTreeTableModel.NamedEntry)beforeAfter.getBefore()).getEntry().getId());
                    return changed + "->" + base;
                }
                return "";
            }

            public TableCellRenderer getCustomizedRenderer(Object o, TableCellRenderer renderer) {
                return this.val$alignedRenderer;
            }
        };
    }

    private static String withSign(char sign, long value) {
        if (value == 0L) {
            return "0";
        }
        return sign + SizeRenderer.formatSize(String.valueOf(value));
    }

    @Override
    public TableCellRenderer getCustomizedRenderer(int column, Object o, TableCellRenderer renderer) {
        return this.myColumns[column].getCustomizedRenderer(o, renderer);
    }

    public int getColumnCount() {
        return this.myColumns.length;
    }

    public String getColumnName(int column) {
        return this.myColumns[column].getName();
    }

    public Class getColumnClass(int column) {
        return column == 0 ? TreeTableModel.class : String.class;
    }

    public Object getValueAt(Object node, int column) {
        return this.myColumns[column].valueOf(node);
    }

    public boolean isCellEditable(Object node, int column) {
        return false;
    }

    public void setValueAt(Object aValue, Object node, int column) {
    }

    public void setTree(JTree tree) {
    }

    public Object getRoot() {
        return this.myRoot;
    }

    public Object getChild(Object parent, int index) {
        if (parent == this.myRoot) {
            return this.myReader.getAggregatesViewDiff().getList().get(index);
        }
        if (parent instanceof AggregatesViewDiff.AggregateDifference) {
            List<BeforeAfter<V8HeapContainmentTreeTableModel.NamedEntry>> children = this.myReader.getChildren((AggregatesViewDiff.AggregateDifference)parent);
            return children.get(index);
        }
        return null;
    }

    public int getChildCount(Object parent) {
        if (parent == this.myRoot) {
            return this.myReader.getAggregatesViewDiff().getList().size();
        }
        if (parent instanceof AggregatesViewDiff.AggregateDifference) {
            List<BeforeAfter<V8HeapContainmentTreeTableModel.NamedEntry>> children = this.myReader.getChildren((AggregatesViewDiff.AggregateDifference)parent);
            return children.size();
        }
        return 0;
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public int getIndexOfChild(Object parent, Object child) {
        block3: {
            block2: {
                if (parent != this.myRoot) break block2;
                List<AggregatesViewDiff.AggregateDifference> list = this.myReader.getAggregatesViewDiff().getList();
                for (int i = 0; i < list.size(); ++i) {
                    AggregatesViewDiff.AggregateDifference difference = list.get(i);
                    if (!difference.equals(child)) continue;
                    return i;
                }
                break block3;
            }
            if (!(parent instanceof AggregatesViewDiff.AggregateDifference)) break block3;
            List<BeforeAfter<V8HeapContainmentTreeTableModel.NamedEntry>> children = this.myReader.getChildren((AggregatesViewDiff.AggregateDifference)parent);
            for (int i = 0; i < children.size(); ++i) {
                BeforeAfter<V8HeapContainmentTreeTableModel.NamedEntry> beforeAfter = children.get(i);
                if (!beforeAfter.equals(child)) continue;
                return i;
            }
        }
        return 0;
    }

    public void addTreeModelListener(TreeModelListener l) {
    }

    public void removeTreeModelListener(TreeModelListener l) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/jetbrains/nodejs/run/profile/heap/calculation/diff/AggregatesDiffTableModel", "<init>"));
    }

    private static class DiffSizesTableCellRenderer
    extends ColoredTableCellRenderer {
        private final SimpleTextAttributes mySelectedBold;
        private final SimpleTextAttributes mySelectedGreyBold;
        private final SimpleTextAttributes myGreyBold;
        private final AggregateDifferenceEmphasizer myEmphasizer;

        DiffSizesTableCellRenderer(AggregateDifferenceEmphasizer emphasizer) {
            this.myEmphasizer = emphasizer;
            this.mySelectedBold = SimpleTextAttributes.SELECTED_SIMPLE_CELL_ATTRIBUTES.derive(1, null, null, null);
            this.mySelectedGreyBold = SimpleTextAttributes.SELECTED_SIMPLE_CELL_ATTRIBUTES.derive(1, SimpleTextAttributes.GRAY_ATTRIBUTES.getFgColor(), null, null);
            this.myGreyBold = SimpleTextAttributes.GRAY_ATTRIBUTES.derive(1, null, null, null);
        }

        protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            SimpleTextAttributes usualAttr;
            boolean bold;
            this.setTextAlign(4);
            Object valueFromZero = table.getModel().getValueAt(row, 0);
            boolean bl = bold = valueFromZero instanceof AggregatesViewDiff.AggregateDifference && this.myEmphasizer.emphasize((AggregatesViewDiff.AggregateDifference)valueFromZero);
            SimpleTextAttributes simpleTextAttributes = bold ? (selected ? this.mySelectedBold : SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES) : (usualAttr = SimpleTextAttributes.REGULAR_ATTRIBUTES);
            if (value instanceof ValueAndPercent) {
                this.append(((ValueAndPercent)value).getValue(), usualAttr);
                this.append(" " + ((ValueAndPercent)value).getPercent() + "%", bold ? (selected ? this.mySelectedGreyBold : this.myGreyBold) : SimpleTextAttributes.GRAY_ATTRIBUTES);
            } else {
                this.append(value.toString(), usualAttr);
            }
        }
    }

    private static class ValueAndPercent {
        private final long myValue;
        private final int myPercent;

        ValueAndPercent(long value, int percent) {
            this.myValue = value;
            this.myPercent = percent;
        }

        public String getValue() {
            long unsg = Math.abs(this.myValue);
            return ValueAndPercent.sign(this.myValue) + SizeRenderer.formatSize(String.valueOf(unsg));
        }

        public String getPercent() {
            int unsg = Math.abs(this.myPercent);
            return (unsg < 10 ? " " : "") + ValueAndPercent.sign(this.myPercent) + unsg;
        }

        private static String sign(long value) {
            return value == 0L ? " " : (value < 0L ? "-" : "+");
        }
    }
}

