/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.h2;

import com.intellij.lexer.Lexer;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.h2.H2Dialect;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.lexer._H2Lexer;
import org.jetbrains.annotations.Nullable;

public class H2Lexer
extends SqlLexer {
    public H2Lexer() {
        super(H2Dialect.LazyData.ourClasses, new _H2Lexer());
    }

    @Override
    protected void lookAhead(Lexer baseLexer) {
        if (!this.lookAheadCustomQuotation(baseLexer)) {
            super.lookAhead(baseLexer);
        }
    }

    private boolean lookAheadCustomQuotation(Lexer baseLexer) {
        String ident = H2Lexer.getDollarQuotingIdent(baseLexer);
        if (ident == null) {
            return false;
        }
        int identLen = ident.length();
        int stringStart = baseLexer.getTokenStart() + identLen;
        baseLexer.advance();
        return this.processCustomQuotation(baseLexer, ident, stringStart);
    }

    @Nullable
    private static String getDollarQuotingIdent(Lexer baseLexer) {
        if (baseLexer.getTokenType() != SqlTokens.SQL_IDENT_DELIMITED) {
            return null;
        }
        String identText = baseLexer.getTokenText();
        return "$$".equals(identText) ? identText : null;
    }
}

