/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeNamespace;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DatabaseObjectRefEditor;
import com.intellij.database.view.models.EditorModelUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseTableRefEditor {
    private final DeModel myModel;
    @Nullable
    private final BasicModel myTargetModel;
    private final DatabaseObjectRefEditor<DasTable> myDelegate;
    private DeTable myStubCache;

    public DatabaseTableRefEditor(@NotNull DeModel model, @NotNull DatabaseEditorContext context) {
        if (model == null) {
            DatabaseTableRefEditor.$$$reportNull$$$0(0);
        }
        if (context == null) {
            DatabaseTableRefEditor.$$$reportNull$$$0(1);
        }
        this.myModel = model;
        this.myTargetModel = context.getModel();
        this.myDelegate = new DatabaseObjectRefEditor<DasTable>(context){

            @Override
            protected Icon getIcon(@NotNull DasTable item) {
                if (item == null) {
                    1.$$$reportNull$$$0(0);
                }
                return DatabaseIcons.Table;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/view/editors/DatabaseTableRefEditor$1", "getIcon"));
            }
        };
        this.myDelegate.setItems((JBIterable<DasTable>)(this.myTargetModel == null ? JBIterable.empty() : this.myTargetModel.traverser().filter(DasTable.class).filter(DasUtil.byKind((ObjectKind)ObjectKind.TABLE))));
    }

    @NotNull
    public EditorTextField getEditor() {
        EditorTextField editorTextField = this.myDelegate.getEditor();
        if (editorTextField == null) {
            DatabaseTableRefEditor.$$$reportNull$$$0(2);
        }
        return editorTextField;
    }

    @NotNull
    public String getName() {
        String string = this.myDelegate.getName();
        if (string == null) {
            DatabaseTableRefEditor.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public DeTable getObject() {
        DasTable res2 = this.myDelegate.getObject();
        if (res2 == null) {
            return null;
        }
        return (DeTable)this.myModel.getExportHelper().exportDeep((DasModel)this.myTargetModel, (Iterable<? extends DasObject>)JBIterable.of((Object)res2), true).first();
    }

    public void setObject(@Nullable DeTable obj) {
        this.myDelegate.setObject(obj);
    }

    @NotNull
    public DeTable getObjectOrStub(@Nullable DeNamespace parent2) {
        DeTable res2 = this.getObject();
        if (res2 == null) {
            String name = this.getName();
            if (this.myStubCache == null || !this.myStubCache.name.equals(name)) {
                this.myStubCache = DatabaseTableRefEditor.createStub(name, parent2, this.myModel);
            }
            res2 = this.myStubCache;
        }
        DeTable deTable = res2;
        if (deTable == null) {
            DatabaseTableRefEditor.$$$reportNull$$$0(4);
        }
        return deTable;
    }

    @NotNull
    public static DeTable createStub(@NotNull String name, @Nullable DeNamespace parent2, @NotNull DeModel model) {
        if (name == null) {
            DatabaseTableRefEditor.$$$reportNull$$$0(5);
        }
        if (model == null) {
            DatabaseTableRefEditor.$$$reportNull$$$0(6);
        }
        DeTable deTable = EditorModelUtil.setStub(new DeTable(name, parent2, model));
        if (deTable == null) {
            DatabaseTableRefEditor.$$$reportNull$$$0(7);
        }
        return deTable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/DatabaseTableRefEditor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/DatabaseTableRefEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectOrStub";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createStub";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

