/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.undo;

import com.intellij.diagram.DiagramActionsListener;
import com.intellij.diagram.DiagramActionsManager;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.command.CommandProcessorEx;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.impl.UndoProvider;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.graph.builder.event.GraphBuilderEvent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.uml.undo.UmlUndoableAction;

public class UmlUndoProvider
implements UndoProvider,
DiagramActionsListener {
    private final Project myProject;
    private boolean myIsInsideCommand;

    public UmlUndoProvider(Project project) {
        this.myProject = project;
        DiagramActionsManager.getInstance((Project)project).addListener((DiagramActionsListener)this);
    }

    public void commandStarted(Project p) {
        if (this.myProject != p) {
            return;
        }
        this.myIsInsideCommand = true;
    }

    public void commandFinished(Project p) {
        if (this.myProject != p) {
            return;
        }
        this.myIsInsideCommand = false;
    }

    private boolean shouldProcess() {
        return !this.isProjectClosed() && this.myIsInsideCommand;
    }

    private boolean isProjectClosed() {
        return this.myProject == null || this.myProject.isDisposed();
    }

    public void actionPerformed(DiagramBuilder builder, DiagramState oldState, PsiFile ... files) {
        if (this.shouldProcess() && builder.getDocumentReference() != null) {
            String commandName = CommandProcessorEx.getInstance().getCurrentCommandName();
            UmlUndoableAction action = new UmlUndoableAction(builder, oldState, files);
            if (!GraphBuilderEvent.NODES_MOVED.toString().equals(commandName) || !action.isNodeMoved()) {
                this.getUndoManager().undoableActionPerformed((UndoableAction)action);
            }
        }
    }

    private UndoManagerImpl getUndoManager() {
        if (this.myProject != null) {
            return (UndoManagerImpl)UndoManager.getInstance((Project)this.myProject);
        }
        return (UndoManagerImpl)UndoManager.getGlobalInstance();
    }
}

