/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.model;

import com.intellij.openapi.graph.view.Arrow;
import com.intellij.openapi.graph.view.Drawable;
import com.intellij.openapi.graph.view.LineType;
import com.intellij.ui.Gray;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public interface UmlRelationship {
    public static final UmlRelationshipFactory FACTORY = new UmlRelationshipFactory(){

        @Override
        public UmlRelationship createAggregation(String label) {
            return null;
        }

        @Override
        public UmlRelationship createAssociation(String label) {
            return null;
        }

        @Override
        public UmlRelationship createComposition(String label) {
            return null;
        }

        @Override
        public UmlRelationship createDependency(final String label) {
            return new UmlRelationship(){

                @Override
                public LineType getLineType() {
                    return LineType.DASHED_1;
                }

                @Override
                public Arrow getArrow() {
                    return CREATE.getArrow();
                }

                @Override
                public String getLabel() {
                    return label;
                }

                @NonNls
                public String toString() {
                    return "DEPENDENCY " + label;
                }
            };
        }
    };
    public static final UmlRelationship DEPENDENCY = new UmlRelationship(){

        @Override
        public LineType getLineType() {
            return LineType.DASHED_1;
        }

        @Override
        public Arrow getArrow() {
            return CREATE.getArrow();
        }

        @Override
        public String getLabel() {
            return "";
        }

        @NonNls
        public String toString() {
            return "DEPENDENCY";
        }
    };
    @NonNls
    public static final String ANGLE_ARROW = "angle";
    public static final UmlRelationship CREATE = new UmlRelationship(){

        @Override
        public LineType getLineType() {
            return LineType.DASHED_1;
        }

        @Override
        public Arrow getArrow() {
            Arrow arrow = Arrow.Statics.getCustomArrow((String)UmlRelationship.ANGLE_ARROW);
            if (arrow == null) {
                GeneralPath shape = new GeneralPath();
                shape.moveTo(-8.0f, -5.0f);
                shape.lineTo(0.0f, 0.0f);
                shape.lineTo(-8.0f, 5.0f);
                arrow = Arrow.Statics.addCustomArrow((String)UmlRelationship.ANGLE_ARROW, (Shape)shape, (Color)Gray.TRANSPARENT);
            }
            return arrow;
        }

        @Override
        @NonNls
        public String getLabel() {
            return "<html>&laquo;create&raquo;</html>";
        }

        @NonNls
        public String toString() {
            return "CREATE";
        }
    };
    public static final UmlRelationship TO_ONE = new UmlTwoForkedRelationship(){

        @Override
        public LineType getLineType() {
            return LineType.LINE_1;
        }

        @Override
        public Arrow getArrow() {
            return CREATE.getArrow();
        }

        @Override
        public String getLabel() {
            return "1:1";
        }

        @Override
        public Arrow getSourceArrow() {
            return Arrow.DIAMOND;
        }

        @NonNls
        public String toString() {
            return "TO_ONE";
        }
    };
    public static final UmlRelationship TO_MANY = new UmlTwoForkedRelationship(){

        @Override
        public LineType getLineType() {
            return LineType.LINE_1;
        }

        @Override
        public Arrow getArrow() {
            return CREATE.getArrow();
        }

        @Override
        public String getLabel() {
            return "1:*";
        }

        @Override
        public Arrow getSourceArrow() {
            return Arrow.DIAMOND;
        }

        @NonNls
        public String toString() {
            return "TO_MANY";
        }
    };
    public static final UmlRelationship GENERALIZATION = new UmlRelationship(){

        @Override
        public LineType getLineType() {
            return LineType.LINE_1;
        }

        @Override
        public Arrow getArrow() {
            return Arrow.DELTA;
        }

        @Override
        public String getLabel() {
            return "";
        }

        @NonNls
        public String toString() {
            return "GENERALIZATION";
        }
    };
    public static final UmlRelationship INTERFACE_GENERALIZATION = new UmlRelationship(){

        @Override
        public LineType getLineType() {
            return LineType.LINE_1;
        }

        @Override
        public Arrow getArrow() {
            return Arrow.DELTA;
        }

        @Override
        public String getLabel() {
            return "";
        }

        @NonNls
        public String toString() {
            return "INTERFACE_GENERALIZATION";
        }
    };
    public static final UmlRelationship REALIZATION = new UmlRelationship(){

        @Override
        public LineType getLineType() {
            return LineType.DASHED_1;
        }

        @Override
        public Arrow getArrow() {
            return Arrow.DELTA;
        }

        @Override
        public String getLabel() {
            return "";
        }

        @NonNls
        public String toString() {
            return "REALIZATION";
        }
    };
    public static final UmlRelationship NO_RELATIONSHIP = new UmlRelationship(){

        @Override
        @Nullable
        public LineType getLineType() {
            return null;
        }

        @Override
        @Nullable
        public Arrow getArrow() {
            return null;
        }

        @Override
        public String getLabel() {
            return "";
        }

        @NonNls
        public String toString() {
            return "NO_RELATIONSHIP";
        }
    };
    public static final UmlRelationship ANNOTATION = new UmlRelationship(){

        @Override
        public LineType getLineType() {
            return LineType.DOTTED_2;
        }

        @Override
        public Arrow getArrow() {
            return Arrow.NONE;
        }

        @Override
        public String getLabel() {
            return "";
        }

        @NonNls
        public String toString() {
            return "ANNOTATION";
        }
    };
    public static final UmlRelationship INNER_CLASS = new UmlRelationship(){
        @NonNls
        private final String INNER_CLASS_ARROW = "InnerClassArrow";
        private static final int R = 5;

        @Override
        public LineType getLineType() {
            return LineType.LINE_1;
        }

        @Override
        public Arrow getArrow() {
            if (Arrow.Statics.getCustomArrow((String)"InnerClassArrow") == null) {
                Drawable arrow = new Drawable(){

                    public void paint(Graphics2D g) {
                        Paint paint = g.getPaint();
                        g.setPaint(g.getBackground());
                        g.fillOval(-10, -5, 10, 10);
                        g.setPaint(paint);
                        g.drawOval(-10, -5, 10, 10);
                        g.drawLine(-5, -3, -5, 3);
                        g.drawLine(-8, 0, -2, 0);
                    }

                    public Rectangle getBounds() {
                        return new Rectangle(-5, -5, 5, 5);
                    }
                };
                Arrow.Statics.addCustomArrow((String)"InnerClassArrow", (Drawable)arrow);
            }
            return Arrow.Statics.getCustomArrow((String)"InnerClassArrow");
        }

        @Override
        public String getLabel() {
            return "";
        }

        @NonNls
        public String toString() {
            return "INNER_CLASS";
        }
    };
    public static final UmlRelationship[] KNOWN_RELATIONSIPS = new UmlRelationship[]{ANNOTATION, CREATE, DEPENDENCY, GENERALIZATION, INNER_CLASS, INTERFACE_GENERALIZATION, NO_RELATIONSHIP, REALIZATION, TO_MANY, TO_ONE};

    public LineType getLineType();

    public Arrow getArrow();

    public String getLabel();

    public static interface UmlTwoForkedRelationship
    extends UmlRelationship {
        public Arrow getSourceArrow();
    }

    public static interface UmlRelationshipFactory {
        public UmlRelationship createAggregation(String var1);

        public UmlRelationship createAssociation(String var1);

        public UmlRelationship createComposition(String var1);

        public UmlRelationship createDependency(String var1);
    }
}

