/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.rt.engine.remote;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.rmi.PortableRemoteObject;
import org.intellij.plugins.xsltDebugger.rt.engine.Debugger;
import org.intellij.plugins.xsltDebugger.rt.engine.Value;
import org.intellij.plugins.xsltDebugger.rt.engine.remote.RemoteDebugger;
import org.intellij.plugins.xsltDebugger.rt.engine.remote.ValueImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RemoteVariableImpl
extends PortableRemoteObject
implements RemoteDebugger.Variable {
    private final Debugger.Variable myVariable;

    RemoteVariableImpl(Debugger.Variable variable) throws RemoteException {
        this.myVariable = variable;
    }

    @Override
    public String getURI() throws RemoteException {
        return this.myVariable.getURI();
    }

    @Override
    public int getLineNumber() throws RemoteException {
        return this.myVariable.getLineNumber();
    }

    @Override
    public boolean isGlobal() {
        return this.myVariable.isGlobal();
    }

    @Override
    public Debugger.Variable.Kind getKind() throws RemoteException {
        return this.myVariable.getKind();
    }

    @Override
    public String getName() {
        return this.myVariable.getName();
    }

    @Override
    public Value getValue() {
        Value value = this.myVariable.getValue();
        return new ValueImpl(value.getValue(), value.getType());
    }

    static List<RemoteDebugger.Variable> convert(List<? extends Debugger.Variable> list) throws RemoteException {
        ArrayList<RemoteDebugger.Variable> variables = new ArrayList<RemoteDebugger.Variable>(list.size());
        for (Debugger.Variable variable : list) {
            variables.add(new RemoteVariableImpl(variable));
        }
        return variables;
    }
}

