/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.rename.automaticRenamers;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.PhpRefactoringSettings;
import com.jetbrains.php.refactoring.rename.automaticRenamers.ClassInheritorsRenamerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileContainingClassRenamerFactory
implements AutomaticRenamerFactory {
    public boolean isApplicable(@NotNull PsiElement element) {
        PhpFile containingFile;
        if (element == null) {
            FileContainingClassRenamerFactory.$$$reportNull$$$0(0);
        }
        return element instanceof PhpFile && FileContainingClassRenamerFactory.isFilePSR(containingFile = (PhpFile)element);
    }

    public static boolean isFilePSR(PhpFile containingFile) {
        List<? extends PhpNamedElement> classes = FileContainingClassRenamerFactory.getClasses(containingFile);
        if (classes.size() == 1) {
            PhpClass clazz = (PhpClass)classes.get(0);
            String className = clazz.getName();
            return className.equalsIgnoreCase(PhpNameUtil.getNameWithoutExtension(containingFile.getName()));
        }
        return false;
    }

    public static List<? extends PhpNamedElement> getClasses(PhpFile containingFile) {
        return containingFile.getTopLevelDefs().values().stream().filter(e -> e instanceof PhpClass).collect(Collectors.toList());
    }

    @Nls
    @Nullable
    public String getOptionName() {
        return PhpBundle.message("refactoring.rename.automatic.renamer.class.name", new Object[0]);
    }

    public boolean isEnabled() {
        return PhpRefactoringSettings.getInstance().RENAME_CLASS_IN_FILE;
    }

    public void setEnabled(boolean enabled) {
        PhpRefactoringSettings.getInstance().RENAME_CLASS_IN_FILE = enabled;
    }

    @NotNull
    public AutomaticRenamer createRenamer(PsiElement element, String newName, Collection<UsageInfo> usages) {
        ClassContainingRenamer classContainingRenamer = new ClassContainingRenamer((PhpFile)element, newName);
        if (classContainingRenamer == null) {
            FileContainingClassRenamerFactory.$$$reportNull$$$0(1);
        }
        return classContainingRenamer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/rename/automaticRenamers/FileContainingClassRenamerFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/rename/automaticRenamers/FileContainingClassRenamerFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenamer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ClassContainingRenamer
    extends AutomaticRenamer {
        List<String> myFileNames;

        ClassContainingRenamer(PhpFile containingFile, String newName) {
            PhpClass clazz;
            String className;
            String canonicalFileName = this.nameToCanonicalName(containingFile.getName(), (PsiNamedElement)containingFile);
            this.myFileNames = new ArrayList<String>();
            this.myFileNames.add(containingFile.getName());
            List<? extends PhpNamedElement> classes = FileContainingClassRenamerFactory.getClasses(containingFile);
            if (classes.size() == 1 && (className = (clazz = (PhpClass)classes.get(0)).getName()).equals(PhpNameUtil.getNameWithoutExtension(containingFile.getName()))) {
                this.myElements.add(clazz);
                Collection subclasses = PhpIndex.getInstance((Project)containingFile.getProject()).getDirectSubclasses(clazz.getFQN());
                for (PhpClass subClass : subclasses) {
                    PsiFile containingFileIt = subClass.getContainingFile();
                    if (containingFileIt instanceof PhpFile && FileContainingClassRenamerFactory.isFilePSR((PhpFile)containingFileIt)) {
                        this.myElements.add(containingFileIt);
                        this.myFileNames.add(containingFileIt.getName());
                    }
                    if (subClass.isAnonymous()) continue;
                    this.myElements.add(subClass);
                }
                this.suggestAllNames(containingFile.getName(), newName);
            }
        }

        @Nls
        public String getDialogTitle() {
            return PhpBundle.message("refactoring.rename.automatic.renamer.class.dialog.title", new Object[0]);
        }

        @Nls
        public String getDialogDescription() {
            return PhpBundle.message("refactoring.rename.automatic.renamer.class.dialog.description", new Object[0]);
        }

        public String entityName() {
            return PhpBundle.message("refactoring.rename.automatic.renamer.class.entity.name", new Object[0]);
        }

        public boolean isSelectedByDefault() {
            return true;
        }

        public void findUsages(List<UsageInfo> result, boolean searchInStringsAndComments, boolean searchInNonJavaFiles, List<UnresolvableCollisionUsageInfo> unresolvedUsages, Map<PsiElement, String> allRenames) {
            super.findUsages(result, searchInStringsAndComments, searchInNonJavaFiles, unresolvedUsages, allRenames);
            result.removeIf(i -> {
                PsiElement element = i.getElement();
                return element != null && ClassInheritorsRenamerFactory.containsFileNames(this.myFileNames, element.getText()) && i instanceof NonCodeUsageInfo && ((NonCodeUsageInfo)i).getReferencedElement() instanceof PhpFile;
            });
        }

        public boolean allowChangeSuggestedName() {
            return true;
        }
    }
}

