/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.PhpReferenceImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MemberReferenceImpl
extends PhpReferenceImpl
implements MemberReference {
    protected MemberReferenceImpl(ASTNode node) {
        super(node);
    }

    @Nullable
    public PhpExpression getClassReference() {
        PhpPsiElement firstPsiChild = this.getFirstPsiChild();
        if (firstPsiChild instanceof PhpExpression) {
            return (PhpExpression)firstPsiChild;
        }
        return null;
    }

    @NotNull
    public PhpModifier.State getReferenceType() {
        PhpExpression ref = this.getClassReference();
        if (ref != null) {
            if (!(ref instanceof Variable) && !(ref instanceof FieldReference) && "parent".equals(ref.getName())) {
                PhpModifier.State state = PhpModifier.State.PARENT;
                if (state == null) {
                    MemberReferenceImpl.$$$reportNull$$$0(0);
                }
                return state;
            }
            PsiElement nextSibling = ref.getNextSibling();
            if (PhpPsiUtil.isOfType(nextSibling, PhpTokenTypes.SCOPE_RESOLUTION)) {
                PhpModifier.State state = PhpModifier.State.STATIC;
                if (state == null) {
                    MemberReferenceImpl.$$$reportNull$$$0(1);
                }
                return state;
            }
        }
        PhpModifier.State state = PhpModifier.State.DYNAMIC;
        if (state == null) {
            MemberReferenceImpl.$$$reportNull$$$0(2);
        }
        return state;
    }

    @NotNull
    public Collection<? extends PhpNamedElement> resolveLocal() {
        Collection<? extends PhpNamedElement> collection = MemberReferenceImpl.resolveLocal(this);
        if (collection == null) {
            MemberReferenceImpl.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    public PhpType resolveLocalType() {
        PhpType resultType = new PhpType();
        Collection<? extends PhpNamedElement> phpNamedElements = this.resolveLocal();
        for (PhpNamedElement phpNamedElement : phpNamedElements) {
            PhpType type = phpNamedElement.getType();
            Set types = type.getTypes();
            for (String s : types) {
                if (("$this".equals(s) || "static".equals(s)) && phpNamedElement instanceof PhpClassMember) {
                    resultType.add((PsiElement)((PhpClassMember)phpNamedElement).getContainingClass());
                    continue;
                }
                resultType.add(s);
            }
        }
        PhpExpression classReference = this.getClassReference();
        PhpType phpType = new PhpType();
        for (String name : resultType.getTypes()) {
            if (name.equals("static") && classReference instanceof ClassReference) {
                PhpType phpType2 = phpType.add(((ClassReference)classReference).resolveLocalType());
                if (phpType2 == null) {
                    MemberReferenceImpl.$$$reportNull$$$0(4);
                }
                return phpType2;
            }
            phpType.add(name);
        }
        PhpType phpType3 = phpType;
        if (phpType3 == null) {
            MemberReferenceImpl.$$$reportNull$$$0(5);
        }
        return phpType3;
    }

    @NotNull
    private static Collection<? extends PhpNamedElement> resolveLocal(@NotNull MemberReferenceImpl reference) {
        if (reference == null) {
            MemberReferenceImpl.$$$reportNull$$$0(6);
        }
        THashSet result = new THashSet();
        PhpExpression classReference = reference.getClassReference();
        if (classReference instanceof PhpReference) {
            PhpClass aClass;
            if (MemberReferenceImpl.getDepth(classReference) >= 100) {
                Set set = Collections.emptySet();
                if (set == null) {
                    MemberReferenceImpl.$$$reportNull$$$0(7);
                }
                return set;
            }
            if (PhpLangUtil.isThisReference((PsiElement)classReference) && (aClass = (PhpClass)PhpPsiUtil.getParentByCondition((PsiElement)classReference, true, (Condition<? super PsiElement>)PhpClass.INSTANCEOF)) != null && !aClass.isTrait()) {
                result.addAll(reference.resolveMember(aClass, true));
                THashSet tHashSet = result;
                if (tHashSet == null) {
                    MemberReferenceImpl.$$$reportNull$$$0(8);
                }
                return tHashSet;
            }
            Collection phpNamedElements = ((PhpReference)classReference).resolveLocal();
            for (PhpNamedElement element : phpNamedElements) {
                PhpType type = element.getType();
                Set types = type.getTypes();
                PsiFile file = reference.getContainingFile();
                if (!(file instanceof PhpFile)) continue;
                MultiMap defs = ((PhpFile)file).getTopLevelDefs();
                for (String fqn : types) {
                    Collection aClasses = defs.get((Object)fqn);
                    for (PhpNamedElement aClass2 : aClasses) {
                        if (!(aClass2 instanceof PhpClass) || ((PhpClass)aClass2).isTrait()) continue;
                        Set<? extends PhpNamedElement> elements = reference.resolveMember((PhpClass)aClass2, true);
                        result.addAll(elements);
                    }
                }
            }
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            MemberReferenceImpl.$$$reportNull$$$0(9);
        }
        return tHashSet;
    }

    @NotNull
    public Collection<? extends PhpNamedElement> resolveGlobal(boolean incompleteCode) {
        THashSet result = new THashSet();
        PhpExpression classReference = this.getClassReference();
        if (classReference != null) {
            PhpExpression cr = classReference;
            if (MemberReferenceImpl.getDepth(cr) >= 100) {
                Set set = Collections.emptySet();
                if (set == null) {
                    MemberReferenceImpl.$$$reportNull$$$0(10);
                }
                return set;
            }
            Project project = this.getProject();
            PhpType phpType = classReference.getType();
            phpType = phpType.globalLocationAware((PsiElement)classReference);
            Set types = phpType.getTypes();
            for (String fqn : types) {
                List<PhpClass> classes;
                PhpClass aClass;
                while (classReference instanceof MemberReference && ("$this".equals(fqn) || "static".equals(fqn))) {
                    if ((classReference = ((MemberReference)classReference).getClassReference()) == null) continue;
                    fqn = (String)ContainerUtil.getFirstItem((Collection)classReference.getType().global(project).getTypes());
                }
                if ((classReference instanceof Variable || classReference instanceof NewExpression) && ("$this".equals(fqn) || "static".equals(fqn))) {
                    aClass = (PhpClass)PhpPsiUtil.getParentByCondition((PsiElement)classReference, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
                    if (aClass == null) continue;
                    fqn = aClass.getFQN();
                }
                if ((aClass = (PhpClass)PhpPsiUtil.getParentByCondition((PsiElement)classReference, true, (Condition<? super PsiElement>)PhpClass.INSTANCEOF)) != null && PhpLangUtil.equalsClassNames(aClass.getFQN(), fqn)) {
                    result.addAll(this.resolveMember(aClass, false));
                    if (!result.isEmpty() || !aClass.isTrait()) continue;
                    AtomicInteger count = new AtomicInteger(0);
                    PhpIndex.getInstance((Project)project).processNestedTraitUsages(aClass, null, arg_0 -> this.lambda$resolveGlobal$0((Set)result, count, arg_0));
                    continue;
                }
                if (fqn != null && fqn.startsWith("__anonymous@")) {
                    fqn = fqn.substring("__anonymous@".length());
                    PhpClass phpClass = (PhpClass)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)this.getContainingFile(), (int)Integer.parseInt(fqn), PhpClass.class, (boolean)true);
                    classes = phpClass != null ? Collections.singletonList(phpClass) : ContainerUtil.emptyList();
                } else {
                    classes = PhpIndex.getInstance((Project)project).getAnyByFQN(fqn);
                }
                if (aClass != null && classes.contains(aClass)) {
                    result.addAll(this.resolveMember(aClass, false));
                    continue;
                }
                for (PhpClass phpClass : classes) {
                    result.addAll(this.resolveMember(phpClass, false));
                }
            }
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            MemberReferenceImpl.$$$reportNull$$$0(11);
        }
        return tHashSet;
    }

    public static int getDepth(PhpExpression reference) {
        int d = 0;
        while (reference instanceof MemberReference && ++d <= 101) {
            reference = ((MemberReference)reference).getClassReference();
        }
        return d;
    }

    @NotNull
    public String getSignature() {
        PhpExpression reference = this.getClassReference();
        StringBuilder result = new StringBuilder();
        if (reference != null) {
            Set types = reference.getType().getTypes();
            for (String type : types) {
                String rs;
                if (PhpType.isNotExtendablePrimitiveType((String)type) || (rs = PhpTypeSignatureKey.CLASS.signIfUnsigned(type)).length() <= 2) continue;
                if (result.length() > 0) {
                    result.append('|');
                }
                result.append(this.getTypeSignatureKey().sign((CharSequence)(rs + "." + this.getName())));
            }
        }
        String string = result.toString();
        if (string == null) {
            MemberReferenceImpl.$$$reportNull$$$0(12);
        }
        return string;
    }

    public boolean isStatic() {
        return this.findChildByType(PhpTokenTypes.SCOPE_RESOLUTION) != null;
    }

    protected abstract PhpTypeSignatureKey getTypeSignatureKey();

    protected abstract Set<? extends PhpNamedElement> resolveMember(@NotNull PhpClass var1, boolean var2);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            MemberReferenceImpl.$$$reportNull$$$0(13);
        }
        if (!(element instanceof PhpClassMember)) return false;
        if (!Arrays.stream(this.multiResolve(false)).filter(ResolveResult::isValidResult).map(ResolveResult::getElement).anyMatch(element::equals)) return false;
        return true;
    }

    private /* synthetic */ boolean lambda$resolveGlobal$0(Set result, AtomicInteger count, PhpClass aClass1) {
        Set<? extends PhpNamedElement> elements = this.resolveMember(aClass1, false);
        result.addAll(elements);
        return result.size() < 100 && count.incrementAndGet() < 1000;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/MemberReferenceImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceType";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocal";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocalType";
                break;
            }
            case 6: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/MemberReferenceImpl";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveGlobal";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignature";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocal";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

