/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.lexer.managers;

import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.lexer._PhpLexer;
import com.jetbrains.php.lang.lexer.managers.ReadingManager;

public class DqStringManager
extends ReadingManager {
    public DqStringManager(_PhpLexer lexer) {
        super(lexer);
    }

    public IElementType tryStringBody(_PhpLexer lexer, char quote, IElementType bodyType, IElementType endType) {
        int eatResult = this.eat(quote);
        if (eatResult == 0) {
            lexer.sManager.toPreviousState();
            return endType;
        }
        if (eatResult == -1) {
            ++lexer.zzMarkedPos;
            return PhpTokenTypes.ESCAPE_SEQUENCE;
        }
        if (eatResult < 0) {
            throw new RuntimeException(lexer.zzBuffer + "@@@" + lexer.zzCurrentPos);
        }
        lexer.zzMarkedPos += eatResult - 1;
        return bodyType;
    }

    private int eat(char quote) {
        int pos = 0;
        int s = 0;
        while (true) {
            char c;
            if ((c = this.safeReadAt(pos)) == quote) {
                int slashCount = 0;
                int slashPos = pos;
                while (this.safeReadAt(--slashPos) == '\\') {
                    ++slashCount;
                }
                if (slashCount % 2 != 1) {
                    return pos - s;
                }
            } else {
                if (c == '\uffff') {
                    return pos > 0 ? pos - s : 0;
                }
                if (Character.isHighSurrogate(c)) {
                    ++s;
                } else {
                    if (this.checkForExprSubstitution(pos)) {
                        return pos > 0 ? pos - s : -3;
                    }
                    if (this.checkForVariable(pos)) {
                        return pos > 0 ? pos - s : -4;
                    }
                }
            }
            ++pos;
        }
    }

    @Override
    public void reset() {
        super.reset();
    }
}

