/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.ui.HyperlinkLabel;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpThrownExceptionsAnalyzer;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocMissingThrowsInspection;
import com.jetbrains.php.lang.inspections.probablyBug.PhpUnhandledExceptionInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddCatchClauseQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddThrowsTagQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpSurroundWithTryCatchQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.PhpThrow;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/php/lang/inspections/probablyBug/PhpUnhandledExceptionInspection;", "Lcom/jetbrains/php/lang/inspections/PhpInspection;", "()V", "buildVisitor", "Lcom/jetbrains/php/lang/psi/visitors/PhpElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "createOptionsPanel", "Ljavax/swing/JComponent;", "Companion", "intellij.php.impl"})
public final class PhpUnhandledExceptionInspection
extends PhpInspection {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public PhpElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return new PhpElementVisitor(isOnTheFly, holder){
            final /* synthetic */ boolean $isOnTheFly;
            final /* synthetic */ ProblemsHolder $holder;

            public void visitPhpMethodReference(@NotNull MethodReference reference) {
                Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
                this.analyze((PsiElement)reference);
            }

            public void visitPhpFunctionCall(@NotNull FunctionReference reference) {
                Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
                this.analyze((PsiElement)reference);
            }

            public void visitPhpNewExpression(@NotNull NewExpression expression) {
                Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
                this.analyze((PsiElement)expression);
            }

            public void visitPhpThrow(@NotNull PhpThrow throwStatement) {
                Intrinsics.checkParameterIsNotNull((Object)throwStatement, (String)"throwStatement");
                this.analyze((PsiElement)throwStatement);
            }

            private final void analyze(PsiElement e) {
                Set<PhpType> uncaughtExceptions;
                Collection collection;
                Function containingFunction;
                if (this.isInjectedFragment(e)) {
                    return;
                }
                Function function = containingFunction = (Function)PhpPsiUtil.getParentByCondition(e, (Condition<? super PsiElement>)Function.INSTANCEOF);
                if (function != null) {
                    if (function.isClosure()) {
                        return;
                    }
                }
                if (!(collection = (Collection)(uncaughtExceptions = PhpUnhandledExceptionInspection.Companion.getExceptionClasses(e))).isEmpty()) {
                    PsiElement psiElement = this.extractNameNode(e);
                    if (psiElement == null) {
                        psiElement = e;
                    }
                    PsiElement nameNode = psiElement;
                    String message = this.getMessage(uncaughtExceptions, containingFunction, this.$isOnTheFly);
                    Collection<PhpType> undocumentedExceptions = this.getUndocumentedExceptions(uncaughtExceptions, containingFunction);
                    if (undocumentedExceptions.isEmpty()) {
                        if (this.$isOnTheFly) {
                            LocalQuickFix[] localQuickFixArray = this.getFixes(e, SetsKt.emptySet(), containingFunction);
                            this.$holder.registerProblem(nameNode, message, ProblemHighlightType.INFORMATION, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
                        }
                    } else {
                        LocalQuickFix[] localQuickFixArray = this.getFixes(e, undocumentedExceptions, containingFunction);
                        this.$holder.registerProblem(nameNode, message, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
                    }
                }
            }

            private final boolean isInjectedFragment(@NotNull PsiElement $receiver) {
                return InjectedLanguageManager.getInstance((Project)$receiver.getProject()).isInjectedFragment($receiver.getContainingFile());
            }

            private final PsiElement extractNameNode(PsiElement element) {
                Object object;
                PsiElement psiElement = element;
                if (psiElement instanceof FunctionReference) {
                    ASTNode aSTNode = ((FunctionReference)element).getNameNode();
                    object = aSTNode != null ? aSTNode.getPsi() : null;
                } else if (psiElement instanceof NewExpression) {
                    ClassReference classReference = ((NewExpression)element).getClassReference();
                    object = classReference != null && (classReference = classReference.getNameNode()) != null ? classReference.getPsi() : null;
                } else if (psiElement instanceof PhpThrow) {
                    object = ((PhpThrow)element).getFirstChild();
                } else {
                    throw (Throwable)new IllegalArgumentException("Unexpected element of type " + element.getClass().getName());
                }
                return object;
            }

            /*
             * WARNING - void declaration
             */
            private final Collection<PhpType> getUndocumentedExceptions(Set<? extends PhpType> uncaughtExceptions, Function containingFunction) {
                Collection<PhpType> collection;
                if (containingFunction != null) {
                    PhpType phpType;
                    Collection collection2;
                    List docExceptions = new ArrayList<E>();
                    List<PhpDocTag> list = PhpDocUtil.collectTagsConsideringInheritance(containingFunction, "@throws");
                    Intrinsics.checkExpressionValueIsNotNull(list, (String)"PhpDocUtil.collectTagsCo\u2026n, PhpDocUtil.THROWS_TAG)");
                    PhpDocTag[] $receiver$iv = (PhpDocTag[])list;
                    for (T t : $receiver$iv) {
                        void it;
                        PhpDocTag phpDocTag = (PhpDocTag)t;
                        collection2 = docExceptions;
                        void v1 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                        Intrinsics.checkExpressionValueIsNotNull((Object)v1.getType(), (String)"it.type");
                        collection2.add(phpType);
                    }
                    Collection cfr_ignored_0 = (Collection)docExceptions;
                    PhpDocTag[] phpDocTagArray = containingFunction.getDocComment();
                    if (phpDocTagArray != null && (phpDocTagArray = phpDocTagArray.getTagElementsByName("@expectedException")) != null) {
                        PhpDocTag[] phpDocTagArray2 = $receiver$iv = phpDocTagArray;
                        int n = phpDocTagArray2.length;
                        for (int i = 0; i < n; ++i) {
                            void it;
                            PhpDocTag item$iv;
                            PhpDocTag $i$f$mapTo = item$iv = phpDocTagArray2[i];
                            collection2 = docExceptions;
                            void v3 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
                            Intrinsics.checkExpressionValueIsNotNull((Object)v3.getType(), (String)"it.type");
                            collection2.add(phpType);
                        }
                        List cfr_ignored_1 = (List)((Collection)docExceptions);
                    }
                    Collection<PhpType> collection3 = PhpDocMissingThrowsInspection.getUndocumentedExceptions((Collection<PhpType>)uncaughtExceptions, docExceptions, containingFunction);
                    collection = collection3;
                    Intrinsics.checkExpressionValueIsNotNull(collection3, (String)"PhpDocMissingThrowsInspe\u2026ions, containingFunction)");
                } else {
                    collection = (Collection<PhpType>)uncaughtExceptions;
                }
                return collection;
            }

            private final String getMessage(Set<? extends PhpType> uncaughtExceptions, Function containingFunction, boolean onTheFly) {
                String string;
                if (uncaughtExceptions.size() == 1 && onTheFly) {
                    Function function = containingFunction;
                    string = "Unhandled " + ((PhpType)CollectionsKt.single((Iterable)uncaughtExceptions)).toStringRelativized(function != null ? function.getNamespaceName() : null);
                } else {
                    string = "Unhandled exceptions";
                }
                return string;
            }

            private final LocalQuickFix[] getFixes(PsiElement e, Collection<? extends PhpType> undocumentedExceptions, Function containingFunction) {
                Collection $receiver$iv;
                List fixes = new ArrayList<E>();
                if (!(e instanceof PhpThrow)) {
                    if (PhpPsiUtil.getParentByCondition(e, (Condition<? super PsiElement>)((Condition)buildVisitor.getFixes.1.INSTANCE)) != null) {
                        fixes.add(PhpAddCatchClauseQuickFix.Companion.getINSTANCE());
                    }
                    fixes.add(PhpSurroundWithTryCatchQuickFix.Companion.getINSTANCE());
                }
                if (undocumentedExceptions.size() == 1) {
                    Function function = containingFunction;
                    if ((function != null ? function.getDocComment() : null) != null) {
                        fixes.add(new PhpAddThrowsTagQuickFix((PhpType)CollectionsKt.single((Iterable)undocumentedExceptions)));
                    }
                }
                Collection thisCollection$iv = $receiver$iv = (Collection)fixes;
                LocalQuickFix[] localQuickFixArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
                if (localQuickFixArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                return localQuickFixArray;
            }
            {
                this.$isOnTheFly = $captured_local_variable$0;
                this.$holder = $captured_local_variable$1;
            }
        };
    }

    @NotNull
    public JComponent createOptionsPanel() {
        HyperlinkLabel settingsLink = new HyperlinkLabel(PhpBundle.message("exception.analysis.settings.path", new Object[0]));
        settingsLink.addHyperlinkListener((HyperlinkListener)createOptionsPanel.1.INSTANCE);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)settingsLink, "North");
        return panel;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/php/lang/inspections/probablyBug/PhpUnhandledExceptionInspection$Companion;", "", "()V", "getExceptionClasses", "", "Lcom/jetbrains/php/lang/psi/resolve/types/PhpType;", "Lcom/intellij/psi/PsiElement;", "intellij.php.impl"})
    public static final class Companion {
        @NotNull
        public final Set<PhpType> getExceptionClasses(@NotNull PsiElement $receiver) {
            PhpScopeHolder scope;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
            if (($receiver instanceof FunctionReference || $receiver instanceof NewExpression || $receiver instanceof PhpThrow) && (scope = PhpPsiUtil.getScopeHolder($receiver)) != null) {
                Set<PhpType> set = PhpThrownExceptionsAnalyzer.getExceptionClasses(scope, $receiver.getTextRange(), null, true, true);
                Intrinsics.checkExpressionValueIsNotNull(set, (String)"PhpThrownExceptionsAnaly\u2026tRange, null, true, true)");
                return set;
            }
            return SetsKt.emptySet();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

