/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.validation;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpInfoValidationMessage;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;

public abstract class PhpDebugConfiguration {
    private static final String REQ_MODE = "req";
    private static final String JIT_MODE = "jit";

    @Nullable
    public static PhpDebugConfiguration parse(@NotNull Attributes attributes) {
        String name;
        if (attributes == null) {
            PhpDebugConfiguration.$$$reportNull$$$0(0);
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)(name = attributes.getValue("name")), (CharSequence)"xdebug")) {
            return XdebugConfiguration.parseConfiguration(attributes);
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)"Zend Debugger")) {
            return ZendDebugConfiguration.parseConfiguration(attributes);
        }
        return null;
    }

    public abstract void validate(@NotNull List<PhpInfoValidationMessage> var1, @Nullable PhpProjectDebugConfiguration.State var2, @NotNull String var3, @Nullable String var4);

    @NotNull
    private static String getDescriptionByMessage(@NotNull String message, @Nullable String documentationUrl) {
        if (message == null) {
            PhpDebugConfiguration.$$$reportNull$$$0(1);
        }
        if (StringUtil.isEmpty((String)documentationUrl)) {
            String string = message;
            if (string == null) {
                PhpDebugConfiguration.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = message + "<br>" + PhpDebugConfiguration.getDocumentation(documentationUrl);
        if (string == null) {
            PhpDebugConfiguration.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    private static String getDescription(@NotNull String messageKey, @Nullable String documentationUrl) {
        if (messageKey == null) {
            PhpDebugConfiguration.$$$reportNull$$$0(4);
        }
        String message = PhpBundle.message(messageKey, new Object[0]);
        String string = PhpDebugConfiguration.getDescriptionByMessage(message, documentationUrl);
        if (string == null) {
            PhpDebugConfiguration.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private static String getDocumentation(@NotNull String documentationUrl) {
        if (documentationUrl == null) {
            PhpDebugConfiguration.$$$reportNull$$$0(6);
        }
        String string = PhpBundle.message("php.web.server.validation.reference.to.documentation", documentationUrl);
        if (string == null) {
            PhpDebugConfiguration.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static boolean isLocalhost(@Nullable String host) {
        return "localhost".equals(host) || "127.0.0.1".equals(host);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/validation/PhpDebugConfiguration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageKey";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentationUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/validation/PhpDebugConfiguration";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionByMessage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptionByMessage";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDescription";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ZendDebugConfiguration
    extends PhpDebugConfiguration {
        private ExposeRemotely myRemoteMode;
        private String myHost;
        private String myDenyHosts;

        private ZendDebugConfiguration() {
        }

        @NotNull
        protected static ZendDebugConfiguration parseConfiguration(@NotNull Attributes attributes) {
            if (attributes == null) {
                ZendDebugConfiguration.$$$reportNull$$$0(0);
            }
            ZendDebugConfiguration configuration = new ZendDebugConfiguration();
            configuration.myRemoteMode = ExposeRemotely.getInstance(attributes.getValue("enable"));
            configuration.myHost = attributes.getValue("host");
            configuration.myDenyHosts = attributes.getValue("deny_hosts");
            ZendDebugConfiguration zendDebugConfiguration = configuration;
            if (zendDebugConfiguration == null) {
                ZendDebugConfiguration.$$$reportNull$$$0(1);
            }
            return zendDebugConfiguration;
        }

        @Override
        public void validate(@NotNull List<PhpInfoValidationMessage> messages, @Nullable PhpProjectDebugConfiguration.State state, @NotNull String serverHost, @Nullable String remoteAddr) {
            String message;
            boolean isLocalServer;
            if (messages == null) {
                ZendDebugConfiguration.$$$reportNull$$$0(2);
            }
            if (serverHost == null) {
                ZendDebugConfiguration.$$$reportNull$$$0(3);
            }
            String name = PhpDebugUtil.getDebuggerNameById("php.debugger.ZendDebugger");
            messages.add(PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.loaded.debugger.extension", name), null));
            boolean bl = isLocalServer = PhpDebugConfiguration.isLocalhost(serverHost) || PhpDebugConfiguration.isLocalhost(remoteAddr);
            if (!isLocalServer && PhpDebugConfiguration.isLocalhost(this.myHost.trim())) {
                String description = PhpBundle.message("php.web.server.validation.zend.debugger.localhost.description", new Object[0]);
                messages.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.zend.debugger.localhost", new Object[0]), description));
            } else if (StringUtil.isNotEmpty((String)this.myHost)) {
                messages.add(PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.zend.debugger.host", this.myHost), null));
            }
            if (StringUtil.isNotEmpty((String)this.myDenyHosts)) {
                message = PhpBundle.message("php.web.server.validation.zend.debugger.deny.host", this.myDenyHosts);
                messages.add(PhpInfoValidationMessage.error(message, PhpBundle.message("php.web.server.validation.zend.debugger.deny.host.description", new Object[0])));
            }
            message = PhpBundle.message("php.web.server.validation.zend.expose.remotely", this.myRemoteMode.getPresentableName());
            messages.add(PhpInfoValidationMessage.message(this.myRemoteMode == ExposeRemotely.NEVER ? PhpInfoValidationMessage.MessageType.ERROR : PhpInfoValidationMessage.MessageType.INFO, message, ZendDebugConfiguration.getDescription(this.myRemoteMode)));
        }

        @NotNull
        private static String getDescription(@NotNull ExposeRemotely mode) {
            if (mode == null) {
                ZendDebugConfiguration.$$$reportNull$$$0(4);
            }
            switch (mode) {
                case ALLOWED_HOSTS: {
                    String string = PhpBundle.message("php.web.server.validation.zend.expose.remotely.allowed.hosts.description", new Object[0]);
                    if (string == null) {
                        ZendDebugConfiguration.$$$reportNull$$$0(5);
                    }
                    return string;
                }
                case ALWAYS: {
                    String string = PhpBundle.message("php.web.server.validation.zend.expose.remotely.always.description", new Object[0]);
                    if (string == null) {
                        ZendDebugConfiguration.$$$reportNull$$$0(6);
                    }
                    return string;
                }
            }
            String string = PhpBundle.message("php.web.server.validation.zend.expose.remotely.never.description", new Object[0]);
            if (string == null) {
                ZendDebugConfiguration.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 1: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/debug/validation/PhpDebugConfiguration$ZendDebugConfiguration";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "messages";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serverHost";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/debug/validation/PhpDebugConfiguration$ZendDebugConfiguration";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parseConfiguration";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "parseConfiguration";
                    break;
                }
                case 1: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "validate";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getDescription";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static enum ExposeRemotely {
            ALWAYS("always", ContainerUtil.newArrayList((Object[])new String[]{"always", "1"})),
            ALLOWED_HOSTS("allowed hosts only", ContainerUtil.newArrayList((Object[])new String[]{"allowed_hosts", "2"})),
            NEVER("never", ContainerUtil.emptyList());

            private final String myPresentableName;
            private final List<String> myKeys;

            private ExposeRemotely(String name, List<String> keys) {
                if (name == null) {
                    ExposeRemotely.$$$reportNull$$$0(0);
                }
                if (keys == null) {
                    ExposeRemotely.$$$reportNull$$$0(1);
                }
                this.myPresentableName = name;
                this.myKeys = keys;
            }

            @NotNull
            public String getPresentableName() {
                String string = this.myPresentableName;
                if (string == null) {
                    ExposeRemotely.$$$reportNull$$$0(2);
                }
                return string;
            }

            public static ExposeRemotely getInstance(@Nullable String inputKey) {
                if (StringUtil.isNotEmpty((String)inputKey)) {
                    for (ExposeRemotely option : ExposeRemotely.values()) {
                        for (String optionKey : option.myKeys) {
                            if (!optionKey.equalsIgnoreCase(inputKey)) continue;
                            return option;
                        }
                    }
                }
                return NEVER;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "keys";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/debug/validation/PhpDebugConfiguration$ZendDebugConfiguration$ExposeRemotely";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/debug/validation/PhpDebugConfiguration$ZendDebugConfiguration$ExposeRemotely";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPresentableName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }

    private static class XdebugConfiguration
    extends PhpDebugConfiguration {
        private static final String XDEBUG_REMOTE_ENABLE_URL = "http://xdebug.org/docs/all_settings#remote_enable";
        private static final String XDEBUG_REMOTE_HOST_URL = "http://xdebug.org/docs/all_settings#remote_host";
        private static final String XDEBUG_REMOTE_PORT_URL = "http://xdebug.org/docs/all_settings#remote_port";
        private static final String XDEBUG_REMOTE_AUTOSTART_URL = "http://xdebug.org/docs/all_settings#remote_autostart";
        private static final String XDEBUG_REMOTE_CONNECT_BACK_URL = "http://xdebug.org/docs/all_settings#remote_connect_back";
        private static final String XDEBUG_REMOTE_MODE_URL = "http://xdebug.org/docs/all_settings#remote_mode";
        private static final String DBGP = "dbgp";
        private static final int MIN_PORT = 1024;
        private String myVersion;
        private boolean myIsLoadedByZendExtension;
        private boolean myIsRemoteEnable;
        private String myProtocol;
        private String myHost;
        private String myPort;
        private String myMode;
        private String myLog;
        private boolean myIsAutostartEnabled;
        private boolean myIsConnectBack;

        private XdebugConfiguration() {
        }

        @NotNull
        protected static XdebugConfiguration parseConfiguration(@NotNull Attributes attributes) {
            if (attributes == null) {
                XdebugConfiguration.$$$reportNull$$$0(0);
            }
            XdebugConfiguration configuration = new XdebugConfiguration();
            configuration.myIsLoadedByZendExtension = "1".equals(attributes.getValue("zend_extension"));
            configuration.myIsRemoteEnable = "1".equals(attributes.getValue("enable"));
            configuration.myVersion = attributes.getValue("version");
            configuration.myHost = attributes.getValue("host");
            configuration.myPort = attributes.getValue("port");
            configuration.myMode = attributes.getValue("mode");
            configuration.myProtocol = attributes.getValue("protocol");
            configuration.myLog = attributes.getValue("log");
            configuration.myIsAutostartEnabled = "1".equals(attributes.getValue("autostart"));
            configuration.myIsConnectBack = "1".equals(attributes.getValue("connect_back"));
            XdebugConfiguration xdebugConfiguration = configuration;
            if (xdebugConfiguration == null) {
                XdebugConfiguration.$$$reportNull$$$0(1);
            }
            return xdebugConfiguration;
        }

        @Override
        public void validate(@NotNull List<PhpInfoValidationMessage> messages, @Nullable PhpProjectDebugConfiguration.State state, @NotNull String serverHost, @Nullable String remoteAddr) {
            String description;
            if (messages == null) {
                XdebugConfiguration.$$$reportNull$$$0(2);
            }
            if (serverHost == null) {
                XdebugConfiguration.$$$reportNull$$$0(3);
            }
            String name = PhpDebugUtil.getDebuggerNameById("php.debugger.XDebug") + (this.myVersion == null ? "" : " " + this.myVersion);
            messages.add(PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.loaded.debugger.extension", name), null));
            if (!this.myIsLoadedByZendExtension) {
                String description2 = PhpDebugConfiguration.getDescription("php.web.server.validation.xdebug.zend.extension.load.description", null);
                messages.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.xdebug.zend.extension.load", new Object[0]), description2));
            }
            if (StringUtil.isNotEmpty((String)this.myHost)) {
                boolean isLocalServer;
                boolean bl = isLocalServer = PhpDebugConfiguration.isLocalhost(serverHost) || PhpDebugConfiguration.isLocalhost(remoteAddr);
                if (!isLocalServer && PhpDebugConfiguration.isLocalhost(this.myHost)) {
                    String details = PhpBundle.message("php.web.server.validation.xdebug.debugger.host.description", new Object[0]);
                    if (StringUtil.isNotEmpty((String)remoteAddr)) {
                        details = details + PhpBundle.message("php.web.server.validation.xdebug.debugger.host.remote.addr", remoteAddr);
                    }
                    String description3 = PhpDebugConfiguration.getDescriptionByMessage(details, XDEBUG_REMOTE_HOST_URL);
                    messages.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.xdebug.debugger.localhost", this.myHost), description3));
                } else {
                    description = PhpDebugConfiguration.getDescription("php.web.server.validation.xdebug.debugger.host.description", XDEBUG_REMOTE_HOST_URL);
                    messages.add(PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.xdebug.debugger.host", this.myHost), description));
                }
            }
            try {
                int port = Integer.valueOf(this.myPort);
                if (state != null && state.getXDebugDebugPort() != port) {
                    String portInIde = String.valueOf(state.getXDebugDebugPort());
                    String message = PhpBundle.message("php.web.server.validation.xdebug.wrong.port", this.myPort, portInIde);
                    String description4 = PhpDebugConfiguration.getDescription("php.web.server.validation.xdebug.wrong.port.description", XDEBUG_REMOTE_PORT_URL);
                    messages.add(PhpInfoValidationMessage.error(message, description4));
                } else if (port < 1024) {
                    description = PhpBundle.message("php.web.server.validation.xdebug.port.require.sudo.description", new Object[0]);
                    messages.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.xdebug.port.require.sudo", this.myPort), description));
                } else {
                    messages.add(PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.xdebug.port", this.myPort), null));
                }
            }
            catch (Exception e) {
                messages.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.xdebug.wrong.port.format", this.myPort), null));
            }
            if (!this.myIsRemoteEnable) {
                String description5 = PhpDebugConfiguration.getDescription("php.web.server.validation.xdebug.remote.is.not.enable.description", XDEBUG_REMOTE_ENABLE_URL);
                messages.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.xdebug.remote.is.not.enable", new Object[0]), description5));
            }
            if (this.myIsAutostartEnabled) {
                String description6 = PhpDebugConfiguration.getDescription("php.web.server.validation.xdebug.remote.autostart.description", XDEBUG_REMOTE_AUTOSTART_URL);
                messages.add(PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.xdebug.remote.autostart", new Object[0]), description6));
            }
            if (this.myIsConnectBack) {
                String description7 = PhpDebugConfiguration.getDescription("php.web.server.validation.xdebug.remote.connect.back.description", XDEBUG_REMOTE_CONNECT_BACK_URL);
                messages.add(PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.xdebug.remote.connect.back", new Object[0]), description7));
            }
            if (StringUtil.equals((CharSequence)this.myMode, (CharSequence)PhpDebugConfiguration.REQ_MODE)) {
                String description8 = PhpDebugConfiguration.getDescription("php.web.server.validation.xdebug.remote.mode.req.description", XDEBUG_REMOTE_MODE_URL);
                messages.add(PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.xdebug.remote.mode.req", new Object[0]), description8));
            } else if (StringUtil.equals((CharSequence)this.myMode, (CharSequence)PhpDebugConfiguration.JIT_MODE)) {
                String description9 = PhpDebugConfiguration.getDescription("php.web.server.validation.xdebug.remote.mode.jit.description", XDEBUG_REMOTE_MODE_URL);
                messages.add(PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.xdebug.remote.mode.jit", new Object[0]), description9));
            } else {
                String message = PhpBundle.message("php.web.server.validation.xdebug.mode.is.not.supported", this.myMode);
                messages.add(PhpInfoValidationMessage.error(message, PhpDebugConfiguration.getDocumentation(XDEBUG_REMOTE_MODE_URL)));
            }
            if (StringUtil.isNotEmpty((String)this.myLog)) {
                messages.add(PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.xdebug.remote.log", this.myLog), null));
            }
            if (!StringUtil.equalsIgnoreCase((CharSequence)this.myProtocol, (CharSequence)DBGP)) {
                messages.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.xdebug.protocol.is.not.supported", this.myProtocol), null));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/debug/validation/PhpDebugConfiguration$XdebugConfiguration";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "messages";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serverHost";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/debug/validation/PhpDebugConfiguration$XdebugConfiguration";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parseConfiguration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "parseConfiguration";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "validate";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

