/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.rt.engine.local.saxon9;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import net.sf.saxon.Controller;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.expr.instruct.Debugger;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.serialize.Emitter;
import org.intellij.plugins.xsltDebugger.rt.engine.local.LocalDebugger;
import org.intellij.plugins.xsltDebugger.rt.engine.local.saxon9.Saxon9TraceListener;
import org.intellij.plugins.xsltDebugger.rt.engine.local.saxon9.TracingOutputter;

public class Saxon9Support {
    public static boolean init(Transformer transformer, final LocalDebugger dbg) {
        if (transformer instanceof Controller) {
            System.out.println("SAXON 9");
            Controller controller = (Controller)transformer;
            ((Saxon9TraceListener)controller.getConfiguration().getTraceListener()).setDebugger(dbg);
            controller.getConfiguration().setLineNumbering(true);
            controller.getConfiguration().setCompileWithTracing(true);
            controller.getConfiguration().setMultiThreading(false);
            controller.getConfiguration().setSerializerFactory(new SerializerFactory(controller.getConfiguration()){

                protected Emitter newXMLEmitter() {
                    return new TracingOutputter(dbg.getEventQueue(), super.newXMLEmitter());
                }
            });
            controller.getConfiguration().setDebugger(new Debugger(){

                public SlotManager makeSlotManager() {
                    return new SlotManager(){

                        public int allocateSlotNumber(StructuredQName qName) {
                            System.out.println("qName = " + qName);
                            return super.allocateSlotNumber(qName);
                        }
                    };
                }
            });
            return true;
        }
        return false;
    }

    public static TransformerFactory createTransformerFactory() {
        TransformerFactoryImpl factory = new TransformerFactoryImpl();
        factory.setAttribute("http://saxon.sf.net/feature/traceListener", (Object)new Saxon9TraceListener());
        try {
            factory.setAttribute("http://saxon.sf.net/feature/optimizationLevel", (Object)"0");
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return factory;
    }
}

