/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import DocumentService from"@typo3/core/document-service.js";import NProgress from"nprogress";import"@typo3/backend/input/clearable.js";import"@typo3/backend/element/alert-element.js";import"@typo3/backend/element/icon-element.js";import"@typo3/backend/element/pagination.js";import DeferredAction from"@typo3/backend/action-button/deferred-action.js";import Modal from"@typo3/backend/modal.js";import Notification from"@typo3/backend/notification.js";import{SeverityEnum}from"@typo3/backend/enum/severity.js";import RegularEvent from"@typo3/core/event/regular-event.js";import AjaxRequest from"@typo3/core/ajax/ajax-request.js";var Identifiers;!function(e){e.searchForm="#recycler-form",e.searchText="#recycler-form [name=search-text]",e.searchSubmitBtn="#recycler-form button[type=submit]",e.depthSelector="#recycler-form [name=depth]",e.tableSelector="#recycler-form [name=pages]",e.recyclerTable="#itemsInRecycler",e.paginator="#recycler-index nav",e.reloadAction="a[data-action=reload]",e.undo="a[data-action=undo]",e.delete="a[data-action=delete]",e.massUndo="button[data-multi-record-selection-action=massundo]",e.massDelete="button[data-multi-record-selection-action=massdelete]"}(Identifiers||(Identifiers={}));class Recycler{constructor(){this.paging={currentPage:1,totalPages:1,totalItems:0,itemsPerPage:parseInt(TYPO3.settings.Recycler.pagingSize,10)},this.markedRecordsForMassAction=[],DocumentService.ready().then((()=>{this.initialize()}))}static refreshPageTree(){top.document.dispatchEvent(new CustomEvent("typo3:pagetree:refresh"))}registerEvents(){new RegularEvent("submit",(e=>{e.preventDefault();""!==document.querySelector(Identifiers.searchText).value&&this.loadDeletedElements()})).delegateTo(document,Identifiers.searchForm),new RegularEvent("input",((e,t)=>{const n=document.querySelector(Identifiers.searchSubmitBtn);""!==t.value?n.disabled=!1:(n.disabled=!0,this.loadDeletedElements())})).delegateTo(document,Identifiers.searchText),new RegularEvent("change",(()=>{this.loadAvailableTables().then((()=>{this.loadDeletedElements()}))})).delegateTo(document,Identifiers.depthSelector),new RegularEvent("change",(()=>{this.paging.currentPage=1,this.loadDeletedElements()})).delegateTo(document,Identifiers.tableSelector),new RegularEvent("click",this.undoRecord.bind(this)).delegateTo(document,Identifiers.undo),new RegularEvent("click",this.deleteRecord.bind(this)).delegateTo(document,Identifiers.delete),new RegularEvent("click",(e=>{e.preventDefault(),this.loadAvailableTables().then((()=>{this.loadDeletedElements()}))})).delegateTo(document,Identifiers.reloadAction),document.querySelector(Identifiers.searchText).clearable({onClear:()=>{document.querySelector(Identifiers.searchSubmitBtn).disabled=!0,this.loadDeletedElements()}}),new RegularEvent("click",(e=>{e.preventDefault();const t=e.target.closest("button");t&&("previous"===t.dataset.action?this.paging.currentPage>1&&this.paging.currentPage--:"next"===t.dataset.action?this.paging.currentPage<this.paging.totalPages&&this.paging.currentPage++:"page"===t.dataset.action&&(this.paging.currentPage=parseInt(t.querySelector("span").textContent,10)),this.loadDeletedElements())})).delegateTo(document,Identifiers.paginator),TYPO3.settings.Recycler.deleteDisable?document.querySelector(Identifiers.massDelete).remove():document.querySelector(Identifiers.massDelete).style.display="block",new RegularEvent("multiRecordSelection:checkbox:state:changed",this.handleCheckboxStateChanged.bind(this)).bindTo(document),new RegularEvent("multiRecordSelection:action:massundo",this.undoRecord.bind(this)).bindTo(document),new RegularEvent("multiRecordSelection:action:massdelete",this.deleteRecord.bind(this)).bindTo(document)}initialize(){NProgress.configure({parent:".module-loading-indicator",showSpinner:!1}),this.registerEvents(),TYPO3.settings.Recycler.depthSelection>0&&(document.querySelector(Identifiers.depthSelector).value=String(TYPO3.settings.Recycler.depthSelection)),this.loadAvailableTables().then((()=>{this.loadDeletedElements()}))}handleCheckboxStateChanged(e){const t=e.target,n=t.closest("tr"),r=n.dataset.table+":"+n.dataset.uid;if(t.checked)this.markedRecordsForMassAction.push(r);else{const e=this.markedRecordsForMassAction.indexOf(r);e>-1&&this.markedRecordsForMassAction.splice(e,1)}if(this.markedRecordsForMassAction.length>0){const e=document.querySelector(Identifiers.massUndo),t=document.querySelector(Identifiers.massDelete);e.querySelector("span.text").textContent=this.createMessage(TYPO3.lang["button.undoselected"],[this.markedRecordsForMassAction.length.toString(10)]),t.querySelector("span.text").textContent=this.createMessage(TYPO3.lang["button.deleteselected"],[this.markedRecordsForMassAction.length.toString(10)])}else this.resetMassActionButtons()}resetMassActionButtons(){const e=document.querySelector(Identifiers.massUndo),t=document.querySelector(Identifiers.massDelete);this.markedRecordsForMassAction=[],e.querySelector("span.text").textContent=TYPO3.lang["button.undo"],t.querySelector("span.text").textContent=TYPO3.lang["button.delete"],document.dispatchEvent(new CustomEvent("multiRecordSelection:actions:hide"))}async loadAvailableTables(){const e=document.querySelector(Identifiers.tableSelector),t=document.querySelector(Identifiers.depthSelector);return NProgress.start(),e.value="",this.paging.currentPage=1,new AjaxRequest(TYPO3.settings.ajaxUrls.recycler).withQueryArguments({action:"getTables",startUid:TYPO3.settings.Recycler.startUid,depth:t.value}).get().then((async t=>{const n=await t.resolve(),r=[];e.replaceChildren();for(const e of n){const t=e[0],n=e[1],a=(e[2]?e[2]:TYPO3.lang.label_allrecordtypes)+" ("+n+")",s=document.createElement("option");s.value=t,s.textContent=a,r.push(s)}return r.length>0&&(e.append(...r),""!==TYPO3.settings.Recycler.tableSelection&&(e.value=TYPO3.settings.Recycler.tableSelection)),t})).finally((()=>NProgress.done()))}async loadDeletedElements(){const e=document.querySelector(Identifiers.depthSelector),t=document.querySelector(Identifiers.tableSelector),n=document.querySelector(Identifiers.searchText);return NProgress.start(),this.resetMassActionButtons(),new AjaxRequest(TYPO3.settings.ajaxUrls.recycler).withQueryArguments({action:"getDeletedRecords",depth:e.value,startUid:TYPO3.settings.Recycler.startUid,table:t.value,filterTxt:n.value,start:(this.paging.currentPage-1)*this.paging.itemsPerPage,limit:this.paging.itemsPerPage}).get().then((async e=>{const t=document.querySelector(Identifiers.recyclerTable),n=t.querySelector("tbody"),r=await e.resolve();if(0===r.totalItems){if(null===t.parentElement.querySelector("#no-recycler-records")){const e=document.createElement("typo3-backend-alert");e.id="no-recycler-records",e.severity=SeverityEnum.info,e.message=TYPO3.lang["alert.noDeletedRecords"],e.showIcon=!0,t.parentElement.insertBefore(e,t)}}else t.parentElement.querySelector("#no-recycler-records")?.remove(),n.innerHTML=r.rows;return t.toggleAttribute("hidden",0===r.totalItems),this.buildPaginator(r.totalItems),e})).finally((()=>NProgress.done()))}deleteRecord(e,t){if(TYPO3.settings.Recycler.deleteDisable)return;const n=(t||e.target).closest("tr"),r=null===n||"TBODY"!==n.parentElement.tagName;let a,s;if(r)a=this.markedRecordsForMassAction,s=TYPO3.lang["modal.massdelete.text"];else{const e=n.dataset.uid,t=n.dataset.table,r=n.dataset.recordtitle;a=[t+":"+e],s="pages"===t?TYPO3.lang["modal.deletepage.text"]:TYPO3.lang["modal.deletecontent.text"],s=this.createMessage(s,[r,"["+a[0]+"]"])}Modal.advanced({title:TYPO3.lang["modal.delete.header"],content:s,severity:SeverityEnum.error,staticBackdrop:!0,buttons:[{text:TYPO3.lang["button.cancel"],btnClass:"btn-default",trigger:function(){Modal.dismiss()}},{text:TYPO3.lang["button.delete"],btnClass:"btn-danger",action:new DeferredAction((()=>{this.callAjaxAction("delete",a,r)}))}]})}undoRecord(e,t){const n=(t||e.target).closest("tr"),r=null===n||"TBODY"!==n.parentElement.tagName;let a,s,o;if(r)a=this.markedRecordsForMassAction,s=TYPO3.lang["modal.massundo.text"],o=!0;else{const e=n.dataset.uid,t=n.dataset.table,r=n.dataset.recordtitle;a=[t+":"+e],o="pages"===t,s=o?TYPO3.lang["modal.undopage.text"]:TYPO3.lang["modal.undocontent.text"],s=this.createMessage(s,[r,"["+a[0]+"]"]),o&&n.dataset.parentDeleted&&(s+=TYPO3.lang["modal.undo.parentpages"])}let c=null;if(o){const e=document.createElement("div"),t=document.createElement("p");t.textContent=s;const n=document.createElement("div");n.classList.add("form-check");const r=document.createElement("input");r.type="checkbox",r.id="undo-recursive",r.classList.add("form-check-input");const a=document.createElement("label");a.classList.add("form-check-label"),a.htmlFor="undo-recursive",a.textContent=TYPO3.lang["modal.undo.recursive"],n.append(r,a),e.append(t,n),c=e}else{const e=document.createElement("p");e.textContent=s,c=e}Modal.advanced({title:TYPO3.lang["modal.undo.header"],content:c,severity:SeverityEnum.ok,staticBackdrop:!0,buttons:[{text:TYPO3.lang["button.cancel"],btnClass:"btn-default",trigger:function(){Modal.dismiss()}},{text:TYPO3.lang["button.undo"],btnClass:"btn-success",action:new DeferredAction((()=>{this.callAjaxAction("undo","object"==typeof a?a:[a],r,c.querySelector("#undo-recursive")?.checked)}))}]})}async callAjaxAction(e,t,n,r=!1){const a={records:t,action:""};let s=!1;if("undo"===e)a.action="undoRecords",a.recursive=r?1:0,s=!0;else{if("delete"!==e)return null;a.action="deleteRecords"}return NProgress.start(),new AjaxRequest(TYPO3.settings.ajaxUrls.recycler).post(a).then((async e=>{const t=await e.resolve();return t.success?Notification.success("",t.message):Notification.error("",t.message),this.paging.currentPage=1,this.loadAvailableTables().then((()=>{this.loadDeletedElements(),n&&this.resetMassActionButtons(),s&&Recycler.refreshPageTree()})),e}))}createMessage(e,t){return void 0===e?"":e.replace(/\{([0-9]+)\}/g,(function(e,n){return t[n]}))}buildPaginator(e){const t=document.querySelector(Identifiers.paginator);if(0===e)return void t.replaceChildren();if(this.paging.totalItems=e,this.paging.totalPages=Math.ceil(e/this.paging.itemsPerPage),1===this.paging.totalPages)return void t.replaceChildren();const n=document.createElement("typo3-backend-pagination");n.paging=this.paging,t.replaceChildren(n)}}export default new Recycler;