/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.opensolaris.opengrok.web.Util;

public class Annotation {
    private final List<Line> lines = new ArrayList<Line>();
    private final Map<String, String> desc = new HashMap<String, String>();
    private int widestRevision;
    private int widestAuthor;
    private final String filename;
    static final Logger log = Logger.getLogger(Annotation.class.getName());

    public Annotation(String filename) {
        this.filename = filename;
    }

    public String getRevision(int line) {
        try {
            return this.lines.get((int)(line - 1)).revision;
        }
        catch (IndexOutOfBoundsException e) {
            return "";
        }
    }

    public Set<String> getRevisions() {
        HashSet<String> ret = new HashSet<String>();
        for (Line ln : this.lines) {
            ret.add(ln.revision);
        }
        return ret;
    }

    public String getAuthor(int line) {
        try {
            return this.lines.get((int)(line - 1)).author;
        }
        catch (IndexOutOfBoundsException e) {
            return "";
        }
    }

    public boolean isEnabled(int line) {
        try {
            return this.lines.get((int)(line - 1)).enabled;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    public int size() {
        return this.lines.size();
    }

    public int getWidestRevision() {
        return this.widestRevision;
    }

    public int getWidestAuthor() {
        return this.widestAuthor;
    }

    void addLine(String revision, String author, boolean enabled) {
        Line line = new Line(revision, author, enabled);
        this.lines.add(line);
        this.widestRevision = Math.max(this.widestRevision, line.revision.length());
        this.widestAuthor = Math.max(this.widestAuthor, line.author.length());
    }

    void addDesc(String revision, String description) {
        this.desc.put(revision, Util.encode(description));
    }

    public String getDesc(String revision) {
        return this.desc.get(revision);
    }

    public String getFilename() {
        return this.filename;
    }

    public void writeTooltipMap(Writer out) throws IOException {
        out.append("<script type=\"text/javascript\">\nvar desc = new Object();\n");
        for (Map.Entry<String, String> entry : this.desc.entrySet()) {
            out.append("desc['");
            out.append(entry.getKey());
            out.append("'] = \"");
            out.append(entry.getValue());
            out.append("\";\n");
        }
        out.append("</script>\n");
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        for (Line line : this.lines) {
            sw.append(line.revision);
            sw.append("|");
            sw.append(line.author);
            sw.append(": \n");
        }
        try {
            this.writeTooltipMap(sw);
        }
        catch (IOException e) {
            log.finest(e.getMessage());
        }
        return sw.toString();
    }

    private static class Line {
        final String revision;
        final String author;
        final boolean enabled;

        Line(String rev, String aut, boolean ena) {
            this.revision = rev == null ? "" : rev;
            this.author = aut == null ? "" : aut;
            this.enabled = ena;
        }
    }
}

