/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.job.config.AnalysisConfig;
import org.elasticsearch.xpack.core.ml.job.config.AnalysisLimits;
import org.elasticsearch.xpack.core.ml.job.config.DataDescription;
import org.elasticsearch.xpack.core.ml.job.config.ModelPlotConfig;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.DataCounts;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.MlStrings;
import org.elasticsearch.xpack.core.ml.utils.time.TimeUtils;

public class Job
extends AbstractDiffable<Job>
implements Writeable,
ToXContentObject {
    public static final String TYPE = "job";
    public static final String ANOMALY_DETECTOR_JOB_TYPE = "anomaly_detector";
    public static final ParseField ID = new ParseField("job_id", new String[0]);
    public static final ParseField JOB_TYPE = new ParseField("job_type", new String[0]);
    public static final ParseField JOB_VERSION = new ParseField("job_version", new String[0]);
    public static final ParseField GROUPS = new ParseField("groups", new String[0]);
    public static final ParseField ANALYSIS_CONFIG = AnalysisConfig.ANALYSIS_CONFIG;
    public static final ParseField ANALYSIS_LIMITS = new ParseField("analysis_limits", new String[0]);
    public static final ParseField CREATE_TIME = new ParseField("create_time", new String[0]);
    public static final ParseField CUSTOM_SETTINGS = new ParseField("custom_settings", new String[0]);
    public static final ParseField DATA_DESCRIPTION = new ParseField("data_description", new String[0]);
    public static final ParseField DESCRIPTION = new ParseField("description", new String[0]);
    public static final ParseField FINISHED_TIME = new ParseField("finished_time", new String[0]);
    public static final ParseField LAST_DATA_TIME = new ParseField("last_data_time", new String[0]);
    public static final ParseField ESTABLISHED_MODEL_MEMORY = new ParseField("established_model_memory", new String[0]);
    public static final ParseField MODEL_PLOT_CONFIG = new ParseField("model_plot_config", new String[0]);
    public static final ParseField RENORMALIZATION_WINDOW_DAYS = new ParseField("renormalization_window_days", new String[0]);
    public static final ParseField BACKGROUND_PERSIST_INTERVAL = new ParseField("background_persist_interval", new String[0]);
    public static final ParseField MODEL_SNAPSHOT_RETENTION_DAYS = new ParseField("model_snapshot_retention_days", new String[0]);
    public static final ParseField RESULTS_RETENTION_DAYS = new ParseField("results_retention_days", new String[0]);
    public static final ParseField MODEL_SNAPSHOT_ID = new ParseField("model_snapshot_id", new String[0]);
    public static final ParseField RESULTS_INDEX_NAME = new ParseField("results_index_name", new String[0]);
    public static final ParseField DELETING = new ParseField("deleting", new String[0]);
    public static final ParseField RESULTS_FIELD = new ParseField("jobs", new String[0]);
    public static final ObjectParser<Builder, Void> LENIENT_PARSER = Job.createParser(true);
    public static final ObjectParser<Builder, Void> STRICT_PARSER = Job.createParser(false);
    public static final TimeValue MIN_BACKGROUND_PERSIST_INTERVAL = TimeValue.timeValueHours((long)1L);
    public static final ByteSizeValue PROCESS_MEMORY_OVERHEAD = new ByteSizeValue(100L, ByteSizeUnit.MB);
    public static final long DEFAULT_MODEL_SNAPSHOT_RETENTION_DAYS = 1L;
    private final String jobId;
    private final String jobType;
    @Nullable
    private final Version jobVersion;
    private final List<String> groups;
    private final String description;
    private final Date createTime;
    private final Date finishedTime;
    private final Date lastDataTime;
    private final Long establishedModelMemory;
    private final AnalysisConfig analysisConfig;
    private final AnalysisLimits analysisLimits;
    private final DataDescription dataDescription;
    private final ModelPlotConfig modelPlotConfig;
    private final Long renormalizationWindowDays;
    private final TimeValue backgroundPersistInterval;
    private final Long modelSnapshotRetentionDays;
    private final Long resultsRetentionDays;
    private final Map<String, Object> customSettings;
    private final String modelSnapshotId;
    private final String resultsIndexName;
    private final boolean deleting;

    private static ObjectParser<Builder, Void> createParser(boolean ignoreUnknownFields) {
        ObjectParser parser = new ObjectParser("job_details", ignoreUnknownFields, Builder::new);
        parser.declareString(Builder::setId, ID);
        parser.declareString((rec$, x$0) -> ((Builder)rec$).setJobType(x$0), JOB_TYPE);
        parser.declareString((rec$, x$0) -> ((Builder)rec$).setJobVersion(x$0), JOB_VERSION);
        parser.declareStringArray(Builder::setGroups, GROUPS);
        parser.declareStringOrNull(Builder::setDescription, DESCRIPTION);
        parser.declareField(Builder::setCreateTime, p -> TimeUtils.parseTimeField(p, CREATE_TIME.getPreferredName()), CREATE_TIME, ObjectParser.ValueType.VALUE);
        parser.declareField(Builder::setFinishedTime, p -> TimeUtils.parseTimeField(p, FINISHED_TIME.getPreferredName()), FINISHED_TIME, ObjectParser.ValueType.VALUE);
        parser.declareField(Builder::setLastDataTime, p -> TimeUtils.parseTimeField(p, LAST_DATA_TIME.getPreferredName()), LAST_DATA_TIME, ObjectParser.ValueType.VALUE);
        parser.declareLong(Builder::setEstablishedModelMemory, ESTABLISHED_MODEL_MEMORY);
        parser.declareObject(Builder::setAnalysisConfig, ignoreUnknownFields ? AnalysisConfig.LENIENT_PARSER : AnalysisConfig.STRICT_PARSER, ANALYSIS_CONFIG);
        parser.declareObject(Builder::setAnalysisLimits, ignoreUnknownFields ? AnalysisLimits.LENIENT_PARSER : AnalysisLimits.STRICT_PARSER, ANALYSIS_LIMITS);
        parser.declareObject(Builder::setDataDescription, ignoreUnknownFields ? DataDescription.LENIENT_PARSER : DataDescription.STRICT_PARSER, DATA_DESCRIPTION);
        parser.declareObject(Builder::setModelPlotConfig, ignoreUnknownFields ? ModelPlotConfig.LENIENT_PARSER : ModelPlotConfig.STRICT_PARSER, MODEL_PLOT_CONFIG);
        parser.declareLong(Builder::setRenormalizationWindowDays, RENORMALIZATION_WINDOW_DAYS);
        parser.declareString((builder, val) -> builder.setBackgroundPersistInterval(TimeValue.parseTimeValue((String)val, (String)BACKGROUND_PERSIST_INTERVAL.getPreferredName())), BACKGROUND_PERSIST_INTERVAL);
        parser.declareLong(Builder::setResultsRetentionDays, RESULTS_RETENTION_DAYS);
        parser.declareLong(Builder::setModelSnapshotRetentionDays, MODEL_SNAPSHOT_RETENTION_DAYS);
        parser.declareField(Builder::setCustomSettings, (p, c) -> p.mapOrdered(), CUSTOM_SETTINGS, ObjectParser.ValueType.OBJECT);
        parser.declareStringOrNull(Builder::setModelSnapshotId, MODEL_SNAPSHOT_ID);
        parser.declareString(Builder::setResultsIndexName, RESULTS_INDEX_NAME);
        parser.declareBoolean(Builder::setDeleting, DELETING);
        return parser;
    }

    private Job(String jobId, String jobType, Version jobVersion, List<String> groups, String description, Date createTime, Date finishedTime, Date lastDataTime, Long establishedModelMemory, AnalysisConfig analysisConfig, AnalysisLimits analysisLimits, DataDescription dataDescription, ModelPlotConfig modelPlotConfig, Long renormalizationWindowDays, TimeValue backgroundPersistInterval, Long modelSnapshotRetentionDays, Long resultsRetentionDays, Map<String, Object> customSettings, String modelSnapshotId, String resultsIndexName, boolean deleting) {
        this.jobId = jobId;
        this.jobType = jobType;
        this.jobVersion = jobVersion;
        this.groups = Collections.unmodifiableList(groups);
        this.description = description;
        this.createTime = createTime;
        this.finishedTime = finishedTime;
        this.lastDataTime = lastDataTime;
        this.establishedModelMemory = establishedModelMemory;
        this.analysisConfig = analysisConfig;
        this.analysisLimits = analysisLimits;
        this.dataDescription = dataDescription;
        this.modelPlotConfig = modelPlotConfig;
        this.renormalizationWindowDays = renormalizationWindowDays;
        this.backgroundPersistInterval = backgroundPersistInterval;
        this.modelSnapshotRetentionDays = modelSnapshotRetentionDays;
        this.resultsRetentionDays = resultsRetentionDays;
        this.customSettings = customSettings == null ? null : Collections.unmodifiableMap(customSettings);
        this.modelSnapshotId = modelSnapshotId;
        this.resultsIndexName = resultsIndexName;
        this.deleting = deleting;
    }

    public Job(StreamInput in) throws IOException {
        this.jobId = in.readString();
        this.jobType = in.readString();
        this.jobVersion = in.getVersion().onOrAfter(Version.V_5_5_0) ? (in.readBoolean() ? Version.readVersion((StreamInput)in) : null) : null;
        this.groups = in.getVersion().onOrAfter(Version.V_6_1_0) ? Collections.unmodifiableList(in.readStringList()) : Collections.emptyList();
        this.description = in.readOptionalString();
        this.createTime = new Date(in.readVLong());
        this.finishedTime = in.readBoolean() ? new Date(in.readVLong()) : null;
        this.lastDataTime = in.readBoolean() ? new Date(in.readVLong()) : null;
        this.establishedModelMemory = in.getVersion().onOrAfter(Version.V_6_1_0) ? in.readOptionalLong() : null;
        this.analysisConfig = new AnalysisConfig(in);
        this.analysisLimits = (AnalysisLimits)in.readOptionalWriteable(AnalysisLimits::new);
        this.dataDescription = (DataDescription)in.readOptionalWriteable(DataDescription::new);
        this.modelPlotConfig = (ModelPlotConfig)in.readOptionalWriteable(ModelPlotConfig::new);
        this.renormalizationWindowDays = in.readOptionalLong();
        this.backgroundPersistInterval = in.readOptionalTimeValue();
        this.modelSnapshotRetentionDays = in.readOptionalLong();
        this.resultsRetentionDays = in.readOptionalLong();
        Map readCustomSettings = in.readMap();
        this.customSettings = readCustomSettings == null ? null : Collections.unmodifiableMap(readCustomSettings);
        this.modelSnapshotId = in.readOptionalString();
        this.resultsIndexName = in.readString();
        this.deleting = in.readBoolean();
    }

    public static String documentId(String jobId) {
        if (!MlStrings.isValidId(jobId)) {
            throw new IllegalArgumentException(Messages.getMessage("Invalid {0}; ''{1}'' can contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores; must start and end with alphanumeric", ID.getPreferredName(), jobId));
        }
        if (!MlStrings.hasValidLengthForId(jobId)) {
            throw new IllegalArgumentException(Messages.getMessage("The job id cannot contain more than {0,number,integer} characters.", 64));
        }
        return "anomaly_detector-" + jobId;
    }

    public String getId() {
        return this.jobId;
    }

    public String getJobType() {
        return this.jobType;
    }

    public Version getJobVersion() {
        return this.jobVersion;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public String getInitialResultsIndexName() {
        return ".ml-anomalies-" + this.resultsIndexName;
    }

    private String getResultsIndexNameNoPrefix() {
        return this.resultsIndexName;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getFinishedTime() {
        return this.finishedTime;
    }

    public Date getLastDataTime() {
        return this.lastDataTime;
    }

    public Long getEstablishedModelMemory() {
        return this.establishedModelMemory;
    }

    public AnalysisConfig getAnalysisConfig() {
        return this.analysisConfig;
    }

    public AnalysisLimits getAnalysisLimits() {
        return this.analysisLimits;
    }

    public ModelPlotConfig getModelPlotConfig() {
        return this.modelPlotConfig;
    }

    public DataDescription getDataDescription() {
        return this.dataDescription;
    }

    public Long getRenormalizationWindowDays() {
        return this.renormalizationWindowDays;
    }

    public TimeValue getBackgroundPersistInterval() {
        return this.backgroundPersistInterval;
    }

    public Long getModelSnapshotRetentionDays() {
        return this.modelSnapshotRetentionDays;
    }

    public Long getResultsRetentionDays() {
        return this.resultsRetentionDays;
    }

    public Map<String, Object> getCustomSettings() {
        return this.customSettings;
    }

    public String getModelSnapshotId() {
        return this.modelSnapshotId;
    }

    public boolean isDeleting() {
        return this.deleting;
    }

    public Collection<String> allInputFields() {
        String timeField;
        TreeSet<String> allFields = new TreeSet<String>();
        if (this.analysisConfig != null) {
            allFields.addAll(this.analysisConfig.analysisFields());
        }
        if (this.dataDescription != null && (timeField = this.dataDescription.getTimeField()) != null) {
            allFields.add(timeField);
        }
        allFields.remove("");
        allFields.remove("mlcategory");
        return allFields;
    }

    public long estimateMemoryFootprint() {
        if (this.establishedModelMemory != null && this.establishedModelMemory > 0L) {
            return this.establishedModelMemory + PROCESS_MEMORY_OVERHEAD.getBytes();
        }
        long modelMemoryLimit = 4096L;
        if (this.analysisLimits != null && this.analysisLimits.getModelMemoryLimit() != null) {
            modelMemoryLimit = this.analysisLimits.getModelMemoryLimit();
        }
        return ByteSizeUnit.MB.toBytes(modelMemoryLimit) + PROCESS_MEMORY_OVERHEAD.getBytes();
    }

    public long earliestValidTimestamp(DataCounts dataCounts) {
        long currentTime = 0L;
        Date latestRecordTimestamp = dataCounts.getLatestRecordTimeStamp();
        if (latestRecordTimestamp != null) {
            TimeValue latency = this.analysisConfig.getLatency();
            long latencyMillis = latency == null ? 0L : latency.millis();
            currentTime = latestRecordTimestamp.getTime() - latencyMillis;
        }
        return currentTime;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobId);
        out.writeString(this.jobType);
        if (out.getVersion().onOrAfter(Version.V_5_5_0)) {
            if (this.jobVersion != null) {
                out.writeBoolean(true);
                Version.writeVersion((Version)this.jobVersion, (StreamOutput)out);
            } else {
                out.writeBoolean(false);
            }
        }
        if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
            out.writeStringCollection(this.groups);
        }
        out.writeOptionalString(this.description);
        out.writeVLong(this.createTime.getTime());
        if (this.finishedTime != null) {
            out.writeBoolean(true);
            out.writeVLong(this.finishedTime.getTime());
        } else {
            out.writeBoolean(false);
        }
        if (this.lastDataTime != null) {
            out.writeBoolean(true);
            out.writeVLong(this.lastDataTime.getTime());
        } else {
            out.writeBoolean(false);
        }
        if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
            out.writeOptionalLong(this.establishedModelMemory);
        }
        this.analysisConfig.writeTo(out);
        out.writeOptionalWriteable((Writeable)this.analysisLimits);
        out.writeOptionalWriteable((Writeable)this.dataDescription);
        out.writeOptionalWriteable((Writeable)this.modelPlotConfig);
        out.writeOptionalLong(this.renormalizationWindowDays);
        out.writeOptionalTimeValue(this.backgroundPersistInterval);
        out.writeOptionalLong(this.modelSnapshotRetentionDays);
        out.writeOptionalLong(this.resultsRetentionDays);
        out.writeMap(this.customSettings);
        out.writeOptionalString(this.modelSnapshotId);
        out.writeString(this.resultsIndexName);
        out.writeBoolean(this.deleting);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.doXContentBody(builder, params);
        builder.endObject();
        return builder;
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        String humanReadableSuffix = "_string";
        builder.field(ID.getPreferredName(), this.jobId);
        builder.field(JOB_TYPE.getPreferredName(), this.jobType);
        if (this.jobVersion != null) {
            builder.field(JOB_VERSION.getPreferredName(), (ToXContent)this.jobVersion);
        }
        if (!this.groups.isEmpty()) {
            builder.field(GROUPS.getPreferredName(), this.groups);
        }
        if (this.description != null) {
            builder.field(DESCRIPTION.getPreferredName(), this.description);
        }
        builder.timeField(CREATE_TIME.getPreferredName(), CREATE_TIME.getPreferredName() + "_string", this.createTime.getTime());
        if (this.finishedTime != null) {
            builder.timeField(FINISHED_TIME.getPreferredName(), FINISHED_TIME.getPreferredName() + "_string", this.finishedTime.getTime());
        }
        if (this.lastDataTime != null) {
            builder.timeField(LAST_DATA_TIME.getPreferredName(), LAST_DATA_TIME.getPreferredName() + "_string", this.lastDataTime.getTime());
        }
        if (this.establishedModelMemory != null) {
            builder.field(ESTABLISHED_MODEL_MEMORY.getPreferredName(), this.establishedModelMemory);
        }
        builder.field(ANALYSIS_CONFIG.getPreferredName(), (ToXContent)this.analysisConfig, params);
        if (this.analysisLimits != null) {
            builder.field(ANALYSIS_LIMITS.getPreferredName(), (ToXContent)this.analysisLimits, params);
        }
        if (this.dataDescription != null) {
            builder.field(DATA_DESCRIPTION.getPreferredName(), (ToXContent)this.dataDescription, params);
        }
        if (this.modelPlotConfig != null) {
            builder.field(MODEL_PLOT_CONFIG.getPreferredName(), (ToXContent)this.modelPlotConfig, params);
        }
        if (this.renormalizationWindowDays != null) {
            builder.field(RENORMALIZATION_WINDOW_DAYS.getPreferredName(), this.renormalizationWindowDays);
        }
        if (this.backgroundPersistInterval != null) {
            builder.field(BACKGROUND_PERSIST_INTERVAL.getPreferredName(), this.backgroundPersistInterval.getStringRep());
        }
        if (this.modelSnapshotRetentionDays != null) {
            builder.field(MODEL_SNAPSHOT_RETENTION_DAYS.getPreferredName(), this.modelSnapshotRetentionDays);
        }
        if (this.resultsRetentionDays != null) {
            builder.field(RESULTS_RETENTION_DAYS.getPreferredName(), this.resultsRetentionDays);
        }
        if (this.customSettings != null) {
            builder.field(CUSTOM_SETTINGS.getPreferredName(), this.customSettings);
        }
        if (this.modelSnapshotId != null) {
            builder.field(MODEL_SNAPSHOT_ID.getPreferredName(), this.modelSnapshotId);
        }
        builder.field(RESULTS_INDEX_NAME.getPreferredName(), this.resultsIndexName);
        if (this.deleting) {
            builder.field(DELETING.getPreferredName(), this.deleting);
        }
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Job)) {
            return false;
        }
        Job that = (Job)((Object)other);
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.jobType, that.jobType) && Objects.equals(this.jobVersion, that.jobVersion) && Objects.equals(this.groups, that.groups) && Objects.equals(this.description, that.description) && Objects.equals(this.createTime, that.createTime) && Objects.equals(this.finishedTime, that.finishedTime) && Objects.equals(this.lastDataTime, that.lastDataTime) && Objects.equals(this.establishedModelMemory, that.establishedModelMemory) && Objects.equals(this.analysisConfig, that.analysisConfig) && Objects.equals(this.analysisLimits, that.analysisLimits) && Objects.equals(this.dataDescription, that.dataDescription) && Objects.equals(this.modelPlotConfig, that.modelPlotConfig) && Objects.equals(this.renormalizationWindowDays, that.renormalizationWindowDays) && Objects.equals(this.backgroundPersistInterval, that.backgroundPersistInterval) && Objects.equals(this.modelSnapshotRetentionDays, that.modelSnapshotRetentionDays) && Objects.equals(this.resultsRetentionDays, that.resultsRetentionDays) && Objects.equals(this.customSettings, that.customSettings) && Objects.equals(this.modelSnapshotId, that.modelSnapshotId) && Objects.equals(this.resultsIndexName, that.resultsIndexName) && Objects.equals(this.deleting, that.deleting);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.jobType, this.jobVersion, this.groups, this.description, this.createTime, this.finishedTime, this.lastDataTime, this.establishedModelMemory, this.analysisConfig, this.analysisLimits, this.dataDescription, this.modelPlotConfig, this.renormalizationWindowDays, this.backgroundPersistInterval, this.modelSnapshotRetentionDays, this.resultsRetentionDays, this.customSettings, this.modelSnapshotId, this.resultsIndexName, this.deleting);
    }

    public final String toString() {
        return Strings.toString((ToXContent)this);
    }

    private static void checkValueNotLessThan(long minVal, String name, Long value) {
        if (value != null && value < minVal) {
            throw new IllegalArgumentException(Messages.getMessage("{0} cannot be less than {1,number}. Value = {2,number}", name, minVal, value));
        }
    }

    public static Set<String> getCompatibleJobTypes(Version nodeVersion) {
        HashSet<String> compatibleTypes = new HashSet<String>();
        if (nodeVersion.onOrAfter(Version.V_5_4_0)) {
            compatibleTypes.add(ANOMALY_DETECTOR_JOB_TYPE);
        }
        return compatibleTypes;
    }

    public static class Builder
    implements Writeable,
    ToXContentObject {
        private String id;
        private String jobType = "anomaly_detector";
        private Version jobVersion;
        private List<String> groups = Collections.emptyList();
        private String description;
        private AnalysisConfig analysisConfig;
        private AnalysisLimits analysisLimits;
        private DataDescription dataDescription;
        private Date createTime;
        private Date finishedTime;
        private Date lastDataTime;
        private Long establishedModelMemory;
        private ModelPlotConfig modelPlotConfig;
        private Long renormalizationWindowDays;
        private TimeValue backgroundPersistInterval;
        private Long modelSnapshotRetentionDays = 1L;
        private Long resultsRetentionDays;
        private Map<String, Object> customSettings;
        private String modelSnapshotId;
        private String resultsIndexName;
        private boolean deleting;

        public Builder() {
        }

        public Builder(String id) {
            this.id = id;
        }

        public Builder(Job job) {
            this.id = job.getId();
            this.jobType = job.getJobType();
            this.jobVersion = job.getJobVersion();
            this.groups = new ArrayList<String>(job.getGroups());
            this.description = job.getDescription();
            this.analysisConfig = job.getAnalysisConfig();
            this.analysisLimits = job.getAnalysisLimits();
            this.dataDescription = job.getDataDescription();
            this.createTime = job.getCreateTime();
            this.finishedTime = job.getFinishedTime();
            this.lastDataTime = job.getLastDataTime();
            this.establishedModelMemory = job.getEstablishedModelMemory();
            this.modelPlotConfig = job.getModelPlotConfig();
            this.renormalizationWindowDays = job.getRenormalizationWindowDays();
            this.backgroundPersistInterval = job.getBackgroundPersistInterval();
            this.modelSnapshotRetentionDays = job.getModelSnapshotRetentionDays();
            this.resultsRetentionDays = job.getResultsRetentionDays();
            this.customSettings = job.getCustomSettings() == null ? null : new LinkedHashMap<String, Object>(job.getCustomSettings());
            this.modelSnapshotId = job.getModelSnapshotId();
            this.resultsIndexName = job.getResultsIndexNameNoPrefix();
            this.deleting = job.isDeleting();
        }

        public Builder(StreamInput in) throws IOException {
            this.id = in.readOptionalString();
            this.jobType = in.readString();
            if (in.getVersion().onOrAfter(Version.V_5_5_0)) {
                this.jobVersion = in.readBoolean() ? Version.readVersion((StreamInput)in) : null;
            }
            this.groups = in.getVersion().onOrAfter(Version.V_6_1_0) ? in.readStringList() : Collections.emptyList();
            this.description = in.readOptionalString();
            this.createTime = in.readBoolean() ? new Date(in.readVLong()) : null;
            this.finishedTime = in.readBoolean() ? new Date(in.readVLong()) : null;
            Date date = this.lastDataTime = in.readBoolean() ? new Date(in.readVLong()) : null;
            if (in.getVersion().onOrAfter(Version.V_6_1_0)) {
                this.establishedModelMemory = in.readOptionalLong();
            }
            this.analysisConfig = (AnalysisConfig)in.readOptionalWriteable(AnalysisConfig::new);
            this.analysisLimits = (AnalysisLimits)in.readOptionalWriteable(AnalysisLimits::new);
            this.dataDescription = (DataDescription)in.readOptionalWriteable(DataDescription::new);
            this.modelPlotConfig = (ModelPlotConfig)in.readOptionalWriteable(ModelPlotConfig::new);
            this.renormalizationWindowDays = in.readOptionalLong();
            this.backgroundPersistInterval = in.readOptionalTimeValue();
            this.modelSnapshotRetentionDays = in.readOptionalLong();
            this.resultsRetentionDays = in.readOptionalLong();
            this.customSettings = in.readMap();
            this.modelSnapshotId = in.readOptionalString();
            this.resultsIndexName = in.readOptionalString();
            this.deleting = in.readBoolean();
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public void setJobVersion(Version jobVersion) {
            this.jobVersion = jobVersion;
        }

        private void setJobVersion(String jobVersion) {
            this.jobVersion = Version.fromString((String)jobVersion);
        }

        private void setJobType(String jobType) {
            this.jobType = jobType;
        }

        public void setGroups(List<String> groups) {
            this.groups = groups == null ? Collections.emptyList() : groups;
        }

        public List<String> getGroups() {
            return this.groups;
        }

        public Builder setCustomSettings(Map<String, Object> customSettings) {
            this.customSettings = customSettings;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setAnalysisConfig(AnalysisConfig.Builder configBuilder) {
            this.analysisConfig = ExceptionsHelper.requireNonNull(configBuilder, ANALYSIS_CONFIG.getPreferredName()).build();
            return this;
        }

        public AnalysisConfig getAnalysisConfig() {
            return this.analysisConfig;
        }

        public Builder setAnalysisLimits(AnalysisLimits analysisLimits) {
            this.analysisLimits = ExceptionsHelper.requireNonNull(analysisLimits, ANALYSIS_LIMITS.getPreferredName());
            return this;
        }

        public Builder setCreateTime(Date createTime) {
            this.createTime = createTime;
            return this;
        }

        public Builder setFinishedTime(Date finishedTime) {
            this.finishedTime = finishedTime;
            return this;
        }

        public Builder setLastDataTime(Date lastDataTime) {
            this.lastDataTime = lastDataTime;
            return this;
        }

        public Builder setEstablishedModelMemory(Long establishedModelMemory) {
            this.establishedModelMemory = establishedModelMemory;
            return this;
        }

        public Builder setDataDescription(DataDescription.Builder description) {
            this.dataDescription = ExceptionsHelper.requireNonNull(description, DATA_DESCRIPTION.getPreferredName()).build();
            return this;
        }

        public Builder setModelPlotConfig(ModelPlotConfig modelPlotConfig) {
            this.modelPlotConfig = modelPlotConfig;
            return this;
        }

        public Builder setBackgroundPersistInterval(TimeValue backgroundPersistInterval) {
            this.backgroundPersistInterval = backgroundPersistInterval;
            return this;
        }

        public Builder setRenormalizationWindowDays(Long renormalizationWindowDays) {
            this.renormalizationWindowDays = renormalizationWindowDays;
            return this;
        }

        public Builder setModelSnapshotRetentionDays(Long modelSnapshotRetentionDays) {
            this.modelSnapshotRetentionDays = modelSnapshotRetentionDays;
            return this;
        }

        public Builder setResultsRetentionDays(Long resultsRetentionDays) {
            this.resultsRetentionDays = resultsRetentionDays;
            return this;
        }

        public Builder setModelSnapshotId(String modelSnapshotId) {
            this.modelSnapshotId = modelSnapshotId;
            return this;
        }

        public Builder setResultsIndexName(String resultsIndexName) {
            this.resultsIndexName = resultsIndexName;
            return this;
        }

        public Builder setDeleting(boolean deleting) {
            this.deleting = deleting;
            return this;
        }

        public List<String> invalidCreateTimeSettings() {
            ArrayList<String> invalidCreateValues = new ArrayList<String>();
            if (this.modelSnapshotId != null) {
                invalidCreateValues.add(MODEL_SNAPSHOT_ID.getPreferredName());
            }
            if (this.lastDataTime != null) {
                invalidCreateValues.add(LAST_DATA_TIME.getPreferredName());
            }
            if (this.finishedTime != null) {
                invalidCreateValues.add(FINISHED_TIME.getPreferredName());
            }
            if (this.createTime != null) {
                invalidCreateValues.add(CREATE_TIME.getPreferredName());
            }
            return invalidCreateValues;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.id);
            out.writeString(this.jobType);
            if (out.getVersion().onOrAfter(Version.V_5_5_0)) {
                if (this.jobVersion != null) {
                    out.writeBoolean(true);
                    Version.writeVersion((Version)this.jobVersion, (StreamOutput)out);
                } else {
                    out.writeBoolean(false);
                }
            }
            if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
                out.writeStringCollection(this.groups);
            }
            out.writeOptionalString(this.description);
            if (this.createTime != null) {
                out.writeBoolean(true);
                out.writeVLong(this.createTime.getTime());
            } else {
                out.writeBoolean(false);
            }
            if (this.finishedTime != null) {
                out.writeBoolean(true);
                out.writeVLong(this.finishedTime.getTime());
            } else {
                out.writeBoolean(false);
            }
            if (this.lastDataTime != null) {
                out.writeBoolean(true);
                out.writeVLong(this.lastDataTime.getTime());
            } else {
                out.writeBoolean(false);
            }
            if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
                out.writeOptionalLong(this.establishedModelMemory);
            }
            out.writeOptionalWriteable((Writeable)this.analysisConfig);
            out.writeOptionalWriteable((Writeable)this.analysisLimits);
            out.writeOptionalWriteable((Writeable)this.dataDescription);
            out.writeOptionalWriteable((Writeable)this.modelPlotConfig);
            out.writeOptionalLong(this.renormalizationWindowDays);
            out.writeOptionalTimeValue(this.backgroundPersistInterval);
            out.writeOptionalLong(this.modelSnapshotRetentionDays);
            out.writeOptionalLong(this.resultsRetentionDays);
            out.writeMap(this.customSettings);
            out.writeOptionalString(this.modelSnapshotId);
            out.writeOptionalString(this.resultsIndexName);
            out.writeBoolean(this.deleting);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.id != null) {
                builder.field(ID.getPreferredName(), this.id);
            }
            builder.field(JOB_TYPE.getPreferredName(), this.jobType);
            if (this.jobVersion != null) {
                builder.field(JOB_VERSION.getPreferredName(), (ToXContent)this.jobVersion);
            }
            if (this.description != null) {
                builder.field(DESCRIPTION.getPreferredName(), this.description);
            }
            if (this.createTime != null) {
                builder.field(CREATE_TIME.getPreferredName(), this.createTime.getTime());
            }
            if (this.finishedTime != null) {
                builder.field(FINISHED_TIME.getPreferredName(), this.finishedTime.getTime());
            }
            if (this.lastDataTime != null) {
                builder.field(LAST_DATA_TIME.getPreferredName(), this.lastDataTime.getTime());
            }
            if (this.establishedModelMemory != null) {
                builder.field(ESTABLISHED_MODEL_MEMORY.getPreferredName(), this.establishedModelMemory);
            }
            if (this.analysisConfig != null) {
                builder.field(ANALYSIS_CONFIG.getPreferredName(), (ToXContent)this.analysisConfig, params);
            }
            if (this.analysisLimits != null) {
                builder.field(ANALYSIS_LIMITS.getPreferredName(), (ToXContent)this.analysisLimits, params);
            }
            if (this.dataDescription != null) {
                builder.field(DATA_DESCRIPTION.getPreferredName(), (ToXContent)this.dataDescription, params);
            }
            if (this.modelPlotConfig != null) {
                builder.field(MODEL_PLOT_CONFIG.getPreferredName(), (ToXContent)this.modelPlotConfig, params);
            }
            if (this.renormalizationWindowDays != null) {
                builder.field(RENORMALIZATION_WINDOW_DAYS.getPreferredName(), this.renormalizationWindowDays);
            }
            if (this.backgroundPersistInterval != null) {
                builder.field(BACKGROUND_PERSIST_INTERVAL.getPreferredName(), this.backgroundPersistInterval.getStringRep());
            }
            if (this.modelSnapshotRetentionDays != null) {
                builder.field(MODEL_SNAPSHOT_RETENTION_DAYS.getPreferredName(), this.modelSnapshotRetentionDays);
            }
            if (this.resultsRetentionDays != null) {
                builder.field(RESULTS_RETENTION_DAYS.getPreferredName(), this.resultsRetentionDays);
            }
            if (this.customSettings != null) {
                builder.field(CUSTOM_SETTINGS.getPreferredName(), this.customSettings);
            }
            if (this.modelSnapshotId != null) {
                builder.field(MODEL_SNAPSHOT_ID.getPreferredName(), this.modelSnapshotId);
            }
            if (this.resultsIndexName != null) {
                builder.field(RESULTS_INDEX_NAME.getPreferredName(), this.resultsIndexName);
            }
            if (this.deleting) {
                builder.field(DELETING.getPreferredName(), this.deleting);
            }
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Builder that = (Builder)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.jobType, that.jobType) && Objects.equals(this.jobVersion, that.jobVersion) && Objects.equals(this.groups, that.groups) && Objects.equals(this.description, that.description) && Objects.equals(this.analysisConfig, that.analysisConfig) && Objects.equals(this.analysisLimits, that.analysisLimits) && Objects.equals(this.dataDescription, that.dataDescription) && Objects.equals(this.createTime, that.createTime) && Objects.equals(this.finishedTime, that.finishedTime) && Objects.equals(this.lastDataTime, that.lastDataTime) && Objects.equals(this.establishedModelMemory, that.establishedModelMemory) && Objects.equals(this.modelPlotConfig, that.modelPlotConfig) && Objects.equals(this.renormalizationWindowDays, that.renormalizationWindowDays) && Objects.equals(this.backgroundPersistInterval, that.backgroundPersistInterval) && Objects.equals(this.modelSnapshotRetentionDays, that.modelSnapshotRetentionDays) && Objects.equals(this.resultsRetentionDays, that.resultsRetentionDays) && Objects.equals(this.customSettings, that.customSettings) && Objects.equals(this.modelSnapshotId, that.modelSnapshotId) && Objects.equals(this.resultsIndexName, that.resultsIndexName) && Objects.equals(this.deleting, that.deleting);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.jobType, this.jobVersion, this.groups, this.description, this.analysisConfig, this.analysisLimits, this.dataDescription, this.createTime, this.finishedTime, this.lastDataTime, this.establishedModelMemory, this.modelPlotConfig, this.renormalizationWindowDays, this.backgroundPersistInterval, this.modelSnapshotRetentionDays, this.resultsRetentionDays, this.customSettings, this.modelSnapshotId, this.resultsIndexName, this.deleting);
        }

        public void validateInputFields() {
            if (this.analysisConfig == null) {
                throw new IllegalArgumentException(Messages.getMessage("An analysis_config must be set"));
            }
            if (this.dataDescription == null) {
                throw new IllegalArgumentException(Messages.getMessage("A data_description must be set"));
            }
            Builder.checkTimeFieldNotInAnalysisConfig(this.dataDescription, this.analysisConfig);
            this.checkValidBackgroundPersistInterval();
            Job.checkValueNotLessThan(0L, RENORMALIZATION_WINDOW_DAYS.getPreferredName(), this.renormalizationWindowDays);
            Job.checkValueNotLessThan(0L, MODEL_SNAPSHOT_RETENTION_DAYS.getPreferredName(), this.modelSnapshotRetentionDays);
            Job.checkValueNotLessThan(0L, RESULTS_RETENTION_DAYS.getPreferredName(), this.resultsRetentionDays);
            if (!MlStrings.isValidId(this.id)) {
                throw new IllegalArgumentException(Messages.getMessage("Invalid {0}; ''{1}'' can contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores; must start and end with alphanumeric", ID.getPreferredName(), this.id));
            }
            if (!MlStrings.hasValidLengthForId(this.id)) {
                throw new IllegalArgumentException(Messages.getMessage("The job id cannot contain more than {0,number,integer} characters.", 64));
            }
            this.validateGroups();
            if (!Strings.isNullOrEmpty((String)this.resultsIndexName) && !MlStrings.isValidId(this.resultsIndexName)) {
                throw new IllegalArgumentException(Messages.getMessage("Invalid {0}; ''{1}'' can contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores; must start and end with alphanumeric", RESULTS_INDEX_NAME.getPreferredName(), this.resultsIndexName));
            }
        }

        public void validateAnalysisLimitsAndSetDefaults(@Nullable ByteSizeValue maxModelMemoryLimit) {
            this.analysisLimits = AnalysisLimits.validateAndSetDefaults(this.analysisLimits, maxModelMemoryLimit, 1024L);
        }

        private void validateGroups() {
            for (String group : this.groups) {
                if (!MlStrings.isValidId(group)) {
                    throw new IllegalArgumentException(Messages.getMessage("Invalid group id ''{0}''; must be non-empty string and may contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores; must start and end with alphanumeric", group));
                }
                if (!this.id.equals(group)) continue;
                throw new ResourceAlreadyExistsException(Messages.getMessage("job and group names must be unique but job [{0}] and group [{0}] have the same name", group), new Object[0]);
            }
        }

        public Job build(Date createTime) {
            this.setCreateTime(createTime);
            this.setJobVersion(Version.CURRENT);
            this.setEstablishedModelMemory(null);
            return this.build();
        }

        public Job build() {
            this.analysisLimits = AnalysisLimits.validateAndSetDefaults(this.analysisLimits, null, 4096L);
            this.validateInputFields();
            ExceptionsHelper.requireNonNull(this.createTime, CREATE_TIME.getPreferredName());
            if (Strings.isNullOrEmpty((String)this.resultsIndexName)) {
                this.resultsIndexName = "shared";
            } else if (!this.resultsIndexName.equals("shared")) {
                this.resultsIndexName = this.resultsIndexName.startsWith("custom-") ? this.resultsIndexName : "custom-" + this.resultsIndexName;
            }
            return new Job(this.id, this.jobType, this.jobVersion, this.groups, this.description, this.createTime, this.finishedTime, this.lastDataTime, this.establishedModelMemory, this.analysisConfig, this.analysisLimits, this.dataDescription, this.modelPlotConfig, this.renormalizationWindowDays, this.backgroundPersistInterval, this.modelSnapshotRetentionDays, this.resultsRetentionDays, this.customSettings, this.modelSnapshotId, this.resultsIndexName, this.deleting);
        }

        private void checkValidBackgroundPersistInterval() {
            if (this.backgroundPersistInterval != null) {
                TimeUtils.checkMultiple(this.backgroundPersistInterval, TimeUnit.SECONDS, BACKGROUND_PERSIST_INTERVAL);
                Job.checkValueNotLessThan(MIN_BACKGROUND_PERSIST_INTERVAL.getSeconds(), BACKGROUND_PERSIST_INTERVAL.getPreferredName(), this.backgroundPersistInterval.getSeconds());
            }
        }

        static void checkTimeFieldNotInAnalysisConfig(DataDescription dataDescription, AnalysisConfig analysisConfig) {
            if (analysisConfig.analysisFields().contains(dataDescription.getTimeField())) {
                throw new IllegalArgumentException(Messages.getMessage("data_description.time_field may not be used in the analysis_config"));
            }
        }
    }
}

