/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action.repositories;

import java.io.IOException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportActionProxy;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ccr.action.repositories.ClearCcrRestoreSessionRequest;
import org.elasticsearch.xpack.ccr.action.repositories.ClearCcrRestoreSessionRequestBuilder;
import org.elasticsearch.xpack.ccr.repository.CcrRestoreSourceService;

public class ClearCcrRestoreSessionAction
extends Action<ClearCcrRestoreSessionRequest, ClearCcrRestoreSessionResponse, ClearCcrRestoreSessionRequestBuilder> {
    public static final ClearCcrRestoreSessionAction INSTANCE = new ClearCcrRestoreSessionAction();
    public static final String NAME = "internal:admin/ccr/restore/session/clear";

    private ClearCcrRestoreSessionAction() {
        super(NAME);
    }

    public ClearCcrRestoreSessionResponse newResponse() {
        return new ClearCcrRestoreSessionResponse();
    }

    public ClearCcrRestoreSessionRequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new ClearCcrRestoreSessionRequestBuilder(client);
    }

    public static class ClearCcrRestoreSessionResponse
    extends ActionResponse {
        ClearCcrRestoreSessionResponse() {
        }

        ClearCcrRestoreSessionResponse(StreamInput in) throws IOException {
            super(in);
        }
    }

    public static class TransportDeleteCcrRestoreSessionAction
    extends HandledTransportAction<ClearCcrRestoreSessionRequest, ClearCcrRestoreSessionResponse> {
        private final CcrRestoreSourceService ccrRestoreService;

        @Inject
        public TransportDeleteCcrRestoreSessionAction(Settings settings, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver resolver, TransportService transportService, CcrRestoreSourceService ccrRestoreService) {
            super(settings, ClearCcrRestoreSessionAction.NAME, threadPool, transportService, actionFilters, resolver, ClearCcrRestoreSessionRequest::new, "generic");
            TransportActionProxy.registerProxyAction((TransportService)transportService, (String)ClearCcrRestoreSessionAction.NAME, ClearCcrRestoreSessionResponse::new);
            this.ccrRestoreService = ccrRestoreService;
        }

        protected void doExecute(ClearCcrRestoreSessionRequest request, ActionListener<ClearCcrRestoreSessionResponse> listener) {
            this.ccrRestoreService.closeSession(request.getSessionUUID());
            listener.onResponse((Object)new ClearCcrRestoreSessionResponse());
        }
    }
}

