/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.type.DataTypeConversion;

public class CastProcessor
implements Processor {
    public static final String NAME = "ca";
    private final DataTypeConversion.Conversion conversion;

    public CastProcessor(DataTypeConversion.Conversion conversion) {
        this.conversion = conversion;
    }

    public CastProcessor(StreamInput in) throws IOException {
        this.conversion = (DataTypeConversion.Conversion)in.readEnum(DataTypeConversion.Conversion.class);
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.conversion);
    }

    @Override
    public Object process(Object input) {
        return this.conversion.convert(input);
    }

    DataTypeConversion.Conversion converter() {
        return this.conversion;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CastProcessor other = (CastProcessor)obj;
        return Objects.equals((Object)this.conversion, (Object)other.conversion);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.conversion});
    }

    public String toString() {
        return this.conversion.name();
    }
}

