//===----------------------------------------------------------------------===//
//                         DuckDB
//
// function/scalar/struct_functions.hpp
//
//
//===----------------------------------------------------------------------===//
// This file is automatically generated by scripts/generate_functions.py
// Do not edit this file manually, your changes will be overwritten
//===----------------------------------------------------------------------===//

#pragma once

#include "duckdb/function/function_set.hpp"

namespace duckdb {

struct StructExtractFun {
	static constexpr const char *Name = "struct_extract";
	static constexpr const char *Parameters = "struct,'entry'";
	static constexpr const char *Description = "Extract the named entry from the STRUCT.";
	static constexpr const char *Example = "struct_extract({'i': 3, 'v2': 3, 'v3': 0}, 'i')";

	static ScalarFunctionSet GetFunctions();
};

struct StructExtractAtFun {
	static constexpr const char *Name = "struct_extract_at";
	static constexpr const char *Parameters = "struct,'entry'";
	static constexpr const char *Description = "Extract the entry from the STRUCT by position (starts at 1!).";
	static constexpr const char *Example = "struct_extract_at({'i': 3, 'v2': 3, 'v3': 0}, 2)";

	static ScalarFunctionSet GetFunctions();
};

struct StructPackFun {
	static constexpr const char *Name = "struct_pack";
	static constexpr const char *Parameters = "name:=any,...";
	static constexpr const char *Description = "Create a STRUCT containing the argument values. The entry name will be the bound variable name.";
	static constexpr const char *Example = "struct_pack(i := 4, s := 'string')";

	static ScalarFunction GetFunction();
};

struct RowFun {
	static constexpr const char *Name = "row";
	static constexpr const char *Parameters = "any,...";
	static constexpr const char *Description = "Create an unnamed STRUCT (tuple) containing the argument values.";
	static constexpr const char *Example = "row(i, i % 4, i / 4)";

	static ScalarFunction GetFunction();
};

struct StructConcatFun {
	static constexpr const char *Name = "struct_concat";
	static constexpr const char *Parameters = "struct,struct,...";
	static constexpr const char *Description = "Merge the multiple STRUCTs into a single STRUCT.";
	static constexpr const char *Example = "struct_concat(struct_pack(i := 4), struct_pack(s := 'string'))";

	static ScalarFunction GetFunction();
};

} // namespace duckdb
