/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.storeconfig;

import java.io.PrintWriter;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.storeconfig.StoreDescription;
import org.apache.catalina.storeconfig.StoreFactoryBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagerSF
extends StoreFactoryBase {
    private static Log log = LogFactory.getLog((Class)ManagerSF.class);

    public void store(PrintWriter aWriter, int indent, Object aElement) throws Exception {
        StoreDescription elementDesc = this.getRegistry().findDescription(aElement.getClass());
        if (elementDesc != null && aElement instanceof StandardManager) {
            StandardManager manager = (StandardManager)aElement;
            if (!this.isDefaultManager(manager)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("factory.storeTag", (Object)elementDesc.getTag(), aElement));
                }
                this.getStoreAppender().printIndent(aWriter, indent + 2);
                this.getStoreAppender().printTag(aWriter, indent + 2, manager, elementDesc);
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)sm.getString("factory.storeNoDescriptor", aElement.getClass()));
        }
    }

    protected boolean isDefaultManager(StandardManager smanager) {
        return "SESSIONS.ser".equals(smanager.getPathname()) && "java.security.SecureRandom".equals(smanager.getRandomClass()) && smanager.getMaxActiveSessions() == -1 && "MD5".equals(smanager.getAlgorithm());
    }
}

