//
// $Id: DataOutStream.h,v 1.16 2007/03/06 20:42:19 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#if !defined(DATAOUTSTREAM_OL_GUARD)
#define DATAOUTSTREAM_OL_GUARD

#include <ObjectiveLib/ConnectedOutStream.h>

#if !defined(OL_NO_OPENSTEP)
@class NSData;
#endif

/**
 * @class OLDataOutStream DataOutStream.h ObjectiveLib/DataOutStream.h
 *
 * An out stream connected to a memory buffer. This is a concrete connected stream
 * that writes its data to a memory buffer.
 *
 * @sa OLDataInStream
 *
 * @ingroup Streams
 */
@interface OLDataOutStream : OLConnectedOutStream
{
@protected
    /**
     * The buffer to which to write data
     */
    uint8_t*        buffer;

    /**
     * The position at which to insert data
     */
    uint8_t*        insert;

    /**
     * The end of the data
     */
    uint8_t*        end;
}

/**
 * Create and return a new stream.
 *
 * @note If OpenStep is present the returned object will be autoreleased
 * before being returned.
 *
 * @return a reference to the newly created stream
 */
+ (id) stream;

/**
 * @name Initializers and Deallocators
 */
/* @{ */
/**
 * Initialize the stream.
 *
 * @return a reference to this stream
 */
- (id) init;
#if !defined(OL_NO_OPENSTEP)
- (void) dealloc;
#endif
/* @} */

/**
 * Return a pointer to the beginning of the data.
 *
 * @return the data pointer
 */
- (const uint8_t*) bytes;

/**
 * Return the number of bytes.
 *
 * @return the number of bytes
 */
- (unsigned) count;

#if !defined(OL_NO_OPENSTEP)
/**
 * Return the data object. This object contains all the bytes that have up the current
 * moment been written to the stream.
 *
 * @return the data object containing the stream's memory buffer
 */
- (NSData*) data;
#endif

#if defined(OL_NO_OPENSTEP)
- (void) freeStreamResources;
#endif

/**
 * Write a sequence of bytes to the stream. Bytes are copied into the memory buffer
 * which grows as needed.
 *
 * @param bytes the bytes to write
 * @param count the number of bytes to write
 * @return the number of bytes written
 */
- (unsigned) writeBytes: (const uint8_t*)bytes count: (unsigned)count;

@end

#endif
