/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;

class GenericTypeAwarePropertyDescriptor
extends PropertyDescriptor {
    private final Class beanClass;
    private Class resolvedPropertyType;
    private MethodParameter writeMethodParameter;

    public GenericTypeAwarePropertyDescriptor(Class beanClass, String propertyName, Method readMethod, Method writeMethod) throws IntrospectionException {
        super(propertyName, readMethod, writeMethod);
        this.beanClass = beanClass;
    }

    public synchronized Class getPropertyType() {
        if (this.resolvedPropertyType == null) {
            MethodParameter writeMethodParam;
            Class<?> propertyType = super.getPropertyType();
            Method readMethod = this.getReadMethod();
            this.resolvedPropertyType = readMethod != null ? GenericTypeResolver.resolveReturnType((Method)readMethod, (Class)this.beanClass) : ((writeMethodParam = this.getWriteMethodParameter()) != null ? writeMethodParam.getParameterType() : propertyType);
        }
        return this.resolvedPropertyType;
    }

    public synchronized MethodParameter getWriteMethodParameter() {
        Method writeMethod = this.getWriteMethod();
        if (writeMethod == null) {
            return null;
        }
        if (this.writeMethodParameter == null) {
            this.writeMethodParameter = new MethodParameter(writeMethod, 0);
            GenericTypeResolver.resolveParameterType((MethodParameter)this.writeMethodParameter, (Class)this.beanClass);
        }
        return this.writeMethodParameter;
    }
}

