/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld;

import java.awt.Component;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jmeld.settings.JMeldSettings;
import org.jmeld.ui.JMeldPanel;
import org.jmeld.ui.util.ImageUtil;
import org.jmeld.ui.util.LookAndFeelManager;
import org.jmeld.util.prefs.WindowPreference;

public class JMeld
implements Runnable {
    private List<String> fileNameList = new ArrayList<String>();
    private static JMeldPanel jmeldPanel;

    public JMeld(String[] args) {
        for (String arg : args) {
            this.fileNameList.add(arg);
        }
    }

    public static JMeldPanel getJMeldPanel() {
        return jmeldPanel;
    }

    public void run() {
        this.debugKeyboard();
        LookAndFeelManager.getInstance().install();
        JFrame frame = new JFrame("JMeld");
        jmeldPanel = new JMeldPanel();
        frame.add(jmeldPanel);
        frame.setDefaultCloseOperation(0);
        frame.setIconImage(ImageUtil.getImageIcon("jmeld-small").getImage());
        new WindowPreference(frame.getTitle(), frame);
        frame.addWindowListener(jmeldPanel.getWindowListener());
        frame.setVisible(true);
        frame.toFront();
        jmeldPanel.openComparison(this.fileNameList);
    }

    private void debugKeyboard() {
        KeyboardFocusManager.setCurrentKeyboardFocusManager(new DefaultKeyboardFocusManager(){

            public boolean dispatchKeyEvent(KeyEvent e) {
                return super.dispatchKeyEvent(e);
            }

            public void processKeyEvent(Component focusedComponent, KeyEvent e) {
                super.processKeyEvent(focusedComponent, e);
            }
        });
    }

    public static void main(String[] args) {
        if (JMeldSettings.getInstance().getEditor().isAntialiasEnabled()) {
            System.setProperty("swing.aatext", "true");
        }
        SwingUtilities.invokeLater(new JMeld(args));
    }
}

