/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import net.sourceforge.squirrel_sql.client.plugin.PluginInfo;
import net.sourceforge.squirrel_sql.client.plugin.PluginStatus;
import net.sourceforge.squirrel_sql.fw.gui.SortableTable;
import net.sourceforge.squirrel_sql.fw.gui.SortableTableModel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class PluginSummaryTable
extends SortableTable {
    private static final long serialVersionUID = 1L;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(PluginSummaryTable.class);
    private static final String[] s_hdgs = new String[]{s_stringMgr.getString("PluginSummaryTable.loadAtStartup"), s_stringMgr.getString("PluginSummaryTable.internalName"), s_stringMgr.getString("PluginSummaryTable.name"), s_stringMgr.getString("PluginSummaryTable.loaded"), s_stringMgr.getString("PluginSummaryTable.version"), s_stringMgr.getString("PluginSummaryTable.author"), s_stringMgr.getString("PluginSummaryTable.contributors")};
    private static final Class<?>[] s_dataTypes = new Class[]{Boolean.class, String.class, String.class, String.class, String.class, String.class, String.class};
    private static final int[] s_columnWidths = new int[]{100, 100, 150, 50, 50, 100, 100};

    public PluginSummaryTable(PluginInfo[] pluginInfo, PluginStatus[] pluginStatus) {
        super(new MyTableModel(pluginInfo, pluginStatus));
        this.setSelectionMode(1);
        this.getTableHeader().setResizingAllowed(true);
        this.getTableHeader().setReorderingAllowed(true);
        this.setAutoCreateColumnsFromModel(false);
        this.setAutoResizeMode(3);
        DefaultTableColumnModel tcm = new DefaultTableColumnModel();
        for (int i = 0; i < s_columnWidths.length; ++i) {
            TableColumn col = new TableColumn(i, s_columnWidths[i]);
            col.setHeaderValue(s_hdgs[i]);
            tcm.addColumn(col);
        }
        this.setColumnModel(tcm);
    }

    PluginStatus[] getPluginStatus() {
        SortableTableModel stm = this.getSortableTableModel();
        SortableTableModel stm2 = (SortableTableModel)stm.getActualModel();
        MyTableModel tm = (MyTableModel)stm2.getActualModel();
        return tm.getPluginStatus();
    }

    private static class MyTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private ArrayList<PluginData> _pluginData = new ArrayList();

        MyTableModel(PluginInfo[] pluginInfo, PluginStatus[] pluginStatus) {
            int i;
            if (pluginInfo == null) {
                pluginInfo = new PluginInfo[]{};
            }
            if (pluginStatus == null) {
                pluginStatus = new PluginStatus[]{};
            }
            HashMap<String, PluginStatus> statuses = new HashMap<String, PluginStatus>();
            for (i = 0; i < pluginStatus.length; ++i) {
                statuses.put(pluginStatus[i].getInternalName(), pluginStatus[i]);
            }
            for (i = 0; i < pluginInfo.length; ++i) {
                PluginInfo pi = pluginInfo[i];
                PluginStatus ps = (PluginStatus)statuses.get(pi.getInternalName());
                PluginData pd = new PluginData(pi, ps);
                this._pluginData.add(pd);
            }
        }

        synchronized PluginStatus[] getPluginStatus() {
            PluginStatus[] ar = new PluginStatus[this._pluginData.size()];
            for (int i = 0; i < ar.length; ++i) {
                ar[i] = this._pluginData.get(i)._status;
            }
            return ar;
        }

        @Override
        public Object getValueAt(int row, int col) {
            PluginData pd = this._pluginData.get(row);
            switch (col) {
                case 0: {
                    return pd._status.isLoadAtStartup();
                }
                case 1: {
                    return pd._info.getInternalName();
                }
                case 2: {
                    return pd._info.getDescriptiveName();
                }
                case 3: {
                    return pd._info.isLoaded() ? s_stringMgr.getString("PluginSummaryTable.true") : s_stringMgr.getString("PluginSummaryTable.false");
                }
                case 4: {
                    return pd._info.getVersion();
                }
                case 5: {
                    return pd._info.getAuthor();
                }
                case 6: {
                    return pd._info.getContributors();
                }
            }
            throw new IndexOutOfBoundsException("" + col);
        }

        @Override
        public int getRowCount() {
            return this._pluginData.size();
        }

        @Override
        public int getColumnCount() {
            return s_hdgs.length;
        }

        @Override
        public String getColumnName(int col) {
            return s_hdgs[col];
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return s_dataTypes[col];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            PluginData pd;
            if (col == 0) {
                pd = this._pluginData.get(row);
                boolean loadAtStartup = Boolean.valueOf(value.toString());
                pd._status.setLoadAtStartup(loadAtStartup);
                this.fireTableCellUpdated(row, col);
            }
            if (col == 3) {
                pd = this._pluginData.get(row);
                pd._info.setLoaded(Boolean.valueOf(value.toString()));
                this.fireTableCellUpdated(row, col);
            }
        }

        private static class PluginData {
            private final String _internalName;
            private final PluginInfo _info;
            private final PluginStatus _status;

            PluginData(PluginInfo info, PluginStatus status) {
                this._info = info;
                this._status = status != null ? status : new PluginStatus(this._info.getInternalName());
                this._internalName = this._info.getInternalName();
            }

            public String getInternalName() {
                return this._internalName;
            }
        }
    }
}

