/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.beans.PropertyChangeListener;
import java.io.Serializable;
import net.sourceforge.squirrel_sql.client.gui.db.ISQLAliasExt;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAliasColorProperties;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAliasConnectionProperties;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAliasSchemaProperties;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.persist.ValidationException;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverProperty;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverPropertyCollection;
import net.sourceforge.squirrel_sql.fw.util.PropertyChangeReporter;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class SQLAlias
implements Cloneable,
Serializable,
ISQLAliasExt,
Comparable<Object> {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SQLAlias.class);
    private IIdentifier _id;
    private String _name;
    private IIdentifier _driverId;
    private String _url;
    private String _userName;
    private String _password;
    private boolean _autoLogon;
    private boolean _connectAtStartup;
    private boolean _useDriverProperties = false;
    private SQLDriverPropertyCollection _driverProps = new SQLDriverPropertyCollection();
    private transient PropertyChangeReporter _propChgReporter;
    private SQLAliasSchemaProperties _schemaProperties = new SQLAliasSchemaProperties();
    private SQLAliasColorProperties _colorProperties = new SQLAliasColorProperties();
    private SQLAliasConnectionProperties _connectionProperties = new SQLAliasConnectionProperties();

    public SQLAlias() {
    }

    public SQLAlias(IIdentifier id) {
        this._id = id;
        this._name = "";
        this._driverId = null;
        this._url = "";
        this._userName = "";
        this._password = "";
    }

    public synchronized void assignFrom(SQLAlias rhs, boolean withIdentifier) throws ValidationException {
        if (withIdentifier) {
            this.setIdentifier(rhs.getIdentifier());
        }
        this.setName(rhs.getName());
        this.setDriverIdentifier(rhs.getDriverIdentifier());
        this.setUrl(rhs.getUrl());
        this.setUserName(rhs.getUserName());
        this.setPassword(rhs.getPassword());
        this.setAutoLogon(rhs.isAutoLogon());
        this.setUseDriverProperties(rhs.getUseDriverProperties());
        this.setDriverProperties(rhs.getDriverPropertiesClone());
        this._schemaProperties = (SQLAliasSchemaProperties)Utilities.cloneObject(rhs._schemaProperties, this.getClass().getClassLoader());
        this._colorProperties = (SQLAliasColorProperties)Utilities.cloneObject(rhs._colorProperties, this.getClass().getClassLoader());
        this._connectionProperties = new SQLAliasConnectionProperties();
        SQLAliasConnectionProperties rhsConnProps = rhs.getConnectionProperties();
        this._connectionProperties.setEnableConnectionKeepAlive(rhsConnProps.isEnableConnectionKeepAlive());
        this._connectionProperties.setKeepAliveSleepTimeSeconds(rhsConnProps.getKeepAliveSleepTimeSeconds());
        this._connectionProperties.setKeepAliveSqlStatement(rhsConnProps.getKeepAliveSqlStatement());
    }

    public boolean equals(Object rhs) {
        boolean rc = false;
        if (rhs != null && rhs.getClass().equals(this.getClass())) {
            rc = ((Object)((ISQLAlias)rhs).getIdentifier()).equals(this.getIdentifier());
        }
        return rc;
    }

    public synchronized int hashCode() {
        return ((Object)this.getIdentifier()).hashCode();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(Object rhs) {
        return this._name.compareTo(((ISQLAlias)rhs).getName());
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeReporter().addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeReporter().removePropertyChangeListener(listener);
    }

    @Override
    public synchronized boolean isValid() {
        return this._name != null && this._name.length() > 0 && this._driverId != null && this._url != null && this._url.length() > 0;
    }

    @Override
    public IIdentifier getIdentifier() {
        return this._id;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public IIdentifier getDriverIdentifier() {
        return this._driverId;
    }

    @Override
    public String getUrl() {
        return this._url;
    }

    @Override
    public String getUserName() {
        return this._userName;
    }

    @Override
    public String getPassword() {
        return this._password;
    }

    @Override
    public void setPassword(String password) {
        String data = this.getString(password);
        if (this._password != data) {
            String oldValue = this._password;
            this._password = data;
            this.getPropertyChangeReporter().firePropertyChange("password", oldValue, this._password);
        }
    }

    @Override
    public boolean isAutoLogon() {
        return this._autoLogon;
    }

    @Override
    public void setAutoLogon(boolean value) {
        if (this._autoLogon != value) {
            this._autoLogon = value;
            this.getPropertyChangeReporter().firePropertyChange("autoLogon", !this._autoLogon, this._autoLogon);
        }
    }

    @Override
    public boolean isConnectAtStartup() {
        return this._connectAtStartup;
    }

    @Override
    public void setConnectAtStartup(boolean value) {
        if (this._connectAtStartup != value) {
            this._connectAtStartup = value;
            this.getPropertyChangeReporter().firePropertyChange("connectAtStartup", !this._connectAtStartup, this._connectAtStartup);
        }
    }

    @Override
    public boolean getUseDriverProperties() {
        return this._useDriverProperties;
    }

    public void setIdentifier(IIdentifier id) {
        this._id = id;
    }

    @Override
    public void setName(String name) throws ValidationException {
        String data = this.getString(name);
        if (data.length() == 0) {
            throw new ValidationException(IStrings.ERR_BLANK_NAME);
        }
        if (this._name != data) {
            String oldValue = this._name;
            this._name = data;
            this.getPropertyChangeReporter().firePropertyChange("name", oldValue, this._name);
        }
    }

    @Override
    public void setDriverIdentifier(IIdentifier data) throws ValidationException {
        if (data == null) {
            throw new ValidationException(IStrings.ERR_BLANK_DRIVER);
        }
        if (this._driverId != data) {
            IIdentifier oldValue = this._driverId;
            this._driverId = data;
            this.getPropertyChangeReporter().firePropertyChange("driverIdentifier", oldValue, this._driverId);
        }
    }

    @Override
    public void setUrl(String url) throws ValidationException {
        String data = this.getString(url);
        if (data.length() == 0) {
            throw new ValidationException(IStrings.ERR_BLANK_URL);
        }
        if (this._url != data) {
            String oldValue = this._url;
            this._url = data;
            this.getPropertyChangeReporter().firePropertyChange("url", oldValue, this._url);
        }
    }

    @Override
    public void setUserName(String userName) {
        String data = this.getString(userName);
        if (this._userName != data) {
            String oldValue = this._userName;
            this._userName = data;
            this.getPropertyChangeReporter().firePropertyChange("userName", oldValue, this._userName);
        }
    }

    @Override
    public void setUseDriverProperties(boolean value) {
        if (this._useDriverProperties != value) {
            boolean oldValue = this._useDriverProperties;
            this._useDriverProperties = value;
            this.getPropertyChangeReporter().firePropertyChange("useDriverProperties", oldValue, this._useDriverProperties);
        }
    }

    @Override
    public synchronized SQLDriverPropertyCollection getDriverPropertiesClone() {
        int count = this._driverProps.size();
        SQLDriverProperty[] newar = new SQLDriverProperty[count];
        for (int i = 0; i < count; ++i) {
            newar[i] = (SQLDriverProperty)this._driverProps.getDriverProperty(i).clone();
        }
        SQLDriverPropertyCollection coll = new SQLDriverPropertyCollection();
        coll.setDriverProperties(newar);
        return coll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setDriverProperties(SQLDriverPropertyCollection value) {
        this._driverProps.clear();
        if (value != null) {
            SQLDriverPropertyCollection sQLDriverPropertyCollection = value;
            synchronized (sQLDriverPropertyCollection) {
                int count = value.size();
                SQLDriverProperty[] newar = new SQLDriverProperty[count];
                for (int i = 0; i < count; ++i) {
                    newar[i] = (SQLDriverProperty)value.getDriverProperty(i).clone();
                }
                this._driverProps.setDriverProperties(newar);
            }
        }
    }

    private synchronized PropertyChangeReporter getPropertyChangeReporter() {
        if (this._propChgReporter == null) {
            this._propChgReporter = new PropertyChangeReporter(this);
        }
        return this._propChgReporter;
    }

    private String getString(String data) {
        return data != null ? data.trim() : "";
    }

    @Override
    public SQLAliasSchemaProperties getSchemaProperties() {
        return this._schemaProperties;
    }

    @Override
    public void setSchemaProperties(SQLAliasSchemaProperties schemaProperties) {
        this._schemaProperties = schemaProperties;
    }

    @Override
    public SQLAliasColorProperties getColorProperties() {
        return this._colorProperties;
    }

    @Override
    public void setColorProperties(SQLAliasColorProperties colorProperties) {
        this._colorProperties = colorProperties;
    }

    @Override
    public SQLAliasConnectionProperties getConnectionProperties() {
        return this._connectionProperties;
    }

    @Override
    public void setConnectionProperties(SQLAliasConnectionProperties connectionProperties) {
        this._connectionProperties = connectionProperties;
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private static interface IPropNames
    extends ISQLAlias.IPropertyNames {
    }

    private static interface IStrings {
        public static final String ERR_BLANK_NAME = SQLAlias.access$000().getString("SQLAlias.error.blankname");
        public static final String ERR_BLANK_DRIVER = SQLAlias.access$000().getString("SQLAlias.error.blankdriver");
        public static final String ERR_BLANK_URL = SQLAlias.access$000().getString("SQLAlias.error.blankurl");
    }
}

