/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.colorspace;

import com.sun.media.BasicCodec;
import com.sun.media.codec.video.colorspace.RGBConverter;
import java.awt.Component;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.control.FrameProcessingControl;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;

public abstract class RGBConverter
extends BasicCodec {
    private static final String PLUGIN_NAME = "RGB To RGB Converter";
    private FrameProcessingControl frameControl = null;
    private boolean dropFrame;

    public RGBConverter() {
        this.inputFormats = new Format[]{new RGBFormat()};
        this.outputFormats = new Format[]{new RGBFormat()};
        if (this.frameControl == null) {
            class FPC
            implements FrameProcessingControl {
                private final /* synthetic */ RGBConverter this$0;

                FPC(RGBConverter this$0) {
                    this.this$0 = this$0;
                }

                public void setFramesBehind(float frames) {
                    if (frames > 0.0f) {
                        RGBConverter.access$002(this.this$0, true);
                    } else {
                        RGBConverter.access$002(this.this$0, false);
                    }
                }

                public boolean setMinimalProcessing(boolean minimal) {
                    RGBConverter.access$002(this.this$0, minimal);
                    return RGBConverter.access$000(this.this$0);
                }

                public Component getControlComponent() {
                    return null;
                }

                public int getFramesDropped() {
                    return 0;
                }
            }
            this.frameControl = new FPC(this);
            this.controls = new Control[1];
            this.controls[0] = this.frameControl;
        }
    }

    public String getName() {
        return PLUGIN_NAME;
    }

    public Format[] getSupportedOutputFormats(Format input) {
        if (input == null) {
            return this.outputFormats;
        }
        if (input instanceof RGBFormat) {
            RGBFormat rgb = (RGBFormat)input;
            Dimension size = rgb.getSize();
            float frameRate = rgb.getFrameRate();
            int bpp = rgb.getBitsPerPixel();
            RGBFormat bits_16_p = new RGBFormat(size, size.width * size.height, Format.shortArray, frameRate, 16, -1, -1, -1, 1, size.width, -1, -1);
            RGBFormat bits_16_up = new RGBFormat(size, size.width * size.height * 2, Format.byteArray, frameRate, 16, -1, -1, -1, 2, size.width * 2, -1, -1);
            RGBFormat masks_565 = new RGBFormat(null, -1, null, -1.0f, -1, 63488, 2016, 31, -1, -1, -1, -1);
            RGBFormat masks_555 = new RGBFormat(null, -1, null, -1.0f, -1, 31744, 992, 31, -1, -1, -1, -1);
            RGBFormat bits_24_up = new RGBFormat(size, size.width * size.height * 3, Format.byteArray, frameRate, 24, -1, -1, -1, 3, size.width * 3, -1, -1);
            RGBFormat masks_RGB = new RGBFormat(null, -1, null, -1.0f, -1, 1, 2, 3, -1, -1, -1, -1);
            RGBFormat masks_BGR = new RGBFormat(null, -1, null, -1.0f, -1, 3, 2, 1, -1, -1, -1, -1);
            RGBFormat bits_32_p = new RGBFormat(size, size.width * size.height, Format.intArray, frameRate, 32, -1, -1, -1, 1, size.width, -1, -1);
            RGBFormat bits_32_up = new RGBFormat(size, size.width * size.height * 4, Format.byteArray, frameRate, 32, -1, -1, -1, 4, size.width * 4, -1, -1);
            RGBFormat masks_234 = new RGBFormat(null, -1, null, -1.0f, -1, 2, 3, 4, -1, -1, -1, -1);
            RGBFormat masks_432 = new RGBFormat(null, -1, null, -1.0f, -1, 4, 3, 2, -1, -1, -1, -1);
            RGBFormat masks_123 = new RGBFormat(null, -1, null, -1.0f, -1, 1, 2, 3, -1, -1, -1, -1);
            RGBFormat flipped = new RGBFormat(null, -1, null, -1.0f, -1, -1, -1, -1, -1, -1, 1, -1);
            RGBFormat straight = new RGBFormat(null, -1, null, -1.0f, -1, -1, -1, -1, -1, -1, 0, -1);
            RGBFormat big = new RGBFormat(null, -1, null, -1.0f, -1, -1, -1, -1, -1, -1, -1, 0);
            RGBFormat little = new RGBFormat(null, -1, null, -1.0f, -1, -1, -1, -1, -1, -1, -1, 1);
            RGBFormat masks_321 = new RGBFormat(null, -1, null, -1.0f, -1, 3, 2, 1, -1, -1, -1, -1);
            RGBFormat masks_XRGB = new RGBFormat(null, -1, null, -1.0f, -1, 0xFF0000, 65280, 255, -1, -1, -1, -1);
            RGBFormat masks_XBGR = new RGBFormat(null, -1, null, -1.0f, -1, 255, 65280, 0xFF0000, -1, -1, -1, -1);
            Format[] out = new Format[]{bits_16_p.intersects(masks_565).intersects(flipped), bits_16_p.intersects(masks_565).intersects(straight), bits_16_up.intersects(masks_565).intersects(flipped).intersects(little), bits_16_up.intersects(masks_565).intersects(flipped).intersects(big), bits_16_up.intersects(masks_565).intersects(straight).intersects(little), bits_16_up.intersects(masks_565).intersects(straight).intersects(big), bits_16_p.intersects(masks_555).intersects(flipped), bits_16_p.intersects(masks_555).intersects(straight), bits_16_up.intersects(masks_555).intersects(flipped).intersects(little), bits_16_up.intersects(masks_555).intersects(flipped).intersects(big), bits_16_up.intersects(masks_555).intersects(straight).intersects(little), bits_16_up.intersects(masks_555).intersects(straight).intersects(big), bits_24_up.intersects(masks_RGB).intersects(flipped), bits_24_up.intersects(masks_RGB).intersects(straight), bits_24_up.intersects(masks_BGR).intersects(flipped), bits_24_up.intersects(masks_BGR).intersects(straight), bits_32_p.intersects(masks_XRGB).intersects(flipped), bits_32_p.intersects(masks_XRGB).intersects(straight), bits_32_p.intersects(masks_XBGR).intersects(flipped), bits_32_p.intersects(masks_XBGR).intersects(straight), bits_32_up.intersects(masks_123).intersects(flipped), bits_32_up.intersects(masks_123).intersects(straight), bits_32_up.intersects(masks_321).intersects(flipped), bits_32_up.intersects(masks_321).intersects(straight), bits_32_up.intersects(masks_234).intersects(flipped), bits_32_up.intersects(masks_234).intersects(straight), bits_32_up.intersects(masks_432).intersects(flipped), bits_32_up.intersects(masks_432).intersects(straight)};
            return out;
        }
        return null;
    }

    protected abstract void sixteenToSixteen(Object var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, int var9, Object var10, int var11, int var12, int var13, int var14, int var15, int var16, boolean var17, int var18, int var19, int var20, boolean var21);

    protected abstract void sixteenToComponent(Object var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, int var9, Object var10, int var11, int var12, int var13, int var14, int var15, int var16, boolean var17, int var18, int var19, int var20, boolean var21);

    protected abstract void componentToSixteen(Object var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, int var9, Object var10, int var11, int var12, int var13, int var14, int var15, int var16, boolean var17, int var18, int var19, int var20, boolean var21);

    protected abstract void componentToComponent(Object var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, int var9, Object var10, int var11, int var12, int var13, int var14, int var15, int var16, boolean var17, int var18, int var19, int var20, boolean var21);

    public Format setInputFormat(Format in) {
        Format returnFormat = super.setInputFormat(in);
        if (returnFormat == null) {
            return null;
        }
        if (((RGBFormat)returnFormat).getBitsPerPixel() < 15) {
            return null;
        }
        Dimension size = ((VideoFormat)in).getSize();
        if (this.opened) {
            this.outputFormat = this.updateRGBFormat((VideoFormat)in, (RGBFormat)this.outputFormat);
        }
        return returnFormat;
    }

    public int process(Buffer inBuffer, Buffer outBuffer) {
        if (this.isEOM(inBuffer)) {
            this.propagateEOM(outBuffer);
            return 0;
        }
        if (this.dropFrame) {
            outBuffer.setFlags(outBuffer.getFlags() | 2);
            return 0;
        }
        RGBFormat inputRGB = (RGBFormat)this.inputFormat;
        RGBFormat outputRGB = (RGBFormat)this.outputFormat;
        Object inObject = inBuffer.getData();
        Object outObject = outBuffer.getData();
        if (inObject.getClass() != this.inputFormat.getDataType()) {
            return 1;
        }
        int outMaxDataLen = outputRGB.getMaxDataLength();
        int outLength = 0;
        if (outObject != null) {
            if (outObject.getClass() == Format.byteArray) {
                outLength = ((byte[])outObject).length;
            } else if (outObject.getClass() == Format.shortArray) {
                outLength = ((short[])outObject).length;
            } else if (outObject.getClass() == Format.intArray) {
                outLength = ((int[])outObject).length;
            }
        }
        if (outObject == null || outLength < outMaxDataLen || this.outputFormat != outBuffer.getFormat() || !this.outputFormat.equals(outBuffer.getFormat())) {
            Class outputDataType = this.outputFormat.getDataType();
            if (outputDataType == Format.byteArray) {
                outObject = new byte[outputRGB.getMaxDataLength()];
            } else if (outputDataType == Format.shortArray) {
                outObject = new short[outputRGB.getMaxDataLength()];
            } else if (outputDataType == Format.intArray) {
                outObject = new int[outputRGB.getMaxDataLength()];
            } else {
                return 1;
            }
            outBuffer.setData(outObject);
        }
        if (outObject.getClass() != this.outputFormat.getDataType()) {
            return 1;
        }
        int inBPP = inputRGB.getBitsPerPixel();
        int outBPP = outputRGB.getBitsPerPixel();
        boolean inPacked = inputRGB.getDataType() != Format.byteArray;
        boolean outPacked = outputRGB.getDataType() != Format.byteArray;
        int inPS = inputRGB.getPixelStride();
        int outPS = outputRGB.getPixelStride();
        int inEndian = inputRGB.getEndian();
        int outEndian = outputRGB.getEndian();
        int inRed = inputRGB.getRedMask();
        int inGreen = inputRGB.getGreenMask();
        int inBlue = inputRGB.getBlueMask();
        int outRed = outputRGB.getRedMask();
        int outGreen = outputRGB.getGreenMask();
        int outBlue = outputRGB.getBlueMask();
        int inLS = inputRGB.getLineStride();
        int outLS = outputRGB.getLineStride();
        boolean flip = inputRGB.getFlipped() != outputRGB.getFlipped();
        Dimension size = inputRGB.getSize();
        int width = size.width;
        int height = size.height;
        if (inBPP == 16 && outBPP == 16) {
            this.sixteenToSixteen(inObject, inPS, inLS, inBPP, inRed, inGreen, inBlue, inPacked, inEndian, outObject, outPS, outLS, outBPP, outRed, outGreen, outBlue, outPacked, outEndian, width, height, flip);
        } else if (inBPP == 16 && outBPP >= 24) {
            this.sixteenToComponent(inObject, inPS, inLS, inBPP, inRed, inGreen, inBlue, inPacked, inEndian, outObject, outPS, outLS, outBPP, outRed, outGreen, outBlue, outPacked, outEndian, width, height, flip);
        } else if (inBPP >= 24 && outBPP == 16) {
            this.componentToSixteen(inObject, inPS, inLS, inBPP, inRed, inGreen, inBlue, inPacked, inEndian, outObject, outPS, outLS, outBPP, outRed, outGreen, outBlue, outPacked, outEndian, width, height, flip);
        } else if (inBPP >= 24 && outBPP >= 24) {
            this.componentToComponent(inObject, inPS, inLS, inBPP, inRed, inGreen, inBlue, inPacked, inEndian, outObject, outPS, outLS, outBPP, outRed, outGreen, outBlue, outPacked, outEndian, width, height, flip);
        }
        outBuffer.setFormat(this.outputFormat);
        outBuffer.setLength(outputRGB.getMaxDataLength());
        return 0;
    }

    public void open() throws ResourceUnavailableException {
        super.open();
    }

    public void close() {
        super.close();
    }

    public void reset() {
    }

    protected int getShift(int mask) {
        int shift = 0;
        while ((mask & 1) == 0) {
            mask >>= 1;
            ++shift;
        }
        return shift;
    }

    static /* synthetic */ boolean access$002(RGBConverter x0, boolean x1) {
        x0.dropFrame = x1;
        return x0.dropFrame;
    }

    static /* synthetic */ boolean access$000(RGBConverter x0) {
        return x0.dropFrame;
    }
}

