/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.cli;

import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.network.InetAddressHelper;
import org.elasticsearch.common.network.NetworkAddress;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class CertGenUtils {
    private static final String CN_OID = "2.5.4.3";
    private static final int SERIAL_BIT_LENGTH = 160;
    private static final BouncyCastleProvider BC_PROV = new BouncyCastleProvider();

    private CertGenUtils() {
    }

    public static X509Certificate generateCACertificate(X500Principal x500Principal, KeyPair keyPair, int days) throws OperatorCreationException, CertificateException, CertIOException, NoSuchAlgorithmException {
        return CertGenUtils.generateSignedCertificate(x500Principal, null, keyPair, null, null, true, days, null);
    }

    public static X509Certificate generateSignedCertificate(X500Principal principal, GeneralNames subjectAltNames, KeyPair keyPair, X509Certificate caCert, PrivateKey caPrivKey, int days) throws OperatorCreationException, CertificateException, CertIOException, NoSuchAlgorithmException {
        return CertGenUtils.generateSignedCertificate(principal, subjectAltNames, keyPair, caCert, caPrivKey, false, days, null);
    }

    public static X509Certificate generateSignedCertificate(X500Principal principal, GeneralNames subjectAltNames, KeyPair keyPair, X509Certificate caCert, PrivateKey caPrivKey, int days, String signatureAlgorithm) throws OperatorCreationException, CertificateException, CertIOException, NoSuchAlgorithmException {
        return CertGenUtils.generateSignedCertificate(principal, subjectAltNames, keyPair, caCert, caPrivKey, false, days, signatureAlgorithm);
    }

    private static X509Certificate generateSignedCertificate(X500Principal principal, GeneralNames subjectAltNames, KeyPair keyPair, X509Certificate caCert, PrivateKey caPrivKey, boolean isCa, int days, String signatureAlgorithm) throws NoSuchAlgorithmException, CertificateException, CertIOException, OperatorCreationException {
        AuthorityKeyIdentifier authorityKeyIdentifier;
        X500Name issuer;
        Objects.requireNonNull(keyPair, "Key-Pair must not be null");
        DateTime notBefore = new DateTime(DateTimeZone.UTC);
        if (days < 1) {
            throw new IllegalArgumentException("the certificate must be valid for at least one day");
        }
        DateTime notAfter = notBefore.plusDays(days);
        BigInteger serial = CertGenUtils.getSerial();
        JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
        X500Name subject = X500Name.getInstance((Object)principal.getEncoded());
        if (caCert != null) {
            if (caCert.getBasicConstraints() < 0) {
                throw new IllegalArgumentException("ca certificate is not a CA!");
            }
            issuer = X500Name.getInstance((Object)caCert.getIssuerX500Principal().getEncoded());
            authorityKeyIdentifier = extUtils.createAuthorityKeyIdentifier(caCert.getPublicKey());
        } else {
            issuer = subject;
            authorityKeyIdentifier = extUtils.createAuthorityKeyIdentifier(keyPair.getPublic());
        }
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(issuer, serial, new Time(notBefore.toDate(), Locale.ROOT), new Time(notAfter.toDate(), Locale.ROOT), subject, keyPair.getPublic());
        builder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)extUtils.createSubjectKeyIdentifier(keyPair.getPublic()));
        builder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)authorityKeyIdentifier);
        if (subjectAltNames != null) {
            builder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAltNames);
        }
        builder.addExtension(Extension.basicConstraints, isCa, (ASN1Encodable)new BasicConstraints(isCa));
        PrivateKey signingKey = caPrivKey != null ? caPrivKey : keyPair.getPrivate();
        ContentSigner signer = new JcaContentSignerBuilder(Strings.isNullOrEmpty((String)signatureAlgorithm) ? CertGenUtils.getDefaultSignatureAlgorithm(signingKey) : signatureAlgorithm).setProvider((Provider)BC_PROV).build(signingKey);
        X509CertificateHolder certificateHolder = builder.build(signer);
        return new JcaX509CertificateConverter().getCertificate(certificateHolder);
    }

    private static String getDefaultSignatureAlgorithm(PrivateKey key) {
        String signatureAlgorithm = null;
        switch (key.getAlgorithm()) {
            case "RSA": {
                signatureAlgorithm = "SHA256withRSA";
                break;
            }
            case "DSA": {
                signatureAlgorithm = "SHA256withDSA";
                break;
            }
            case "EC": {
                signatureAlgorithm = "SHA256withECDSA";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported algorithm : " + key.getAlgorithm() + " for signature, allowed values for private key algorithm are [RSA, DSA, EC]");
            }
        }
        return signatureAlgorithm;
    }

    static PKCS10CertificationRequest generateCSR(KeyPair keyPair, X500Principal principal, GeneralNames sanList) throws IOException, OperatorCreationException {
        Objects.requireNonNull(keyPair, "Key-Pair must not be null");
        Objects.requireNonNull(keyPair.getPublic(), "Public-Key must not be null");
        Objects.requireNonNull(principal, "Principal must not be null");
        JcaPKCS10CertificationRequestBuilder builder = new JcaPKCS10CertificationRequestBuilder(principal, keyPair.getPublic());
        if (sanList != null) {
            ExtensionsGenerator extGen = new ExtensionsGenerator();
            extGen.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)sanList);
            builder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)extGen.generate());
        }
        return builder.build(new JcaContentSignerBuilder("SHA256withRSA").setProvider((Provider)BC_PROV).build(keyPair.getPrivate()));
    }

    public static BigInteger getSerial() {
        SecureRandom random = new SecureRandom();
        BigInteger serial = new BigInteger(160, random);
        assert (serial.compareTo(BigInteger.valueOf(0L)) >= 0);
        return serial;
    }

    public static KeyPair generateKeyPair(int keysize) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(keysize);
        return keyPairGenerator.generateKeyPair();
    }

    public static GeneralNames getSubjectAlternativeNames(boolean resolveName, Set<InetAddress> addresses) throws IOException {
        HashSet<GeneralName> generalNameList = new HashSet<GeneralName>();
        for (InetAddress address : addresses) {
            if (address.isAnyLocalAddress()) {
                for (InetAddress inetAddress : InetAddressHelper.getAllAddresses()) {
                    CertGenUtils.addSubjectAlternativeNames(resolveName, inetAddress, generalNameList);
                }
                continue;
            }
            CertGenUtils.addSubjectAlternativeNames(resolveName, address, generalNameList);
        }
        return new GeneralNames(generalNameList.toArray(new GeneralName[generalNameList.size()]));
    }

    @SuppressForbidden(reason="need to use getHostName to resolve DNS name and getHostAddress to ensure we resolved the name")
    private static void addSubjectAlternativeNames(boolean resolveName, InetAddress inetAddress, Set<GeneralName> list) {
        String possibleHostName;
        String hostaddress = inetAddress.getHostAddress();
        String ip = NetworkAddress.format((InetAddress)inetAddress);
        list.add(new GeneralName(7, ip));
        if (resolveName && !inetAddress.isLinkLocalAddress() && !(possibleHostName = inetAddress.getHostName()).equals(hostaddress)) {
            list.add(new GeneralName(2, possibleHostName));
        }
    }

    public static GeneralName createCommonName(String cn) {
        ASN1Encodable[] sequence = new ASN1Encodable[]{new ASN1ObjectIdentifier(CN_OID), new DERTaggedObject(true, 0, (ASN1Encodable)new DERUTF8String(cn))};
        return new GeneralName(0, (ASN1Encodable)new DERSequence(sequence));
    }
}

