/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.type;

import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.EsField;

public class TextEsField
extends EsField {
    private Function<Tuple<EsField, String>, EsField.Exact> PROCESS_EXACT_FIELD = tuple -> {
        if (tuple.v1() == null) {
            return new EsField.Exact(false, (String)tuple.v2());
        }
        return new EsField.Exact(true, null);
    };

    public TextEsField(String name, Map<String, EsField> properties, boolean hasDocValues) {
        super(name, DataType.TEXT, properties, hasDocValues);
    }

    @Override
    public EsField getExactField() {
        Tuple<EsField, String> findExact = this.findExact();
        if (findExact.v1() == null) {
            throw new SqlIllegalArgumentException((String)findExact.v2());
        }
        return (EsField)findExact.v1();
    }

    @Override
    public EsField.Exact getExactInfo() {
        return this.PROCESS_EXACT_FIELD.apply(this.findExact());
    }

    private Tuple<EsField, String> findExact() {
        EsField field = null;
        for (EsField property : this.getProperties().values()) {
            if (property.getDataType() != DataType.KEYWORD || !property.getExactInfo().hasExact()) continue;
            if (field != null) {
                return new Tuple(null, (Object)("Multiple exact keyword candidates available for [" + this.getName() + "]; specify which one to use"));
            }
            field = property;
        }
        if (field == null) {
            return new Tuple(null, (Object)("No keyword/multi-field defined exact matches for [" + this.getName() + "]; define one or use MATCH/QUERY instead"));
        }
        return new Tuple(field, null);
    }
}

