/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.categorization;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.indices.analyze.TransportAnalyzeAction;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.CustomAnalyzer;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.indices.analysis.AnalysisModule;
import org.elasticsearch.xpack.core.ml.job.config.CategorizationAnalyzerConfig;

public class CategorizationAnalyzer
implements Closeable {
    private final Analyzer analyzer;
    private final boolean closeAnalyzer;

    public CategorizationAnalyzer(AnalysisRegistry analysisRegistry, Environment environment, CategorizationAnalyzerConfig categorizationAnalyzerConfig) throws IOException {
        Tuple<Analyzer, Boolean> tuple = CategorizationAnalyzer.makeAnalyzer(categorizationAnalyzerConfig, analysisRegistry, environment);
        this.analyzer = (Analyzer)tuple.v1();
        this.closeAnalyzer = (Boolean)tuple.v2();
    }

    @Override
    public void close() {
        if (this.closeAnalyzer) {
            this.analyzer.close();
        }
    }

    public List<String> tokenizeField(String fieldName, String fieldValue) {
        ArrayList<String> tokens = new ArrayList<String>();
        try (TokenStream stream = this.analyzer.tokenStream(fieldName, fieldValue);){
            stream.reset();
            CharTermAttribute term = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
            while (stream.incrementToken()) {
                String token = term.toString();
                if (token.isEmpty()) continue;
                tokens.add(term.toString());
            }
            stream.end();
        }
        catch (IOException e) {
            throw new ElasticsearchException("Failed to analyze value [" + fieldValue + "] of field [" + fieldName + "]", (Throwable)e, new Object[0]);
        }
        return tokens;
    }

    public static void verifyConfigBuilder(CategorizationAnalyzerConfig.Builder configBuilder, AnalysisRegistry analysisRegistry, Environment environment) throws IOException {
        Tuple<Analyzer, Boolean> tuple = CategorizationAnalyzer.makeAnalyzer(configBuilder.build(), analysisRegistry, environment);
        if (((Boolean)tuple.v2()).booleanValue()) {
            ((Analyzer)tuple.v1()).close();
        }
    }

    private static Tuple<Analyzer, Boolean> makeAnalyzer(CategorizationAnalyzerConfig config, AnalysisRegistry analysisRegistry, Environment environment) throws IOException {
        String analyzer = config.getAnalyzer();
        if (analyzer != null) {
            Analyzer globalAnalyzer = analysisRegistry.getAnalyzer(analyzer);
            if (globalAnalyzer == null) {
                throw new IllegalArgumentException("Failed to find global analyzer [" + analyzer + "]");
            }
            return new Tuple((Object)globalAnalyzer, (Object)Boolean.FALSE);
        }
        List<CharFilterFactory> charFilterFactoryList = CategorizationAnalyzer.parseCharFilterFactories(config, analysisRegistry, environment);
        Tuple<String, TokenizerFactory> tokenizerFactory = CategorizationAnalyzer.parseTokenizerFactory(config, analysisRegistry, environment);
        List<TokenFilterFactory> tokenFilterFactoryList = CategorizationAnalyzer.parseTokenFilterFactories(config, analysisRegistry, environment, tokenizerFactory, charFilterFactoryList);
        return new Tuple((Object)new CustomAnalyzer((String)tokenizerFactory.v1(), (TokenizerFactory)tokenizerFactory.v2(), charFilterFactoryList.toArray(new CharFilterFactory[charFilterFactoryList.size()]), tokenFilterFactoryList.toArray(new TokenFilterFactory[tokenFilterFactoryList.size()])), (Object)Boolean.TRUE);
    }

    private static List<CharFilterFactory> parseCharFilterFactories(CategorizationAnalyzerConfig config, AnalysisRegistry analysisRegistry, Environment environment) throws IOException {
        List charFilters = config.getCharFilters();
        ArrayList<CharFilterFactory> charFilterFactoryList = new ArrayList<CharFilterFactory>();
        for (CategorizationAnalyzerConfig.NameOrDefinition charFilter : charFilters) {
            CharFilterFactory charFilterFactory;
            if (charFilter.name != null) {
                AnalysisModule.AnalysisProvider charFilterFactoryFactory = analysisRegistry.getCharFilterProvider(charFilter.name);
                if (charFilterFactoryFactory == null) {
                    throw new IllegalArgumentException("Failed to find global char filter under [" + charFilter.name + "]");
                }
                charFilterFactory = (CharFilterFactory)charFilterFactoryFactory.get(environment, charFilter.name);
            } else {
                String charFilterTypeName = charFilter.definition.get("type");
                if (charFilterTypeName == null) {
                    throw new IllegalArgumentException("Missing [type] setting for char filter: " + charFilter.definition);
                }
                AnalysisModule.AnalysisProvider charFilterFactoryFactory = analysisRegistry.getCharFilterProvider(charFilterTypeName);
                if (charFilterFactoryFactory == null) {
                    throw new IllegalArgumentException("Failed to find global char filter under [" + charFilterTypeName + "]");
                }
                Settings settings = CategorizationAnalyzer.augmentSettings(charFilter.definition);
                charFilterFactory = (CharFilterFactory)charFilterFactoryFactory.get(CategorizationAnalyzer.buildDummyIndexSettings(settings), environment, "_anonymous_charfilter", settings);
            }
            if (charFilterFactory == null) {
                throw new IllegalArgumentException("Failed to find char filter [" + charFilter + "]");
            }
            charFilterFactoryList.add(charFilterFactory);
        }
        return charFilterFactoryList;
    }

    private static Tuple<String, TokenizerFactory> parseTokenizerFactory(CategorizationAnalyzerConfig config, AnalysisRegistry analysisRegistry, Environment environment) throws IOException {
        TokenizerFactory tokenizerFactory;
        String name;
        CategorizationAnalyzerConfig.NameOrDefinition tokenizer = config.getTokenizer();
        if (tokenizer.name != null) {
            name = tokenizer.name;
            AnalysisModule.AnalysisProvider tokenizerFactoryFactory = analysisRegistry.getTokenizerProvider(name);
            if (tokenizerFactoryFactory == null) {
                throw new IllegalArgumentException("Failed to find global tokenizer under [" + name + "]");
            }
            tokenizerFactory = (TokenizerFactory)tokenizerFactoryFactory.get(environment, name);
        } else {
            String tokenizerTypeName = tokenizer.definition.get("type");
            if (tokenizerTypeName == null) {
                throw new IllegalArgumentException("Missing [type] setting for tokenizer: " + tokenizer.definition);
            }
            AnalysisModule.AnalysisProvider tokenizerFactoryFactory = analysisRegistry.getTokenizerProvider(tokenizerTypeName);
            if (tokenizerFactoryFactory == null) {
                throw new IllegalArgumentException("Failed to find global tokenizer under [" + tokenizerTypeName + "]");
            }
            Settings settings = CategorizationAnalyzer.augmentSettings(tokenizer.definition);
            name = "_anonymous_tokenizer";
            tokenizerFactory = (TokenizerFactory)tokenizerFactoryFactory.get(CategorizationAnalyzer.buildDummyIndexSettings(settings), environment, name, settings);
        }
        return new Tuple((Object)name, (Object)tokenizerFactory);
    }

    private static List<TokenFilterFactory> parseTokenFilterFactories(CategorizationAnalyzerConfig config, AnalysisRegistry analysisRegistry, Environment environment, Tuple<String, TokenizerFactory> tokenizerFactory, List<CharFilterFactory> charFilterFactoryList) throws IOException {
        List tokenFilters = config.getTokenFilters();
        TransportAnalyzeAction.DeferredTokenFilterRegistry deferredRegistry = new TransportAnalyzeAction.DeferredTokenFilterRegistry(analysisRegistry, null);
        ArrayList<TokenFilterFactory> tokenFilterFactoryList = new ArrayList<TokenFilterFactory>();
        for (CategorizationAnalyzerConfig.NameOrDefinition tokenFilter : tokenFilters) {
            TokenFilterFactory tokenFilterFactory;
            if (tokenFilter.name != null) {
                AnalysisModule.AnalysisProvider tokenFilterFactoryFactory = analysisRegistry.getTokenFilterProvider(tokenFilter.name);
                if (tokenFilterFactoryFactory == null) {
                    throw new IllegalArgumentException("Failed to find global token filter under [" + tokenFilter.name + "]");
                }
                tokenFilterFactory = (TokenFilterFactory)tokenFilterFactoryFactory.get(environment, tokenFilter.name);
            } else {
                String filterTypeName = tokenFilter.definition.get("type");
                if (filterTypeName == null) {
                    throw new IllegalArgumentException("Missing [type] setting for token filter: " + tokenFilter.definition);
                }
                AnalysisModule.AnalysisProvider tokenFilterFactoryFactory = analysisRegistry.getTokenFilterProvider(filterTypeName);
                if (tokenFilterFactoryFactory == null) {
                    throw new IllegalArgumentException("Failed to find global token filter under [" + filterTypeName + "]");
                }
                Settings settings = CategorizationAnalyzer.augmentSettings(tokenFilter.definition);
                tokenFilterFactory = (TokenFilterFactory)tokenFilterFactoryFactory.get(CategorizationAnalyzer.buildDummyIndexSettings(settings), environment, "_anonymous_tokenfilter", settings);
                tokenFilterFactory = tokenFilterFactory.getChainAwareTokenFilterFactory((TokenizerFactory)tokenizerFactory.v2(), charFilterFactoryList, tokenFilterFactoryList, (Function)deferredRegistry);
            }
            if (tokenFilterFactory == null) {
                throw new IllegalArgumentException("Failed to find or create token filter [" + tokenFilter + "]");
            }
            tokenFilterFactoryList.add(tokenFilterFactory);
        }
        return tokenFilterFactoryList;
    }

    private static IndexSettings buildDummyIndexSettings(Settings settings) {
        IndexMetaData metaData = IndexMetaData.builder((String)"_na_").settings(settings).build();
        return new IndexSettings(metaData, Settings.EMPTY);
    }

    private static Settings augmentSettings(Settings settings) {
        return Settings.builder().put(settings).put("index.version.created", Version.CURRENT).put("index.number_of_replicas", 0).put("index.number_of_shards", 1).put("index.uuid", UUIDs.randomBase64UUID()).build();
    }
}

