/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.ldap.listener.ListenerMessages;
import com.unboundid.ldap.listener.PasswordEncoderOutputFormatter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Base64;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class Base64PasswordEncoderOutputFormatter
extends PasswordEncoderOutputFormatter {
    private static final Base64PasswordEncoderOutputFormatter INSTANCE = new Base64PasswordEncoderOutputFormatter();

    private Base64PasswordEncoderOutputFormatter() {
    }

    public static Base64PasswordEncoderOutputFormatter getInstance() {
        return INSTANCE;
    }

    @Override
    public byte[] format(byte[] unformattedData) throws LDAPException {
        return StaticUtils.getBytes(Base64.encode(unformattedData));
    }

    @Override
    public byte[] unFormat(byte[] formattedData) throws LDAPException {
        try {
            return Base64.decode(StaticUtils.toUTF8String(formattedData));
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.PARAM_ERROR, ListenerMessages.ERR_BASE64_PW_FORMATTER_CANNOT_DECODE.get(), e);
        }
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("Base64PasswordEncoderOutputFormatter()");
    }
}

