/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.MemoryImageSource;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;

public class QuaquaTextCursorHandler
implements MouseMotionListener,
KeyListener {
    private static QuaquaTextCursorHandler instance;
    private static QuaquaCursor textCursor;
    private static Cursor invisibleCursor;
    private JTextComponent activeComponent;

    public static QuaquaTextCursorHandler getInstance() {
        if (instance == null) {
            instance = new QuaquaTextCursorHandler();
            int[] pixels = new int[256];
            Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(16, 16, pixels, 0, 16));
            invisibleCursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), "invisibleCursor");
        }
        return instance;
    }

    public void installListeners(JTextComponent c) {
        c.addMouseMotionListener(this);
        c.addKeyListener(this);
    }

    public void uninstallListeners(JTextComponent c) {
        c.removeMouseMotionListener(this);
        c.removeKeyListener(this);
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        if (this.activeComponent != null) {
            this.showCursor(this.activeComponent);
            this.activeComponent = null;
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (e.getSource() != this.activeComponent) {
            if (e.getSource() instanceof JTextComponent) {
                if (this.activeComponent != null) {
                    this.showCursor(this.activeComponent);
                }
                this.activeComponent = (JTextComponent)e.getSource();
                this.hideCursor(this.activeComponent);
            } else {
                this.activeComponent = null;
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    private void hideCursor(JTextComponent c) {
        if (c.isEditable()) {
            c.setCursor(invisibleCursor);
        }
    }

    private void showCursor(JTextComponent c) {
        c.setCursor(c.isEditable() ? textCursor : null);
    }

    static {
        textCursor = new QuaquaCursor(2);
    }

    static class QuaquaCursor
    extends Cursor
    implements UIResource {
        QuaquaCursor(int type) {
            super(type);
        }

        QuaquaCursor(String name) {
            super(name);
        }
    }
}

