/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.languagetools;

import java.util.Collections;
import java.util.List;
import org.omegat.languagetools.ILanguageToolBridge;
import org.omegat.languagetools.LanguageToolResult;
import org.omegat.util.Log;

public abstract class BaseLanguageToolBridge
implements ILanguageToolBridge {
    private boolean hadError = false;

    @Override
    public final List<LanguageToolResult> getCheckResults(String sourceText, String translationText) {
        if (this.hadError) {
            return Collections.emptyList();
        }
        try {
            return this.getCheckResultsImpl(sourceText, translationText);
        }
        catch (Exception e) {
            Log.logErrorRB(e, "LT_ERROR_ON_CHECK", new Object[0]);
            this.hadError = true;
            return Collections.emptyList();
        }
    }

    protected abstract List<LanguageToolResult> getCheckResultsImpl(String var1, String var2) throws Exception;
}

