/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.Position;
import org.omegat.core.Core;
import org.omegat.core.spellchecker.SpellCheckerMarker;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.gui.editor.Document3;
import org.omegat.gui.editor.EditorController;
import org.omegat.gui.editor.SegmentBuilder;
import org.omegat.gui.editor.mark.BidiMarkers;
import org.omegat.gui.editor.mark.CalcMarkersThread;
import org.omegat.gui.editor.mark.ComesFromAutoTMMarker;
import org.omegat.gui.editor.mark.ComesFromMTMarker;
import org.omegat.gui.editor.mark.EntryMarks;
import org.omegat.gui.editor.mark.FontFallbackMarker;
import org.omegat.gui.editor.mark.IMarker;
import org.omegat.gui.editor.mark.Mark;
import org.omegat.gui.editor.mark.NBSPMarker;
import org.omegat.gui.editor.mark.ProtectedPartsMarker;
import org.omegat.gui.editor.mark.RemoveTagMarker;
import org.omegat.gui.editor.mark.ReplaceMarker;
import org.omegat.gui.editor.mark.WhitespaceMarkerFactory;
import org.omegat.gui.glossary.TransTipsMarker;
import org.omegat.util.Log;
import org.omegat.util.gui.UIThreadsUtil;

public class MarkerController {
    private final EditorController ec;
    private final String[] markerNames;
    protected final CalcMarkersThread[] markerThreads;
    private final Highlighter highlighter;
    private final Queue<EntryMarks> outputQueue = new LinkedList<EntryMarks>();

    public static void init() throws Exception {
        WhitespaceMarkerFactory.init();
        Core.registerMarker(new ProtectedPartsMarker());
        Core.registerMarker(new RemoveTagMarker());
        Core.registerMarker(new NBSPMarker());
        Core.registerMarker(new TransTipsMarker());
        Core.registerMarker(new BidiMarkers());
        Core.registerMarker(new ReplaceMarker());
        Core.registerMarker(new ComesFromAutoTMMarker());
        Core.registerMarker(new ComesFromMTMarker());
        Core.registerMarker(new FontFallbackMarker());
        Core.registerMarker(new SpellCheckerMarker());
    }

    MarkerController(EditorController ec) {
        this.ec = ec;
        this.highlighter = ec.editor.getHighlighter();
        ArrayList<IMarker> ms = new ArrayList<IMarker>();
        for (Class<?> mc : PluginUtils.getMarkerClasses()) {
            try {
                ms.add((IMarker)mc.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception ex) {
                Log.logErrorRB(ex, "PLUGIN_MARKER_INITIALIZE", mc.getName());
            }
        }
        for (IMarker marker : Core.getMarkers()) {
            ms.add(marker);
        }
        this.markerThreads = new CalcMarkersThread[ms.size()];
        this.markerNames = new String[ms.size()];
        for (int i = 0; i < ms.size(); ++i) {
            IMarker m = (IMarker)ms.get(i);
            this.markerNames[i] = m.getClass().getName();
            this.markerThreads[i] = new CalcMarkersThread(this, m, i);
            this.markerThreads[i].start();
        }
    }

    int getMarkerIndex(String markerClassName) {
        for (int i = 0; i < this.markerNames.length; ++i) {
            if (!this.markerNames[i].equals(markerClassName)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAll() {
        UIThreadsUtil.mustBeSwingThread();
        for (CalcMarkersThread th : this.markerThreads) {
            th.reset();
        }
        Queue<EntryMarks> queue = this.outputQueue;
        synchronized (queue) {
            this.outputQueue.clear();
        }
        this.highlighter.removeAllHighlights();
    }

    void remove(SegmentBuilder sb, int makerIndex) {
        UIThreadsUtil.mustBeSwingThread();
        if (sb.marks == null) {
            return;
        }
        MarkInfo[] me = sb.marks[makerIndex];
        if (me != null) {
            for (int j = 0; j < me.length; ++j) {
                if (me[j] == null || me[j].highlight == null) continue;
                this.highlighter.removeHighlight(me[j].highlight);
            }
            sb.marks[makerIndex] = null;
        }
    }

    public void reprocess(SegmentBuilder[] entryBuilders, int markerIndex) {
        UIThreadsUtil.mustBeSwingThread();
        if (entryBuilders == null) {
            return;
        }
        for (SegmentBuilder sb : entryBuilders) {
            if (!sb.hasBeenCreated()) continue;
            this.remove(sb, markerIndex);
        }
        this.markerThreads[markerIndex].add(entryBuilders);
    }

    public void reprocessImmediately(SegmentBuilder entryBuilder) {
        UIThreadsUtil.mustBeSwingThread();
        entryBuilder.resetTextAttributes();
        ArrayList<EntryMarks> evs = new ArrayList<EntryMarks>();
        for (int i = 0; i < this.markerNames.length; ++i) {
            this.remove(entryBuilder, i);
            try {
                EntryMarks ev = new EntryMarks(entryBuilder, entryBuilder.getDisplayVersion(), i);
                ev.result = this.markerThreads[i].marker.getMarksForEntry(ev.ste, ev.sourceText, ev.translationText, ev.isActive);
                if (ev.result == null) continue;
                evs.add(ev);
                continue;
            }
            catch (Throwable ex) {
                Log.log(ex);
            }
        }
        this.marksOutput(evs);
    }

    public void process(SegmentBuilder[] entryBuilders) {
        UIThreadsUtil.mustBeSwingThread();
        for (CalcMarkersThread th : this.markerThreads) {
            th.add(entryBuilders);
        }
    }

    public String getToolTips(int entryIndex, int pos) {
        UIThreadsUtil.mustBeSwingThread();
        if (entryIndex >= this.ec.m_docSegList.length || entryIndex < 0) {
            return null;
        }
        MarkInfo[][] m = this.ec.m_docSegList[entryIndex].marks;
        if (m == null) {
            return null;
        }
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < m.length; ++i) {
            if (m[i] == null) continue;
            for (MarkInfo t : m[i]) {
                if (t == null || t.tooltip == null || t.tooltip.p0.getOffset() > pos || t.tooltip.p1.getOffset() < pos) continue;
                if (res.length() > 0) {
                    res.append("<br>");
                }
                res.append(t.tooltip.text);
            }
        }
        if (res.length() == 0) {
            return null;
        }
        String r = res.toString();
        r = r.replace("<suggestion>", "<b>");
        r = r.replace("</suggestion>", "</b>");
        return "<html>" + r + "</html>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueMarksOutput(EntryMarks ev) {
        Queue<EntryMarks> queue = this.outputQueue;
        synchronized (queue) {
            this.outputQueue.add(ev);
            this.outputQueue.notifyAll();
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList<EntryMarks> evs = new ArrayList<EntryMarks>();
                Queue<EntryMarks> queue = MarkerController.this.outputQueue;
                synchronized (queue) {
                    EntryMarks ev;
                    while ((ev = MarkerController.this.outputQueue.poll()) != null) {
                        evs.add(ev);
                    }
                }
                MarkerController.this.marksOutput(evs);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void marksOutput(List<EntryMarks> evs) {
        UIThreadsUtil.mustBeSwingThread();
        if (evs.isEmpty()) {
            return;
        }
        Document3 doc = this.ec.editor.getOmDocument();
        doc.trustedChangesInProgress = true;
        try {
            for (int i = 0; i < evs.size(); ++i) {
                EntryMarks ev = evs.get(i);
                if (ev.isSegmentChanged()) continue;
                this.remove(ev.builder, ev.markerIndex);
                try {
                    if (ev.builder.marks == null) {
                        ev.builder.marks = new MarkInfo[this.markerNames.length][];
                    }
                    ev.builder.marks[ev.markerIndex] = new MarkInfo[ev.result.size()];
                    for (int j = 0; j < ev.result.size(); ++j) {
                        MarkInfo nm;
                        ev.builder.marks[ev.markerIndex][j] = nm = new MarkInfo(ev.result.get(j), ev.builder, doc, this.highlighter);
                    }
                    continue;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        finally {
            doc.trustedChangesInProgress = false;
        }
    }

    protected static class Tooltip {
        Position p0;
        Position p1;
        String text;

        public Tooltip(Document3 doc, int start, int end, String text) throws BadLocationException {
            this.p0 = doc.createPosition(start);
            this.p1 = doc.createPosition(end);
            this.text = text;
        }
    }

    protected static class MarkInfo {
        Highlighter.Highlight highlight;
        Tooltip tooltip;

        public MarkInfo(Mark m, SegmentBuilder sb, Document3 doc, Highlighter highlighter) throws BadLocationException {
            if (m.entryPart == Mark.ENTRY_PART.SOURCE && sb.getSourceText() == null) {
                return;
            }
            int sourceStartOffset = sb.getStartSourcePosition();
            int translationStartOffset = sb.isActive() ? doc.getTranslationStart() : sb.getStartTranslationPosition();
            int startOffset = m.entryPart == Mark.ENTRY_PART.SOURCE ? sourceStartOffset : translationStartOffset;
            if (m.painter != null) {
                this.highlight = (Highlighter.Highlight)highlighter.addHighlight(startOffset + m.startOffset, startOffset + m.endOffset, m.painter);
            }
            if (m.toolTipText != null) {
                this.tooltip = new Tooltip(doc, startOffset + m.startOffset, startOffset + m.endOffset, m.toolTipText);
            }
            if (m.attributes != null) {
                doc.setCharacterAttributes(startOffset + m.startOffset, m.endOffset - m.startOffset, m.attributes, false);
            }
        }
    }
}

