/* xrmap - vector based global map generating program
 *
 * Copyright (C) 2001 Jean-Pierre Demailly <demailly@ujf-grenoble.fr>
 * ftp://ftp.ac-grenoble.fr/ge/geosciences
 *
 * derived from "rmap"
 * Copyright (C) 2000 Reza Naima <reza@reza.net>
 * http://www.reza.net/rmap/
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef SHAREDIR
#define SHAREDIR "/usr/share/rmap"
#endif

#define MAPFILE SHAREDIR"/CIA_WDB2.jpd"
#define LOCFILE SHAREDIR"/Locations"
#define RCFILE SHAREDIR"/Xrmaprc"
#define I18NPATH SHAREDIR"/i18n"
#define CIATEXTPATH SHAREDIR"/factbook/text"
#define CIAGEOSPATH SHAREDIR"/factbook/geos"
#define CIAMAPSPATH SHAREDIR"/factbook/maps"
#define CIAEXTRAPATH SHAREDIR"/factbook/extra"
#define PDFMAPSPATH SHAREDIR"/pdfmaps"
#define ANTHEMPATH SHAREDIR"/anthems"
#define HYMNPATH SHAREDIR"/hymns"
#define SMALLFLAGPATH SHAREDIR"/flags/small"
#define BIGFLAGPATH SHAREDIR"/flags/big"
#define PICONPATH SHAREDIR"/picons"
#define DOCPATH SHAREDIR"/doc"

#define DEFAULTBUTTONS "buttons/b%d.xpm.gz"

#define GO_UP   "<<<<<<"
#define GO_DOWN ">>>>>>"

#define NUM_BUTTONS 6

#ifndef PS_VIEWER
#define PS_VIEWER "gv -noantialias"   /* Should have gv installed !! */
#endif

#ifndef IM_VIEWER
#define IM_VIEWER "display -bg 84"    /* from ImageMagick package */
#endif

#ifndef HTML_VIEWER
#define HTML_VIEWER "dillo"           /* small, fast, lightweight browser */
#endif

#ifndef PRINT_CMD
#define PRINT_CMD "lpr -Plp"
#endif

#ifndef EDITOR
#define EDITOR "emx"
#endif

#define PAGEFORMAT "595 842"
#define PTPERMM  2.83464566929        /* 360/127 = number of pts per mm */

#define WARNING_TIME 2000000
#define MAXZOOM 1000.0
#define MINZOOM 0.01

#define COLOR_CHANGE 1
#define FONT_CHANGE 2
#define LANG_CHANGE 4

#define MAIN_WINDOW 1
#define DATA_WINDOW 2
#define CMD_WINDOW 4
#define EXPL_WINDOW 8
#define DONE_MARK 16

#define SPOT_DRAWN 1<<31
#define TEXT_DRAWN 1<<30
#define OBJ_HIDE   1<<29
#define OBJ_SHOW   1<<28

#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <dirent.h>
#include <time.h>
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <ctype.h>

#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/xpm.h>


/* The Constants, we just have to have the constants */
#define PI 3.1415926535897932
#define PI_OVER_2 1.5707963267948966        /* PI/2 */
#define PI_OVER_4 0.78539816339744828       /* PI/4 */
#define CONV 0.017453292519943295           /* PI/180 */
#define ONE_OVER_PI 0.3183098861837907      /* 1/PI */
#define TWO_OVER_PI 0.6366197723675814      /* 2/PI */
#define FIVE_OVER_2PI 0.79577471545947667   /* 5/2PI */
#define MAX_MILLER 0.7331989845164548       /* ln(tan(0.9*PI/2))*5/(4*PI) */
#define PI_SQUARE_OVER_8 1.2337005501361697 /* PI^2/8 */
#define MOLLWEIDE_COEFF  0.099632783197163519  /* 4/3-PI^2/8 */
#define STRETCHING 1.333333333333333333     /* 4/3*/
#define LARGE_INTEGER 1000000000

#define HEADER_MAGIC "!JPD1.0\n"     /* Magic string for JPD format */

/* Types of projections */
#define SPHERICAL 0
#define RECTANGULAR 1
#define CYLINDRICAL 2
#define MERCATOR 3
#define MILLER 4
#define SINUSOIDAL 5
#define ELLIPTIC 6
#define MOLLWEIDE 7
#define NUMPROJ 8

/* with, without */
#define WITHOUT 0
#define WITH    1

/* Reminder defines */
#define TOP 0
#define BOTTOM 10000

/* Colordata boolean defines */
#define INACTIVE -1
#define OFF 0
#define ON  1

/* Dumping options */
#define DUMP_JPD 0
#define DUMP_ASCII 1
#define DUMP_STAT 2

/* colordata further defines */
enum { C_BG_MAP=28,
       C_BG_SKY,
       C_FG_STARS,
       C_MAIN_LINES,
       C_LAT_GRID,
       C_LON_GRID,
       C_EARTH_CONTOUR,
       C_CITY_CIRCLE,
       C_CITY_TEXT,
       C_AIRPORT_SYMBOL,
       C_AIRPORT_TEXT,
       C_OBSERV_SYMBOL,
       C_OBSERV_TEXT,
       C_PEAK_TRIANGLE,
       C_PEAK_TEXT,
       C_LOC_LAND,
       C_LOC_WATER,
       C_FG_TEXT, 
       C_BG_TEXT, 
       C_FG_CARET,
       C_BG_CMDWIN,
       C_BG_ESCAPE,
       C_FG_TICKS,
       C_FG_DIR,
       C_FG_IMAGE,
       C_FG_MARKED,
       C_FG_SELRECT,
       C_FG_SELPOINT,
       C_ENDCOLOR };

/* Locations data types */
enum { T_NONE=0, T_COUNTRIES, T_TIMEZONES, 
       T_CITIES, T_AIRPORTS, T_OBSERVATORIES, T_PEAKS, 
       T_LOCATIONS, T_PRESELECTED};

/* structs */
typedef struct
{
  double comp[9];
}
Matrix;

typedef struct
{
  double coord[3];
}
Vector;

typedef struct
{
  double coord[2];
}
ScreenPt;

typedef struct
{
  double sph[2];
}
SpherePt;

/* And some simple defines to make the vector and matrix structs make sense */
#define X 0
#define Y 1
#define Z 2
#define LONGITUDE 0
#define LATITUDE  1

/* These defines are for the subroutine to determine if the segment is to be
   viewable or not */
#define NO 0
#define YES 1
#define POINT_ONLY 2


/* and the more important structs... */
typedef struct
{
  char magic[12];
  unsigned char maxlength[4];
  unsigned char index[560];
} Header;

typedef struct
{
  unsigned char minlong[3];
  unsigned char maxlong[3];
  unsigned char minlat[3];
  unsigned char maxlat[3];
  unsigned char address[4];
} Segment_index;

typedef struct
{
  unsigned short r;
  unsigned short g;
  unsigned short b;
  short bool;
  Pixel pix;
  char name[40];
  char *comment;
} Colordata;

typedef struct
{
  double xrot;
  double yrot;
  double zrot;
  double zoom;
  int desired_categories;
  int desired_continents;
  char hierarchy[6];
  short transparent;
} GeomOptions;

typedef struct
{
  double spacing_lat;
  double spacing_lon;
  int placetext;
  int smartlabels;
  int latcoord;
  int loncoord;
  char font[6][256];
  int mark_step[5];
  int name_step[5];
  int city_mark[5];
  int city_size[5];
  int airport_mark[5];
  int airport_size[5];
  int peak_mark[5];
  int peak_size[5];
  char city_filter[4];
  char loc_filter[16];
} RenderOptions;

typedef struct
{
  double xrot;
  double yrot;
  double zrot;
  double zoom;
  int loc;
} XYZPosition;

/* this struct defines the layout of the image (height, width, perspective..)*/
typedef struct 
{
  int width;			/* x */
  int height;			/* y */
  int projection;
  double shiftx;
  double shifty;
  double earth_radius;
  double aspect;
  double accuracy;
  Matrix rotation;
  GeomOptions gopt;
  RenderOptions ropt;
  XYZPosition *position;
  int num_positions;
  int ind_position;
  Pixmap prepixmap;
  Pixmap pixmap;
  void * backup;
  int numdef;
  char **def;
  int nummod;
  int *modpos;
  int numpoint;
  double *mempoint;
  Pixel currentpixel;
  int red_current;
  int green_current;
  int blue_current;
  int currentfont;
  char mapfile[256];
  char rcfile[256];
  char locfile[256];
  Colordata color[C_ENDCOLOR];
  char outfile[256];
  char macrofile[256];
  char theme[256];
} ImageLayout;

/* Country struct */

typedef struct
{
        char code2[4];
	char code3[4];
        char cia[4];
        char iana[4];
        char *name;
        char *flags;
        char *curr_code;
        char *currency;
        char *telephone;
        char *capital;
        int  area;
        int  population;
} Country;

/* timezone struct */

typedef struct
{
        char *code;
        char *flags;
        char *name;
        char *posix;
	int  country;  
        int  continent;
} Timezone;

/* city/location struct */

typedef struct
{
        char   obj;
        char   status;
	char*  name;
        char*  region;
	double lat;
	double lon;
        int    draw;
        int    alt;
        int    rank;
        int    contrank;
        int    worldrank;
        int    population;
        int    tz;
} Location;

/* Extern references */
extern void show_explwin(ImageLayout *scene, int x, int y);
extern void free_dirlist(char **table);
extern void str2value(ImageLayout * scene, int i, char * str);
extern void draw_win_cmd(ImageLayout * scene, int level);
extern int  get_window_placement(Window win, int *x, int *y, 
			         unsigned int *w, unsigned int *h);
extern void close_explwin();
