#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <zlib.h>
#include <sys/stat.h>

void usage()
{
    fprintf(stderr, 
       "Usage: loc_extract [-file name] [-format spec] [-separator string]\n");
    exit(0);
}

int main(int argc, char **argv)
{
    FILE *fd, *fdp;
    char buf[1024];
    char *filename=NULL, *format=NULL;
    char *str, *ptr, *ptrp;
    char field[30][120];
    char *separator = "|";
    int i, j, k, l, min, max, bool, num;

    for (i=1; i<argc; i++) {
       if (!strncmp(argv[i], "-h", 2)) usage();
       else
       if (i<argc-1 && !strncmp(argv[i], "-file",4))
	  filename = strdup(argv[++i]);
       else
       if (i<argc-1 && !strncmp(argv[i], "-format",4))
	  format = strdup(argv[++i]);
       else
       if (i<argc-1 && !strncmp(argv[i], "-separator",4))
	  separator = strdup(argv[++i]);
    }

    if (!filename) {
       fprintf(stderr, "No file name specified !!\n");
       exit(-1);
    }
    if (!format) {
       fprintf(stderr, "No format specified !!\n");
       exit(-1);
    }
    fd =  fopen(filename, "r");
    if (!fd) {
       fprintf(stderr, "Can't open %s !!\n", filename);
       exit(-1);
    }
    min = 100;
    max = 0;
    l = strlen(format);
    while((str=fgets(buf, 1000, fd))) {
       i = -1;
       bool = 0;
       while (1) {
	  ptr = str;
	  ++i;
          while (*ptr && *ptr!=',' && *ptr=='\"') ++ptr;
	  if (!*ptr) break;
	  if (*ptr==',') {
	     field[i][0] = '\0';
	     str = ptr+1;
	     continue;
	  }
	  str = ptr;
	  ptrp = ptr;
          while(*ptr && *ptr!=',') { 
             if (*ptr!='\"') ptrp = ptr; 
	     ++ptr; 
	  }
	  if (!*ptr) bool = 1;
          ptrp[1] = '\0';
          strcpy(field[i], str);
	  str = ptr+1;
	  if (bool) break;
       }
       if (i>max) max = i;
       if (i<min) min = i;
       for (k=0; k<l; k++) {
	  j = format[k];
	  if (j>='0' && j<='9')
	     j = format[k] - '0';
	  else
	  if (j>='A' && j<='Z')
	     j = 10+format[k] - 'A';
	  else
	  if (j>='a' && j<='z')
	     j = 10+format[k] - 'a';
/*
	  if (j==0) {
             double x, y;
	     x = atof(field[5])*0.3048+0.499999;
	     y = atof(field[8])*0.3048+0.499999;
	     sprintf(field[5], "%d", (int)x);
	     sprintf(field[8], "%d", (int)y);
	  }
*/
/*
	  if (j==0) {
	     int p;
	     for (p=9; p<=12; p++)
	        field[p][0] = '\0';
	     strcpy(field[8], "??");
	     for (p=0; p<numcountries; p++) {
	       if (strstr(field[j], countries_short[2*p+1])) {
		  strcpy(field[8], countries_short[2*p]);
		  break;
	       }
	     }
	  }
*/
	  if (j<i)
	     printf("%s", field[j]);
	  else
             printf("(none)");
          if (k==l-1)
             printf("\n");
	  else
             printf("%s", separator);
       }
    }

    fprintf(stderr, "Number of fields: minimum %d, maximum %d\n", min, max);
    fclose(fd);
}




