/* Continents according to CIA World Data Base II */

enum { NONE=0, AF, AS, EU, NA, SA };
char *continents[] = {
"AD", EU,
"AE", AS,
"AF", AS,
"AG", SA,
"AI", SA,
"AL", EU,
"AM", AS,
"AN", SA,
"AO", AF,
"AQ", AF,
"AQ", SA,
"AR", SA,
"AS", AS,
"AT", EU,
"AU", AS,
"AW", SA,
"AZ", AS,
"BA", EU,
"BB", SA,
"BD", AS,
"BE", EU,
"BF", AF,
"BG", EU,
"BH", AS,
"BI", AF,
"BJ", AF,
"BM", SA,
"BN", AS,
"BO", SA,
"BR", SA,
"BS", SA,
"BT", AS,
"BW", AF,
"BY", AS,
"BZ", SA,
"CA", NA,
"CD", AF,
"CF", AF,
"CG", AF,
"CH", EU,
"CI", AF,
"CK", AS,
"CL", AS,
"CL", SA,
"CM", AF,
"CN", AS,
"CO", SA,
"CR", SA,
"CU", SA,
"CV", AF,
"CX", AS,
"CY", AF,
"CZ", EU,
"DE", EU,
"DJ", AF,
"DK", EU,
"DM", SA,
"DO", SA,
"DZ", AF,
"EC", SA,
"EE", AS,
"EG", AF,
"EH", AF,
"EN", EU,
"ER", AF,
"ES", EU,
"ET", AF,
"FI", EU,
"FJ", AS,
"FK", SA,
"FM", AS,
"FO", EU,
"FR", AF,
"FR", EU,
"FR", SA,
"GA", AF,
"GD", SA,
"GE", AS,
"GG", EU,
"GH", AF,
"GI", AF,
"GL", NA,
"GM", AF,
"GN", AF,
"GP", SA,
"GQ", AF,
"GR", EU,
"GS", SA,
"GT", SA,
"GU", AS,
"GW", AF,
"GY", SA,
"HK", AS,
"HN", SA,
"HR", EU,
"HT", SA,
"HU", EU,
"IC", AF,
"ID", AS,
"IE", EU,
"IL", AF,
"IM", EU,
"IN", AS,
"IO", AS,
"IQ", AF,
"IR", AS,
"IS", EU,
"IT", EU,
"JE", EU,
"JM", SA,
"JO", AS,
"JP", AS,
"KE", AF,
"KG", AS,
"KH", AS,
"KI", AS,
"KM", AF,
"KN", SA,
"KP", AS,
"KR", AS,
"KW", AS,
"KY", SA,
"KZ", AS,
"LA", AS,
"LB", AF,
"LC", SA,
"LI", EU,
"LK", AS,
"LR", AF,
"LS", AF,
"LT", AS,
"LU", EU,
"LV", AS,
"LY", AF,
"MA", AF,
"MC", EU,
"MD", AS,
"MG", AF,
"MH", AS,
"MK", EU,
"ML", AF,
"MM", AS,
"MN", AS,
"MO", AS,
"MP", AS,
"MR", AF,
"MS", SA,
"MT", AF,
"MU", AF,
"MV", AS,
"MW", AF,
"MX", SA,
"MY", AS,
"MZ", AF,
"NA", AF,
"NC", AS,
"NE", AF,
"NF", AS,
"NG", AF,
"NIR", EU,
"NI", SA,
"NL", EU,
"NO", AS,
"NO", EU,
"NP", AS,
"NR", AS,
"NU", AS,
"NZ", AS,
"OM", AF,
"PA", SA,
"PE", SA,
"PF", AS,
"PG", AS,
"PH", AS,
"PK", AS,
"PL", EU,
"PM", NA,
"PN", AS,
"PR", SA,
"PS", AF,
"PT", AF,
"PT", EU,
"PW", AS,
"PY", SA,
"QA", AS,
"RE", AF,
"RO", EU,
"RU", AS,
"RW", AF,
"SA", AF,
"SB", AS,
"SCO", EU,
"SC", AF,
"SD", AF,
"SE", EU,
"SG", AS,
"SH", AF,
"SI", EU,
"SK", EU,
"SL", AF,
"SM", EU,
"SN", AF,
"SO", AF,
"SR", SA,
"ST", AF,
"SV", SA,
"SY", AF,
"SZ", AF,
"TC", SA,
"TD", AF,
"TG", AF,
"TH", AS,
"TJ", AS,
"TK", AS,
"TM", AS,
"TN", AF,
"TO", AS,
"TP", AS,
"TR", AF,
"TT", SA,
"TV", AS,
"TW", AS,
"TZ", AF,
"UA", AS,
"UG", AF,
"US", AS,
"US", NA,
"UY", SA,
"UZ", AS,
"VA", EU,
"VC", SA,
"VE", SA,
"VG", SA,
"VI", SA,
"VN", AS,
"VU", AS,
"WA", EU,
"WF", AS,
"WS", AS,
"YE", AF,
"YU", EU,
"ZA", AF,
"ZM", AF,
"ZW", AF,
};

char *countries[] = {
"AD", "Andorra, Principality of",
"AE", "United Arab Emirates",
"AF", "Afghanistan, Islamic State of",
"AG", "Antigua & Barbuda",
"AI", "Anguilla",
"AL", "Albania",
"AM", "Armenia",
"AN", "Netherlands Antilles",
"AO", "Angola",
"AQ", "Antarctica",
"AR", "Argentina",
"AS", "American Samoa, Territory of",
"AT", "Austria",
"AU", "Australia",
"AW", "Aruba Island",
"AZ", "Azerbaijan",
"BA", "Bosnia & Herzegovina",
"BB", "Barbados",
"BD", "Bangladesh",
"BE", "Belgium, Kingdom of",
"BF", "Burkina Faso",
"BG", "Bulgaria",
"BH", "Bahrain, Emirate of",
"BI", "Burundi",
"BJ", "Benin",
"BM", "Bermuda",
"BN", "Brunei Darussalam, Sultanate of",
"BO", "Bolivia",
"BR", "Brazil, Federative Republic of",
"BS", "Bahamas, Commonwealth of the",
"BT", "Bhutan, Kingdom of",
"BV", "Bouvet Island, Territory of",
"BW", "Botswana",
"BY", "Belarus",
"BZ", "Belize",
"CA", "Canada",
"CC", "Cocos (Keeling) Islands, Territory of",
"CD", "Democratic Republic of the Congo (formerly Zaire)",
"CF", "Central African Republic",
"CG", "Congo",
"CH", "Switzerland",
"CI", "Cte d'Ivoire",
"CK", "Cook Islands",
"CL", "Chile",
"CM", "Cameroon",
"CN", "People's Republic of China",
"CO", "Colombia",
"CR", "Costa Rica",
"CU", "Cuba",
"CV", "Cape Verde",
"CX", "Christmas Island, Territory of",
"CY", "Cyprus",
"CZ", "Czech Republic",
"DE", "Germany, Federal Republic of",
"DJ", "Djibouti",
"DK", "Denmark, Kingdom of",
"DM", "Dominica, Commonwealth of",
"DO", "Dominican Republic",
"DZ", "Algeria, Democratic Popular Republic of",
"EC", "Ecuador",
"EE", "Estonia",
"EG", "Egypt, Arab Republic of",
"EH", "Western Sahara",
"ER", "Eritrea",
"ES", "Spain, Kingdom of",
"ET", "Ethiopia, Federal Democratic Republic of",
"FI", "Finland",
"FJ", "Fiji Islands",
"FK", "Falkland Islands, Colony of (Islas Malvinas)",
"FM", "Micronesia, Federated States of",
"FO", "Faroe Islands",
"FR", "France",
"GA", "Gabon",
"GB", "Great Britain",
"GD", "Grenada",
"GE", "Georgia",
"GF", "French Guiana, Overseas Department of",
"GG", "Guernsey, Bailiwick of",
"GH", "Ghana",
"GI", "Gibraltar",
"GL", "Greenland",
"GM", "Gambia",
"GN", "Guinea",
"GP", "Guadeloupe & Dependancies, Overseas Department of",
"GQ", "Equatorial Guinea",
"GR", "Greece",
"GS", "South Georgia & the South Sandwich Islands, Territory of",
"GT", "Guatemala",
"GU", "Guam, Territory of",
"GW", "Guinea Bissau",
"GY", "Guyana, Cooperative Republic of",
"HK", "Hong Kong, Special Administrative Region of",
"HM", "Heard & Mc Donald Islands, Territory of",
"HN", "Honduras",
"HR", "Croatia",
"HT", "Haiti",
"HU", "Hungary",
"ID", "Indonesia",
"IE", "Ireland",
"IL", "Israel, State of",
"IM", "Isle of Man, Territory of",
"IN", "India",
"IO", "British Territory of the Indian Ocean",
"IQ", "Iraq",
"IR", "Iran, Islamic Republic of",
"IS", "Iceland",
"IT", "Italy",
"JE", "Jersey, Bailiwick of",
"JM", "Jamaica",
"JO", "Jordan, Hashemite Kingdom of",
"JP", "Japan, Imperial State of",
"KE", "Kenya",
"KG", "Kyrgyzstan",
"KH", "Cambodia, Kingdom of",
"KI", "Kiribati",
"KM", "Comoros",
"KN", "Saint Kitts & Nevis",
"KP", "Korea, Democratic People's Republic of (North Korea)",
"KR", "Korea, South",
"KW", "Kuwait, Emirate of",
"KY", "Cayman Islands",
"KZ", "Kazakhstan",
"LA", "Laos, People's Democratic Republic",
"LB", "Lebanon",
"LC", "Saint Lucia",
"LI", "Liechtenstein, Principality of",
"LK", "Sri Lanka",
"LR", "Liberia",
"LS", "Lesotho, Kingdom of",
"LT", "Lithuania",
"LU", "Luxembourg, Grand Duchy of",
"LV", "Latvia",
"LY", "Libyan Arab Jamahiriya, Socialist People's",
"MA", "Morocco, Kingdom of",
"MC", "Monaco, Principality of",
"MD", "Moldova",
"MG", "Madagascar",
"MH", "Marshall Islands",
"MK", "Macedonia, The Former Yugoslav Republic of",
"ML", "Mali",
"MM", "Myanmar (Burma)",
"MN", "Mongolia",
"MO", "Macau, Special Administrative Region of",
"MP", "Northern Mariana Islands, Commonwealth of the",
"MQ", "Martinique, Overseas Department of the",
"MR", "Mauritania, Islamic Republic of",
"MS", "Montserrat, Territory of",
"MT", "Malta",
"MU", "Mauritius",
"MV", "Maldives",
"MW", "Malawi",
"MX", "Mexico (United Mexican States)",
"MY", "Malaysia, Kingdom of",
"MZ", "Mozambique",
"NA", "Namibia",
"NC", "New Caledonia, Overseas Territory of",
"NE", "Niger",
"NF", "Norfolk Island, Territory of",
"NG", "Nigeria, Federal Republic of",
"NI", "Nicaragua",
"NL", "Netherlands, Kingdom of the",
"NO", "Norway, Kingdom of",
"NP", "Nepal, Kingdom of",
"NR", "Nauru",
"NU", "Niue",
"NZ", "New Zealand",
"OM", "Oman, Sultanate of",
"PA", "Panama, Unified Republic of",
"PC", "Paracel Islands, Territory of",
"PE", "Peru",
"PF", "French Polynesia, Overseas Territory of",
"PG", "Papua New Guinea, Independent State of",
"PH", "Philippines",
"PK", "Pakistan, Islamic Republic of",
"PL", "Poland",
"PM", "Saint Pierre & Miquelon, Overseas Territorial Collectivity of",
"PN", "Pitcairn Islands",
"PR", "Puerto Rico, Commonwealth of",
"PS", "Palestine, Occupied Territory of",
"PT", "Portugal",
"PW", "Palau",
"PY", "Paraguay",
"QA", "Qatar, Emirate of",
"RE", "Runion, Overseas Department of the",
"RO", "Romania",
"RU", "Russia, Federation of",
"RW", "Rwanda",
"SA", "Saudi Arabia, Kingdom of",
"SB", "Solomon Islands",
"SC", "Seychelles",
"SD", "Sudan",
"SE", "Sweden, Kingdom of",
"SG", "Singapore",
"SH", "Saint Helena",
"SI", "Slovenia",
"SJ", "Svlbard & Jan Mayen Islands, Territory of",
"SK", "Slovakia",
"SL", "Sierra Leone",
"SM", "San Marino",
"SN", "Sngal",
"SO", "Somalia",
"SR", "Suriname",
"ST", "So Tom & Prncipe",
"SV", "El Salvador",
"SY", "Syria, Arab Republic of",
"SZ", "Swaziland",
"TC", "Turks & Caicos Islands, Territory of",
"TD", "Chad",
"TF", "French Austral & Antartic Territories",
"TG", "Togo",
"TH", "Thailand, Kingdom of",
"TJ", "Tajikistan",
"TK", "Tokelau",
"TM", "Turkmenistan",
"TN", "Tunisia",
"TO", "Tonga, Kingdom of",
"TP", "Timor, East",
"TR", "Turkey",
"TT", "Trinidad & Tobago",
"TV", "Tuvalu",
"TW", "Taiwan, Republic of China",
"TZ", "Tanzania, United Republic of",
"UA", "Ukraine",
"UG", "Uganda",
"US", "United States of America, Federal Union of the",
"UY", "Uruguay",
"UZ", "Uzbekistan",
"VA", "Holy See, State of Vatican City",
"VC", "Saint Vincent & the Grenadines",
"VE", "Venezuela",
"VG", "Virgin Islands, British Territory of the",
"VI", "Virgin Islands, U.S. Territory of the",
"VN", "Viet Nam, Socialist Republic of",
"VU", "Vanuatu",
"WF", "Wallis & Futuna Islands, Overseas Territory of",
"WS", "Samoa, Independent State of (Western Samoa)",
"YE", "Yemen",
"YT", "Mayotte, Territorial Collectivity of",
"YU", "Yugoslavia, Federation of",
"ZA", "South Africa",
"ZM", "Zambia",
"ZW", "Zimbabwe"
};

char *countries_short[] = {
"AD", "Andorra",
"AE", "United Arab Emirates",
"AF", "Afghanistan",
"AG", "Antigua & Barbuda",
"AI", "Anguilla",
"AL", "Albania",
"AM", "Armenia",
"AN", "Netherlands Antilles",
"AO", "Angola",
"AQ", "Antarctica",
"AR", "Argentina",
"AS", "American Samoa",
"AT", "Austria",
"AU", "Australia",
"AW", "Aruba Island",
"AZ", "Azerbaijan",
"BA", "Bosnia & Herzegovina",
"BB", "Barbados",
"BD", "Bangladesh",
"BE", "Belgium",
"BF", "Burkina Faso",
"BG", "Bulgaria",
"BH", "Bahrain",
"BI", "Burundi",
"BJ", "Benin",
"BM", "Bermuda",
"BN", "Brunei Darussalam",
"BO", "Bolivia",
"BR", "Brazil",
"BS", "Bahamas",
"BT", "Bhutan",
"BV", "Bouvet Island",
"BW", "Botswana",
"BY", "Belarus",
"BZ", "Belize",
"CA", "Canada",
"CC", "Cocos",
"CD", "Democratic Republic of the Congo",
"CF", "Central African Republic",
"CG", "Congo",
"CH", "Switzerland",
"CI", "Cte d'Ivoire",
"CK", "Cook Islands",
"CL", "Chile",
"CM", "Cameroon",
"CN", "People's Republic of China",
"CO", "Colombia",
"CR", "Costa Rica",
"CU", "Cuba",
"CV", "Cape Verde",
"CX", "Christmas Island",
"CY", "Cyprus",
"CZ", "Czech Republic",
"DE", "Germany",
"DJ", "Djibouti",
"DK", "Denmark",
"DO", "Dominican Republic",
"DM", "Dominica",
"DZ", "Algeria",
"EC", "Ecuador",
"EE", "Estonia",
"EG", "Egypt",
"EH", "Western Sahara",
"ER", "Eritrea",
"ES", "Spain",
"ET", "Ethiopia",
"FI", "Finland",
"FJ", "Fiji",
"FK", "Falkland",
"FM", "Micronesia",
"FO", "Faroe",
"FR", "France",
"GA", "Gabon",
"GB", "Great Britain",
"GD", "Grenada",
"GE", "Georgia",
"GF", "French Guiana",
"GG", "Guernsey",
"GH", "Ghana",
"GI", "Gibraltar",
"GL", "Greenland",
"GM", "Gambia",
"GN", "Guinea",
"GP", "Guadeloupe",
"GQ", "Equatorial Guinea",
"GR", "Greece",
"GS", "Sandwich",
"GT", "Guatemala",
"GU", "Guam",
"GW", "Guinea Bissau",
"GY", "Guyana",
"HK", "Hong Kong",
"HM", "Heard",
"HN", "Honduras",
"HR", "Croatia",
"HT", "Haiti",
"HU", "Hungary",
"ID", "Indonesia",
"IE", "Ireland",
"IL", "Israel",
"IM", "Man",
"IN", "India",
"IO", "British",
"IQ", "Iraq",
"IR", "Iran",
"IS", "Iceland",
"IT", "Italy",
"JE", "Jersey",
"JM", "Jamaica",
"JO", "Jordan",
"JP", "Japan",
"KE", "Kenya",
"KG", "Kyrgyzstan",
"KH", "Cambodia",
"KI", "Kiribati",
"KM", "Comoros",
"KN", "Kitts",
"KP", "North Korea",
"KR", "South Korea",
"KW", "Kuwait",
"KY", "Cayman",
"KZ", "Kazakhstan",
"LA", "Laos",
"LB", "Lebanon",
"LC", "Lucia",
"LI", "Liechtenstein",
"LK", "Sri Lanka",
"LR", "Liberia",
"LS", "Lesotho",
"LT", "Lithuania",
"LU", "Luxembourg",
"LV", "Latvia",
"LY", "Libya",
"MA", "Morocco",
"MC", "Monaco",
"MD", "Moldova",
"MG", "Madagascar",
"MH", "Marshall",
"MK", "Macedonia",
"ML", "Mali",
"MM", "Myanmar",
"MN", "Mongolia",
"MO", "Macau",
"MP", "Mariana",
"MQ", "Martinique",
"MR", "Mauritania",
"MS", "Montserrat",
"MT", "Malta",
"MU", "Mauritius",
"MV", "Maldives",
"MW", "Malawi",
"MX", "Mexico",
"MY", "Malaysia",
"MZ", "Mozambique",
"NA", "Namibia",
"NC", "Caledonia",
"NE", "Niger",
"NF", "Norfolk",
"NG", "Nigeria",
"NI", "Nicaragua",
"NL", "Netherlands",
"NO", "Norway",
"NP", "Nepal",
"NR", "Nauru",
"NU", "Niue",
"NZ", "Zealand",
"OM", "Oman",
"PA", "Panama",
"PC", "Paracel",
"PE", "Peru",
"PF", "Polynesia",
"PG", "Papua",
"PH", "Philippines",
"PK", "Pakistan",
"PL", "Poland",
"PM", "Miquelon",
"PN", "Pitcairn",
"PR", "Rico",
"PS", "Palestine",
"PT", "Portugal",
"PW", "Palau",
"PY", "Paraguay",
"QA", "Qatar",
"RE", "Runion",
"RO", "Romania",
"RU", "Russia",
"RW", "Rwanda",
"SA", "Saudi",
"SB", "Solomon",
"SC", "Seychelles",
"SD", "Sudan",
"SE", "Sweden",
"SG", "Singapore",
"SH", "Helena",
"SI", "Slovenia",
"SJ", "Svlbard",
"SJ", "Mayen",
"SK", "Slovakia",
"SL", "Leone",
"SM", "Marino",
"SN", "Sngal",
"SO", "Somalia",
"SR", "Suriname",
"ST", "So Tom",
"SV", "Salvador",
"SY", "Syria",
"SZ", "Swaziland",
"TC", "Caicos",
"TD", "Chad",
"TF", "French Austral",
"TG", "Togo",
"TH", "Thailand",
"TJ", "Tajikistan",
"TK", "Tokelau",
"TM", "Turkmenistan",
"TN", "Tunisia",
"TO", "Tonga",
"TP", "Timor",
"TR", "Turkey",
"TT", "Trinidad",
"TV", "Tuvalu",
"TW", "Taiwan",
"TZ", "Tanzania",
"UA", "Ukraine",
"UG", "Uganda",
"US", "United States",
"UY", "Uruguay",
"UZ", "Uzbekistan",
"VA", "Vatican",
"VC", "Vincent",
"VE", "Venezuela",
"VG", "Virgin Islands, British Territory of the",
"VI", "Virgin Islands, U.S. Territory of the",
"VN", "Vietnam",
"VU", "Vanuatu",
"WF", "Wallis",
"WS", "Samoa",
"YE", "Yemen",
"YT", "Mayotte",
"YU", "Yugoslavia",
"ZA", "South Africa",
"ZM", "Zambia",
"ZW", "Zimbabwe"
};

char * currencies[] = {
"AE", "Dirham, 1000 fils",
"AF", "Afghani, 100 puls",
"AR", "Austral, 100 centavos",
"AT", "Euro, 100 cents (Schilling, 100 groschen)",
"AU", "Dollar, 100 cents",
"BB", "Dollar, 100 cents",
"BE", "Euro, 100 cents (Franc, 100 centimes)",
"BG", "Lev, 100 stotinki",
"BH", "Dinar, 1000 fils",
"BJ", "Franc, 100 centimes",
"BN", "Dollar, 100 cents or sen",
"BO", "Boliviano, 100 centavos",
"BS", "Dollar, 100 cents",
"BZ", "Dollar, 100 cents",
"CA", "Dollar, 100 cents",
"CF", "Franc, 100 centimes",
"CG", "Franc, 100 centimes",
"CH", "Franc, 100 centimes",
"CI", "Franc, 100 centimes",
"CL", "Peso, 100 centavos",
"CM", "Franc, 100 centimes",
"CN", "Yuan, 10 fen",
"CO", "Peso, 100 centavos",
"CR", "Colon, 100 centimos",
"CU", "Peso, 100 centavos",
"CZ", "Koruna, 100 halers",
"DE", "Euro, 100 cents (Deutsche mark, 100 pfennige)",
"DJ", "Franc, 100 centimes",
"DK", "Euro, 100 cents (Krone, 100 ore)",
"DO", "Peso, 100 centavos",
"DZ", "Dinar, 100 centimes",
"EC", "Sucre, 100 centavos",
"EG", "Pound, 100 piastres",
"ES", "Euro, 100 cents (Peseta, 100 centimos)",
"ET", "Birr, 100 cents",
"FI", "Euro, 100 cents (Markka, 100 pennia)",
"FJ", "Dollar, 100 cents",
"FR", "Euro, 100 cents (Franc, 100 centimes)",
"GA", "Franc, 100 centimes",
"GB", "Pound, 100 pence",
"GF", "Dollar, 100 cents",
"GH", "Cedi, 100 pesewas",
"GM", "Dalasi, 100 bututs",
"GN", "Franc, 100 centimes",
"GR", "Euro, 100 cents (Drachma, 100 lepta)",
"GT", "Quetzal, 100 centavos",
"HK", "Dollar, 100 cents",
"HN", "Lempira, 100 centavos",
"HT", "Gourde, 100 centimes",
"HU", "Forint, 100 filler",
"ID", "Rupiah, 100 sen",
"IE", "Euro, 100 cents (Pound, 100 pence)",
"IL", "Shekel, 100 agorot",
"IN", "Rupee, 100 paise",
"IQ", "Dinar, 1000 fils",
"IS", "Krona, 100 aurar",
"IT", "Euro, 100 cents (Lira, 100 centesimi)",
"JM", "Dollar, 100 cents",
"JO", "Dinar, 1000 fils",
"JP", "Yen, 100 cen",
"KE", "Shilling, 100 cents",
"KR", "Won, 100 chon",
"KW", "Dinar, 1000 fils",
"KY", "Dollar, 100 cents",
"LB", "Pound, 100 piastres",
"LK", "Rupee, 100 cents",
"LU", "Euro, 100 cents (Franc, 100 centimes)",
"MA", "Dirham, 100 centimes",
"MN", "Tugrik, 100 mongo",
"MR", "Ouguiya, 5 khoums",
"MT", "Lira or pound, 100 cents",
"MU", "Rupee, 100 cents",
"MV", "Rufiyaa, 100 laari",
"MW", "Kwacha, 100 tambala",
"MX", "Peso, 100 centavos",
"MY", "Ringgit, 100 sen",
"NE", "Franc, 100 centimes",
"NI", "Cordoba, 100 centavos",
"NL", "Euro, 100 cents (Guilder, 100 cents)",
"NO", "Krone, 100 ore",
"NP", "Rupee, 100 paisa",
"NZ", "Dollar, 100 cents",
"OM", "Riyal-omani, 1000 baiza",
"PE", "Inti, 100 centimes",
"PG", "Kina, 100 toea",
"PH", "Peso, 100 centavos",
"PK", "Rupee, 100 paisa",
"PL", "Zloty, 100 groszy",
"PT", "Euro, 100 cents (Escudo, 100 centavos)",
"PY", "Guarani, 100 centimos",
"QA", "Riyal, 100 dirhams",
"RO", "Leu, 100 bani",
"SA", "Riyal, 100 dirhams",
"SB", "Dollar, 100 cents",
"SC", "Rupee, 100 cents",
"SD", "Pound, 100 piastres",
"SE", "Euro, 100 cents (Krona, 100 ore)",
"SG", "Dollar, 100 cents",
"SL", "Leone, 100 cents",
"SN", "Franc, 100 centimes",
"SO", "Shilling, 100 cents",
"SR", "Guilder, 100 cents",
"SV", "Colon, 100 centavos",
"SY", "Pound, 100 piastres",
"TD", "Franc, 100 centimes",
"TG", "Franc, 100 centimes",
"TH", "Baht, 100 satang",
"TN", "Dinar, 1000 millimes",
"TR", "Lira, 100 kurus",
"TT", "Dollar, 100 cents",
"TW", "Dollar, 100 cents",
"TZ", "Shilling, 100 cents",
"UG", "Shilling, 100 cents",
"US", "Dollar, 100 cents",
"UY", "Peso, 100 centesimos",
"VE", "Bolivar, 100 centimos",
"VN", "Dong, 100 xu",
"WS", "Tala, 100 sene",
"YU", "Dinar, 100 paras",
"ZA", "Rand, 100 cents",
"ZM", "Kwacha, 100 ngwee",
"ZW", "Dollar, 100 cents"
};

char *extradata[] = {
"AD", "Andorra la Vella", "468", "67627",
"AE", "Abu Dhabi", "82880", "2407460",
"AF", "Kabul", "652000", "26813057",
"AG", "Saint John's", "442", "66970",
"AL", "Tiran", "28748", "3510484",
"AM", "Yerevan", "29800", "3336100",
"AO", "Luanda", "1246700", "10366031",
"AR", "Buenos Aires", "2766890", "37384816",
"AT", "Vienna", "83858", "8150835",
"AU", "Canberra", "7686850", "19357594",
"AZ", "Baku", "86600", "7771092",
"BA", "Sarajevo", "51129", "3922205",
"BB", "Bridgetown", "430", "275330",
"BD", "Dhaka", "144000", "131269860",
"BE", "Brussels", "30510", "10258762",
"BF", "Ouagadougou", "274200", "12272289",
"BG", "Sofia", "110910", "7707495",
"BH", "Al-Manmah", "620", "645361",
"BI", "Bujumbura", "27830", "6223897",
"BJ", "Porto-Novo", "112620", "6590782",
"BN", "Bandar Seri Begawan", "5770", "343653",
"BO", "La Paz", "1098580", "8300463",
"BR", "Braslia", "8511965", "174468575",
"BS", "Nassau", "13940", "297852",
"BT", "Thimphu", "47000", "2049412",
"BW", "Gaborone", "600370", "1586119",
"BY", "Minsk", "207600", "10350194",
"BZ", "Belmopan", "22960", "256062",
"CA", "Ottawa", "9976140", "31592805",
"CD", "Kinshasa", "2345410", "53624718",
"CF", "Bangui", "622984", "3576884",
"CG", "Brazzaville", "342000", "2894336",
"CH", "Bern", "41290", "7283274",
"CI", "Yamoussoukro", "322460", "16393221",
"CL", "Santiago", "756950", "15328467",
"CM", "Yaound", "475440", "15803220",
"CN", "Beijing", "9596960", "1273111290",
"CO", "Bogot", "1138910", "40349388",
"CR", "San Jos", "51100", "3773057",
"CU", "Havana", "110860", "11184023",
"CV", "Praia", "4033", "405163",
"CY", "Nicosia", "9250", "762887",
"CZ", "Prague", "78866", "10264212",
"DE", "Berlin", "357021", "83029536",
"DJ", "Djibouti", "22000", "460700",
"DK", "Copenhagen", "43094", "5352815",
"DM", "Roseau", "754", "70786",
"DO", "Santo Domingo", "48730", "8581477",
"DZ", "Algiers", "2381740", "31736053",
"EC", "Quito", "283560", "13183978",
"EE", "Tallinn", "45226", "1423316",
"EG", "Cairo", "1001450", "69536644",
"EH", "!", "266000", "250559",
"ER", "Asmara", "121320", "4298269",
"ES", "Madrid", "504782", "40037995",
"ET", "Addis Ababa", "1127127", "65891874",
"FI", "Helsinki", "337030", "5175783",
"FJ", "Suva", "18270", "844330",
"FM", "Palikir", "702", "134597",
"FR", "Paris", "547030", "59551227",
"GA", "Libreville", "267667", "1221175",
"GB", "London", "244820", "59647790",
"GD", "Saint George's", "340", "89227",
"GE", "Tbilisi", "69700", "4989285",
"GF", "Georgetown", "214970", "697181",
"GH", "Accra", "238540", "19894014",
"GM", "Banjul", "11300", "1411205",
"GN", "Conakry", "245857", "7613870",
"GQ", "Malabo", "28051", "486060",
"GR", "Athens", "131940", "10623835",
"GT", "Guatemala City", "108890", "12974361",
"GW", "Bissau", "36120", "1315822",
"HN", "Tegucigalpa", "112090", "6406052",
"HR", "Zagreb", "56538", "4334142",
"HT", "Port-au-Prince", "27750", "6964549",
"HU", "Budapest", "93030", "10106017",
"ID", "Jakarta", "1919440", "228437870",
"IE", "Dublin", "70280", "3840838",
"IL", "Jerusalem", "20770", "5938093",
"IN", "New Delhi", "3287590", "1029991145",
"IQ", "Baghdad", "437072", "23331985",
"IR", "Tehran", "1648000", "66128965",
"IS", "Reykjavik", "103000", "277906",
"IT", "Rome", "301230", "57679825",
"JM", "Kingston", "10990", "2665636",
"JO", "Amman", "89213", "5153378",
"JP", "Tokyo", "377835", "126771662",
"KE", "Nairobi", "582650", "30765916",
"KG", "Bishkek", "198500", "4753003",
"KH", "Phnom Penh", "181040", "12491501",
"KI", "Tarawa", "717", "94149",
"KM", "Moroni", "2170", "596202",
"KN", "Basseterre", "261", "38756",
"KP", "Pyongyang", "120540", "21968228",
"KR", "Seoul", "98480", "47904370",
"KW", "Kuwait City", "17820", "2041961",
"KZ", "Almaty", "2717300", "16731303",
"LA", "Vientiane", "236800", "5635967",
"LB", "Beirut", "10400", "3627774",
"LC", "Castries", "620", "158178",
"LI", "Vaduz", "160", "32528",
"LK", "Colombo", "65610", "19408635",
"LR", "Monrovia", "111370", "3225837",
"LS", "Maseru", "30355", "2177062",
"LT", "Vilnius", "65200", "3610535",
"LU", "Luxembourg", "2586", "442972",
"LV", "Riga", "64589", "2385231",
"LY", "Tripoli", "1759540", "5240599",
"MA", "Rabat", "446550", "30645305",
"MC", "Monaco", "1.95", "31842",
"MD", "Chisinau", "33843", "4431570",
"MG", "Antananarivo", "587040", "15982563",
"MH", "Majuro", "181", "70822",
"MK", "Skopje", "25333", "2046209",
"ML", "Bamako", "1240000", "11008518",
"MM", "Rangoon", "678500", "41994678",
"MN", "Ulan Bator", "1565000", "2654999",
"MR", "Nouakchott", "1030700", "2747312",
"MT", "Valletta", "316", "394583",
"MU", "Port Louis", "1860", "1189825",
"MV", "Mal", "300", "310764",
"MW", "Lilongwe", "118480", "10548250",
"MX", "Mexico City", "1972550", "101879171",
"MY", "Kuala Lumpur", "329750", "22229040",
"MZ", "Maputo", "801590", "19371057",
"NA", "Windhoek", "825418", "1797677",
"NE", "Niamey", "1267000", "10355156",
"NG", "Abuja", "923768", "126635626",
"NI", "Managua", "129494", "4918393",
"NL", "Amsterdam", "41532", "15981472",
"NO", "Oslo", "324220", "4503440",
"NP", "Kathmandu", "140800", "25284463",
"NR", "Yaren", "21", "12088",
"NZ", "Wellington", "268680", "3864129",
"OM", "Muscat", "212460", "2622198",
"PA", "Panama City", "78200", "2845647",
"PE", "Lima", "1285220", "27483864",
"PG", "Port Moresby", "462840", "5049055",
"PH", "Manila", "300000", "82841518",
"PK", "Islamabad", "803940", "144616639",
"PL", "Warsaw", "312685", "38633912",
"PT", "Lisbon", "92391", "10066253",
"PW", "Koror", "458", "19092",
"PY", "Asuncin", "406750", "5734139",
"QA", "Doha", "11437", "769152",
"RO", "Bucharest", "237500", "22364022",
"RU", "Moscow", "17075200", "145470197",
"RW", "Kigali", "26338", "7312756",
"SA", "Riyadh", "1960582", "22757092",
"SB", "Honiara", "28450", "480442",
"SC", "Victoria", "455", "79715",
"SD", "Khartoum", "2505810", "36080373",
"SE", "Stockholm", "449964", "8875053",
"SG", "Singapore", "648", "4300419",
"SI", "Ljubljana", "20253", "1930132",
"SK", "Bratislava", "48845", "5414937",
"SL", "Freetown", "71740", "5426618",
"SM", "San Marino", "61", "27336",
"SN", "Dakar", "196190", "10284929",
"SO", "Mogadishu", "637657", "7488773",
"SR", "Paramaribo", "163270", "433998",
"ST", "So Tom", "1001", "165034",
"SV", "San Salvador", "21040", "6237662",
"SY", "Damascus", "185180", "16728808",
"SZ", "Mbabane", "17363", "1104343",
"TD", "N'Djamena", "1284000", "8707078",
"TG", "Lom", "56785", "5153088",
"TH", "Bangkok", "514000", "61797751",
"TJ", "Dushanbe", "143100", "6578681",
"TM", "Ashgabat", "488100", "4603244",
"TN", "Tunis", "163610", "9705102",
"TO", "Nuku'alofa", "748", "104227",
"TR", "Ankara", "780580", "66493970",
"TT", "Port-of-Spain", "5128", "1169682",
"TV", "Funafuti", "26", "10991",
"TW", "Taipei", "35980", "22370461",
"TZ", "Dar es Salaam", "945087", "36232074",
"UA", "Kyiv (Kiev)", "603700", "48760474",
"UG", "Kampala", "236040", "23985712",
"US", "Washington D.C.", "9629091", "278058881",
"UY", "Montevideo", "176220", "3360105",
"UZ", "Tashkent", "447400", "25155064",
"VA", "Vatican City", "0.44", "880",
"VC", "Kingstown", "389", "115942",
"VE", "Caracas", "912050", "23916810",
"VN", "Hanoi", "329560", "79939014",
"VU", "Vila", "14760", "192910",
"WS", "Apia", "2860", "179058",
"YE", "Sana", "527970", "18078035",
"YU", "Belgrade", "102350", "10677290",
"ZA", "Pretoria", "1219912", "43586097",
"ZM", "Lusaka", "752614", "9770199",
"ZW", "Harare", "390580", "11365366"
};

char * var_codes[] = {
"AD", "AND", "ad", "020", "EUR (ADP) (FRF)", "+376",
"AE", "ARE", "ae", "784", "AED", "+971",
"AF", "AFG", "af", "004", "AFA", "+93",
"AG", "ATG", "us,ag", "028", "XCD", "+1[268]",
"AI", "AIA", "gb,ai", "660", "XCD", "+1[264]",
"AL", "ALB", "al", "008", "ALL", "+355",
"AM", "ARM", "am", "051", "AMD", "+374",
"AN", "ANT", "nl,an", "530", "ANG", "+599",
"AO", "AGO", "ao", "024", "(AON) AOR", "+244",
"AQ", "ATA", "aq", "010", "(USD) (AUD)", "+672[(1)]",
"AR", "ARG", "ar", "032", "ARS", "+54",
"AS", "ASM", "us,as", "016", "USD", "+684",
"AT", "AUT", "at", "040", "EUR (ATS)", "+43",
"AU", "AUS", "au", "036", "AUD", "+61",
"AW", "ABW", "nl,aw", "533", "AWG", "+297",
"AZ", "AZE", "az", "031", "AZM", "+994",
"BA", "BIH", "ba", "070", "EUR (DEM)", "+387",
"BB", "BRB", "bb", "052", "BBD", "+1[246]",
"BD", "BGD", "bd", "050", "BDT", "+880",
"BE", "BEL", "be", "056", "EUR (BEF)", "+32",
"BF", "BFA", "bf", "854", "XOF", "+226",
"BG", "BGR", "bg", "100", "BGL", "+359",
"BH", "BHR", "bh", "048", "BHD", "+973",
"BI", "BDI", "bi", "108", "BIF", "+257",
"BJ", "BEN", "bj", "204", "XOF", "+229",
"BM", "BMU", "gb", "060", "BMD", "+1[441]",
"BN", "BRN", "bn", "096", "BND", "+673",
"BO", "BOL", "bo", "068", "BOB (BOV)", "+591",
"BR", "BRA", "br", "076", "BRL", "+55",
"BS", "BHS", "bs", "044", "BSD", "+1[242]",
"BT", "BTN", "bt", "064", "BTN (INR)", "+975",
"BV", "BVT", "no", "074", "NOK", "+47[(01)]",
"BW", "BWA", "bw", "072", "BWP", "+267",
"BY", "BLR", "by", "112", "BYB", "+375",
"BZ", "BLZ", "bz", "084", "BZD", "+501",
"CA", "CAN", "ca", "124", "CAD", "+1[(1)]",
"CC", "CCK", "au", "166", "AUD", "+61[(01)]",
"CD", "COD", "cd", "180", "ZRN", "+243",
"CF", "CAF", "cf", "140", "XAF", "+236",
"CG", "COG", "cg", "178", "XAF", "+242",
"CH", "CHE", "ch", "756", "CHF", "+41",
"CI", "CIV", "ci", "384", "XOF", "+225",
"CK", "COK", "nz", "184", "NZD", "+682",
"CL", "CHL", "cl", "152", "(CLF) CLP", "+56",
"CM", "CMR", "cm", "120", "XAF", "+237",
"CN", "CHN", "cn", "156", "CNY", "+86[(-)]",
"CO", "COL", "co", "170", "COP", "+57",
"CR", "CRI", "cr", "188", "CRC", "+506",
"CU", "CUB", "cu", "192", "CUP", "+53",
"CV", "CPV", "cv", "132", "CVE", "+238",
"CX", "CXR", "au,cx", "162", "AUD", "+672[(01)]",
"CY", "CYP", "cy", "196", "CYP", "+357",
"CZ", "CZE", "cz", "203", "CZK", "+420",
"DE", "DEU", "de", "276", "EUR (DEM)", "+49",
"DJ", "DJI", "dj", "262", "DJF", "+253",
"DK", "DNK", "dk", "208", "EUR (DKK)", "+45",
"DM", "DMA", "dm", "212", "XCD", "+1[767]",
"DO", "DOM", "do", "214", "DOP", "+1[809]",
"DZ", "DZA", "dz", "012", "DZD", "+213",
"EC", "ECU", "ec", "218", "ECS (ECV)", "+593",
"EE", "EST", "ee", "233", "EEK", "+372",
"EG", "EGY", "eg", "818", "EGP", "+20",
"EH", "ESH", "eh", "732", "MAD", "+212[(1)]",
"ER", "ERI", "er", "232", "", "+291",
"ES", "ESP", "es", "724", "EUR (ESP)", "+34",
"ET", "ETH", "et", "231", "ETB", "+251",
"FI", "FIN", "fi", "246", "EUR (FIM)", "+358",
"FJ", "FJI", "us,fj", "242", "FJD", "+679",
"FK", "FLK", "gb,fk", "238", "FKP (GBP) (XEU)", "+500",
"FM", "FSM", "fm", "583", "USD", "+691",
"FO", "FRO", "dk,fo", "234", "DKK (XEU)", "+298",
"FR", "FRA", "fr", "250", "EUR (FRF)", "+33[(-)]",
"FX", "FXX", "fr", "249", "EUR (FRF)", "+33[(00)]",
"GA", "GAB", "ga", "266", "XAF", "+241",
"GB", "GBR", "gb", "826", "GBP (XEU)", "+44[(00)]",
"GD", "GRD", "gd", "308", "XCD", "+1[473]",
"GE", "GEO", "ge", "268", "GEL", "+995",
"GF", "GUF", "fr", "254", "EUR (FRF)", "+594",
"GG", "GUE", "gb,gg", "-", "GGP GBP (XEU)", "+44[(02)]",
"GH", "GHA", "gh", "288", "GHC", "+233",
"GI", "GIB", "gb,gi", "292", "GIP (GBP) (XEU)", "+350",
"GL", "GRL", "dk,gl", "304", "DKK (XEU)", "+299",
"GM", "GMB", "gm", "270", "GMD", "+220",
"GN", "GIN", "gn", "324", "GNF", "+224",
"GP", "GLP", "fr,gp", "312", "EUR (FRF)", "+590",
"GQ", "GNQ", "gq", "226", "XAF", "+240",
"GR", "GRC", "gr", "300", "EUR (GRD)", "+30",
"GS", "SGS", "gb", "239", "FKP (GBP) (XEU)", "+500[(01)]",
"GT", "GTM", "gt", "320", "GTQ", "+502",
"GU", "GUM", "us,gu", "316", "USD", "+1[671]",
"GW", "GNB", "gw", "624", "GWP", "+245",
"GY", "GUY", "gy", "328", "GYD", "+592",
"HK", "HKG", "cn", "344", "HKD (CNY)", "+852",
"HM", "HMD", "au", "334", "AUD", "+61[(02)]",
"HN", "HND", "hn", "340", "HNL", "+504",
"HR", "HRV", "hr", "191", "HRK", "+385",
"HT", "HTI", "ht", "332", "HTG (USD)", "+509",
"HU", "HUN", "hu", "348", "HUF", "+36",
"ID", "IDN", "id", "360", "IDR", "+62",
"IE", "IRL", "ie", "372", "EUR (IEP)", "+353",
"IL", "ISR", "il", "376", "ILS", "+972",
"IM", "IMA", "gb,im", "", "GBP (XEU)", "+44[(01)]",
"IN", "IND", "in", "356", "INR", "+91",
"IO", "IOT", "gb", "086", "GBP", "+873[(01)] [(INMAR SAT)]",
"IQ", "IRQ", "iq", "368", "IQD", "+964",
"IR", "IRN", "ir", "364", "IRR", "+98",
"IS", "ISL", "is", "352", "ISK", "+354",
"IT", "ITA", "it", "380", "EUR (ITL)", "+39",
"JE", "JER", "gb,je", "-", "JEP GBP (XEU)", "+44[(03)]",
"JM", "JAM", "jm", "388", "JMD", "+1[876]",
"JO", "JOR", "jo", "400", "JOD", "+962",
"JP", "JPN", "jp", "392", "JPY", "+81",
"KE", "KEN", "ke", "404", "KES", "+254",
"KG", "KGZ", "kg", "417", "KGS", "+996",
"KH", "KHM", "kh", "116", "KHR", "+855",
"KI", "KIR", "ki", "296", "AUD", "+686",
"KM", "COM", "km", "174", "KMF", "+269[7]",
"KN", "KNA", "kn", "659", "XCD", "+1[869]",
"KP", "PRK", "kp", "408", "KPW", "+850",
"KR", "KOR", "kr", "410", "KRP", "+82",
"KW", "KWT", "kw", "414", "KWD", "+965",
"KY", "CYM", "gb,ky", "136", "KYD", "+1[345]",
"KZ", "KAZ", "kz", "398", "KZT", "+7[(05)] +997*",
"LA", "LAO", "la", "418", "LAK", "+856",
"LB", "LBN", "lb", "422", "LBP", "+961",
"LC", "LCA", "lc", "662", "XCD", "+1[758]",
"LI", "LIE", "li", "438", "CHF", "+423",
"LK", "LKA", "lk", "144", "LKR", "+94",
"LR", "LBR", "lr", "430", "LRD", "+231",
"LS", "LSO", "ls", "426", "LSL (SAR)", "+266",
"LT", "LTU", "lt", "440", "LTL", "+370",
"LU", "LUX", "lu", "442", "EUR (LUF) (BEF)", "+352",
"LV", "LVA", "lv", "428", "LVL", "+371",
"LY", "LBY", "ly", "434", "LYD", "+218",
"MA", "MAR", "ma", "504", "MAD", "+212",
"MC", "MCO", "mc", "492", "EUR (FRF)", "+377",
"MD", "MDA", "md", "498", "MDL", "+373",
"MG", "MDG", "mg", "450", "MGF", "+261",
"MH", "MHL", "us,mh", "584", "USD", "+692",
"MK", "MKD", "mk", "807", "MKD", "+389",
"ML", "MLI", "ml", "466", "XOF", "+223",
"MM", "MMR", "mm", "104", "MMK", "+95",
"MN", "MNG", "mn", "496", "MNT", "+976",
"MO", "MAC", "cn,mo", "446", "MOP (CNY)", "+853",
"MP", "MNP", "us", "580", "USD", "+1[670]",
"MQ", "MTQ", "fr", "474", "EUR (FRF)", "+596",
"MR", "MRT", "mr", "478", "MRO", "+222",
"MS", "MSR", "gb", "500", "GBP", "+1[664]",
"MT", "MLT", "mt", "470", "MTL", "+356",
"MU", "MUS", "mu", "480", "MUR", "+230",
"MV", "MDV", "mv", "462", "MVR", "+960",
"MW", "MWI", "mw", "454", "MWK", "+265",
"MX", "MEX", "mx", "484", "MXN (MXP*)", "+52",
"MY", "MYS", "my", "458", "MYR", "+60",
"MZ", "MOZ", "mz", "508", "MZM", "+258",
"NA", "NAM", "na", "516", "NAD (ZAR)", "+264",
"NC", "NCL", "fr,nc", "540", "XPF", "+687",
"NE", "NER", "ne", "562", "XOF", "+227",
"NF", "NFK", "au,nf", "574", "AUD", "+672[(02)]",
"NG", "NGA", "ng", "566", "NGN", "+234",
"NI", "NIC", "ni", "558", "NIO", "+505",
"NL", "NLD", "nl", "528", "EUR (NLG)", "+31",
"NO", "NOR", "no", "578", "NOK", "+47[(-)]",
"NP", "NPL", "np", "524", "NPR", "+977",
"NR", "NRU", "nr", "520", "AUD", "+674",
"NU", "NIU", "nu", "570", "NZD", "+683",
"NZ", "NZL", "nz", "554", "NZD", "+64",
"OM", "OMN", "om", "512", "OMR", "+968",
"PA", "PAN", "pa", "591", "PAB (USD)", "+507",
"PC", "PAR", "cn", "", "CNY", "+86[(01)]",
"PE", "PER", "pe", "604", "PEN (PES)", "+51",
"PF", "PYF", "fr,pf", "258", "XPF (FRF) (XEU)", "+689",
"PG", "PNG", "pg", "598", "PGK", "+675",
"PH", "PHL", "ph", "608", "PHP", "+63",
"PK", "PAK", "pk", "586", "PKR", "+92",
"PL", "POL", "pl", "616", "PLN (PLZ)", "+48",
"PM", "SPM", "fr", "666", "EUR FRF", "+508",
"PN", "PCN", "nz,pn", "612", "NZD", "+64[(1)]",
"PR", "PRI", "us", "630", "USD", "+1[787] +1[939]*",
"PS", "PSE", "ps", "275", "ILS (JOD)", "+970",
"PT", "PRT", "pt", "620", "EUR (PTE)", "+351",
"PW", "PLW", "pw", "585", "USD", "+680",
"PY", "PRY", "py", "600", "PYG", "+595",
"QA", "QAT", "qa", "634", "QAR", "+974",
"RE", "REU", "fr,re", "638", "EUR (FRF)", "+33[262]* +262",
"RO", "ROM", "ro", "642", "ROL", "+40",
"RU", "RUS", "ru", "643", "RUR", "+7[(-)]",
"RW", "RWA", "rw", "646", "RWF", "+250",
"SA", "SAU", "sa", "682", "SAR", "+966",
"SB", "SLB", "sb", "090", "SBD", "+677",
"SC", "SYC", "sc", "690", "SCR", "+248",
"SD", "SDN", "sd", "736", "SDD", "+249",
"SE", "SWE", "se", "752", "EUR (SEK)", "+46",
"SG", "SGP", "sg", "702", "SGD", "+65",
"SH", "SHN", "gb,sh", "654", "SHP", "+290",
"SI", "SVN", "si", "705", "SIT", "+386",
"SJ", "SJM", "no", "744", "NOK", "+47[(1)]",
"SK", "SVK", "sk", "703", "SKK", "+421",
"SL", "SLE", "sl", "694", "SLL", "+232",
"SM", "SMR", "sm", "674", "EUR (ITL)", "+378",
"SN", "SEN", "sn", "686", "XOF", "+221",
"SO", "SOM", "so", "706", "SOS", "+252",
"SR", "SUR", "sr", "740", "SRG", "+597",
"ST", "STP", "st", "678", "STD", "+239",
"SV", "SLV", "sv", "222", "SVC", "+503",
"SY", "SYR", "sy", "760", "SYP", "+963",
"SZ", "SWZ", "sz", "748", "SZL", "+268",
"TC", "TCA", "gb,tc", "796", "USD", "+1[649]",
"TD", "TCD", "td", "148", "XAF", "+235",
"TF", "ATF", "fr,aq", "260", "EUR (FRF)", "+61[(2)]",
"TG", "TGO", "tg", "768", "XOF", "+228",
"TH", "THA", "th", "764", "THB", "+66",
"TJ", "TJK", "tj", "762", "TJR", "+992",
"TK", "TKL", "nz,tk", "772", "NZD", "+690",
"TM", "TKM", "tm", "795", "TMM", "+993",
"TN", "TUN", "tn", "788", "TND", "+21[6]",
"TO", "TON", "to", "776", "TOP", "+676",
"TP", "TMP", "tp", "626", "IDR (TPE)", "+670",
"TR", "TUR", "tr", "792", "TRL", "+90",
"TT", "TTO", "tt", "780", "TTD", "+1[868]",
"TV", "TUV", "tv", "798", "AUD", "+688",
"TW", "TWN", "tw", "158", "TWD", "+886 +86[6]*",
"TZ", "TZA", "tz", "834", "TZS", "+255 +259*",
"UA", "UKR", "ua", "804", "UAH UAK", "+380",
"UG", "UGA", "ug", "800", "UGX", "+256",
"UM", "UMI", "us", "581", "USD", "+1[(19)]",
"US", "USA", "us", "840", "USD", "+1[(-)]",
"UY", "URY", "uy", "858", "UYU", "+598",
"UZ", "UZB", "uz", "860", "UZS", "+998",
"VA", "VAT", "it,va", "336", "EUR (ITL)", "+379",
"VC", "VCT", "vc", "670", "XCD", "+1[784]",
"VE", "VEN", "ve", "862", "VEB", "+58",
"VG", "VGB", "gb,vg", "092", "USD", "+1[284]",
"VI", "VIR", "us,vi", "850", "USD", "+1[340]",
"VN", "VNM", "vn", "704", "VND", "+84",
"VU", "VUT", "vu", "548", "VUV", "+678",
"WF", "WLF", "fr,wf", "876", "XPF", "+681",
"WS", "WSM", "ws", "882", "WST", "+685",
"YE", "YEM", "ye", "887", "YER", "+967",
"YT", "MYT", "fr", "175", "EUR (FRF)", "+269[(-)]",
"YU", "YUG", "yu", "891", "YUM", "+381",
"ZA", "ZAF", "za", "710", "ZAR (ZAL)", "+27",
"ZM", "ZMB", "zm", "894", "ZMK", "+260",
"ZW", "ZWE", "zw", "716", "ZWD", "+263"
};

char *cia_codes[] = {
"aw", "aa",
"ag", "ac",
"af", "af",
"dz", "ag",
"az", "aj",
"al", "al",
"am", "am",
"ad", "an",
"ao", "ao",
"as", "aq",
"ar", "ar",
"au", "as",
"at", "au",
"ai", "av",
"aq", "ay",
"bh", "ba",
"bb", "bb",
"bw", "bc",
"bm", "bd",
"be", "be",
"bs", "bf",
"bd", "bg",
"bz", "bh",
"ba", "bk",
"bo", "bl",
"mm", "bm",
"bj", "bn",
"by", "bo",
"sb", "bp",
"br", "br",
"in", "bs",
"bt", "bt",
"bg", "bu",
"bv", "bv",
"bn", "bx",
"bi", "by",
"ca", "ca",
"kh", "cb",
"td", "cd",
"lk", "ce",
"cg", "cf",
"cd", "cg",
"cn", "ch",
"cl", "ci",
"ky", "cj",
"cc", "ck",
"cm", "cm",
"km", "cn",
"co", "co",
"mp", "cq",
"cr", "cs",
"cf", "ct",
"cu", "cu",
"cv", "cv",
"ck", "cw",
"cy", "cy",
"dk", "da",
"dj", "dj",
"dm", "do",
"do", "dr",
"ec", "ec",
"eg", "eg",
"ie", "ei",
"gq", "ek",
"ee", "en",
"er", "er",
"sv", "es",
"et", "et",
"cz", "ez",
"gf", "fg",
"fi", "fi",
"fj", "fj",
"fk", "fk",
"fm", "fm",
"fo", "fo",
"pf", "fp",
"fr", "fr",
"tf", "fs",
"gm", "ga",
"ga", "gb",
"ge", "gg",
"gh", "gh",
"gi", "gi",
"gd", "gj",
"gg", "gk",
"gl", "gl",
"de", "gm",
"gp", "gp",
"gu", "gq",
"gr", "gr",
"gt", "gt",
"gn", "gv",
"gy", "gy",
"ht", "ha",
"hk", "hk",
"hm", "hm",
"hn", "ho",
"hr", "hr",
"hu", "hu",
"is", "ic",
"id", "id",
"im", "im",
"in", "in",
"io", "io",
"ir", "ir",
"il", "is",
"it", "it",
"ci", "iv",
"iq", "iz",
"jp", "ja",
"je", "je",
"jm", "jm",
"jo", "jo",
"ke", "ke",
"kg", "kg",
"kp", "kn",
"ki", "kr",
"kr", "ks",
"cx", "kt",
"kw", "ku",
"kz", "kz",
"la", "la",
"lb", "le",
"lv", "lg",
"lt", "lh",
"lr", "li",
"sk", "lo",
"li", "ls",
"ls", "lt",
"lu", "lu",
"ly", "ly",
"mg", "ma",
"mq", "mb",
"mo", "mc",
"md", "md",
"yt", "mf",
"mn", "mg",
"ms", "mh",
"mw", "mi",
"mk", "mk",
"ml", "ml",
"mc", "mn",
"ma", "mo",
"mu", "mp",
"mr", "mr",
"mt", "mt",
"om", "mu",
"mv", "mv",
"mx", "mx",
"my", "my",
"mz", "mz",
"nc", "nc",
"nu", "ne",
"nf", "nf",
"ne", "ng",
"vu", "nh",
"ng", "ni",
"nl", "nl",
"no", "no",
"np", "np",
"nr", "nr",
"sr", "ns",
"an", "nt",
"ni", "nu",
"nz", "nz",
"py", "pa",
"pn", "pc",
"pe", "pe",
"pk", "pk",
"pl", "pl",
"pa", "pm",
"pt", "po",
"pg", "pp",
"pw", "ps",
"gw", "pu",
"qa", "qa",
"re", "re",
"mh", "rm",
"ro", "ro",
"ph", "rp",
"pr", "rq",
"ru", "rs",
"rw", "rw",
"sa", "sa",
"pm", "sb",
"kn", "sc",
"sc", "se",
"za", "sf",
"sn", "sg",
"sh", "sh",
"si", "si",
"sl", "sl",
"sm", "sm",
"sg", "sn",
"so", "so",
"es", "sp",
"lc", "st",
"sd", "su",
"sj", "sv",
"se", "sw",
"gs", "sx",
"sy", "sy",
"ch", "sz",
"ae", "tc",
"tt", "td",
"th", "th",
"tj", "ti",
"tc", "tk",
"tk", "tl",
"to", "tn",
"tg", "to",
"st", "tp",
"tn", "ts",
"tp", "tt",
"tr", "tu",
"tv", "tv",
"tw", "tw",
"tm", "tx",
"tz", "tz",
"ug", "ug",
"gb", "uk",
"ua", "up",
"us", "us",
"bf", "uv",
"uy", "uy",
"uz", "uz",
"vc", "vc",
"ve", "ve",
"vg", "vi",
"vn", "vm",
"vi", "vq",
"va", "vt",
"na", "wa",
"wf", "wf",
"eh", "wi",
"ws", "ws",
"sz", "wz",
"yu", "yi",
"ye", "ym",
"zm", "za",
"zw", "zi",
"Ashmore_and_Cartier_Islands", "at",
"Navassa_Island", "bq",
"Coral_Sea_Islands", "cr",
"Jarvis_Island", "dq",
"Europa_Island", "eu",
"Baker_Island", "fq",
"Glorioso_Islands", "go",
"Gaza_Strip", "gz",
"Howland_Island", "hq",
"Clipperton_Island", "ip",
"Jan_Mayen", "jn",
"Johnston_Atoll", "jq",
"Juan_de_Nova_Island", "ju",
"Kingman_Reef", "kq",
"Palmyra_Atoll", "lq",
"Midway_Islands", "mq",
"Tromelin_Island", "te",
"West_Bank", "we",
"Wake_Island", "wq",
"World", "xx"
};

char *pdf_maps[] = {
"afghanis", "af",
"africa", "africa",
"albania", "al",
"angola", "ao",
"armenia", "am",
"azerbaij", "az",
"bahrain", "bh",
"banglade", "bd",
"belarus", "by",
"bolivia", "bo",
"bosnia", "ba",
"burundi", "bi",
"cambodia", "kh",
"car", "cf",
"chad", "td",
"comoros", "km",
"congo", "cg",
"croatia", "hr",
"cyprus", "cy",
"czech", "cz",
"drcongo", "cd",
"ece", "europe",
"eclac", "south_america",
"ecuador", "ec",
"egypt", "eg",
"elsalvad", "sv",
"eqguinea", "gq",
"escap", "asia",
"escwa", "middle_east",
"estonia", "ee",
"gabon", "ga",
"georgia", "ge",
"greece", "gr",
"guatemal", "gt",
"guineabi", "gw",
"haiti", "ht",
"honduras", "hn",
"indonesi", "id",
"iran", "ir",
"iraq", "iq",
"israel", "il",
"kazakhst", "kz",
"korean", "kp",
"kuwait", "kw",
"kyrgysta", "kg",
"laos", "la",
"latvia", "lv",
"liberia", "lr",
"libya", "ly",
"lithuani", "lt",
"macedoni", "mk",
"malawi", "mw",
"moldova", "md",
"mongolia", "mn",
"morocco", "ma",
"mozambiq", "mz",
"myanmar", "mm",
"nicaragu", "ni",
"oman", "om",
"papua", "pg",
"paraguay", "py",
"peru", "pe",
"poland", "pl",
"qatar", "qa",
"romania", "ro",
"russia", "ru",
"rwanda", "rw",
"sierrale", "sl",
"slovakia", "sk",
"slovenia", "si",
"somalia", "so",
"southafr", "za",
"srilanka", "lk",
"sudan", "sd",
"tajikist", "tj",
"tanzania", "tz",
"thailand", "th",
"timor", "tp",
"turkmeni", "tm",
"uganda", "ug",
"ukraine", "ua",
"ungegn", "ungegn",
"uzbekist", "uz",
"wsahara", "eh",
"yemen", "ye",
"yugoslav", "yu",
"zambia", "zm"
};

