/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/************************************************************************
*									*
*   zb.h								*
*									*
************************************************************************/
/*
**  client zero buffer destinations
*/
#define ZD_NONE		0
#define ZD_SERV		1
#define ZD_SERV_ASYNC	2
#define ZD_ALLBUTONE	3
#define ZD_KETCHUP	4
#define ZD_QSERV	5
#define ZD_ALLSERV	6
#define ZD_FLOOR	7
#define ZD_SEAT		8
#define ZD_VIEW		9

typedef struct _zb_t {
   u16_t		zseqno;	/* client zero's last sequence number */
   buffer_t *		bp;
   buffer_t *		rbp;
}zb_t;

extern zb_t zb;

#define zb_fbuf()	zb.bp
#define zb_rbuf()	zb.rbp
#define zb_seqno()	zb.zseqno
#define zb_incr_seqno()	zb.zseqno++
#define zb_mon(n)\
	if (buf_active(zb.bp) + (n) > MAXCHUNKSIZE)\
		zb_queue(0)
#define zb_queue_all(){\
	if (buf_active(zb.bp))\
		zb_queue(0);\
	if (buf_active(zb.rbp))\
		zb_client_queue();\
}
/*
**  for when you want to dispatch by hand
**
**	Note, cast here works around absence of buf.pub.h include in
**	files that use this macro and no other buf routines.
*/
#define zb_split()	(chunk_t *)buf_split(zb.bp, 0)
