/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/************************************************************************
*									*
*   swap.c								*
*									*
************************************************************************/
#define NEED_REPLIES
#define NEED_EVENTS
#include <X11/Xproto.h>
#include <X11/X.h>
#include "xmx.h"
#include "ptc.h"
#include "incl/swap.pvt.h"

void
swap_coloritems
   AL((p, n))
   DB xColorItem *p
   DD int n
   DE
{
   register int i;

   for (i=0; i<n; i++) {
      SWAP4(p[i].pixel);
      SWAP2(p[i].red);
      SWAP2(p[i].green);
      SWAP2(p[i].blue);
   }
}

void
swap_charinfos
   AL((p, n))
   DB xCharInfo *p
   DD int n
   DE
{
   register int i;

   for (i=0; i<n; i++) {
      SWAP2(p->leftSideBearing);
      SWAP2(p->rightSideBearing);
      SWAP2(p->characterWidth);
      SWAP2(p->ascent);
      SWAP2(p->descent);
      SWAP2(p->attributes);
      p++;
   }
}

void
swap_ConnClientPrefix
   AL((p))
   DB xConnClientPrefix *p
   DE
{
   SWAP2(p->majorVersion);
   SWAP2(p->minorVersion);
   SWAP2(p->nbytesAuthProto);
   SWAP2(p->nbytesAuthString);
}

void
swap_ConnSetupPrefix
   AL((p))
   DB xConnSetupPrefix *p
   DE
{
   SWAP2(p->majorVersion);
   SWAP2(p->minorVersion);
   SWAP2(p->length);
}

void
swap_error
   AL((p))
   DB xError *p
   DE
{
   if (p->errorCode < FirstExtensionError) {
      SWAP2(p->sequenceNumber);
      SWAP4(p->resourceID);
      SWAP2(p->minorCode);
   }
   else
      ext_error_swap(p);
}

void
swap_event
   AL((p))
   DB xEvent *p
   DE
{
   SWAP2(p->u.u.sequenceNumber);

   switch (p->u.u.type & 0x7f) {
      case KeyPress:
      case KeyRelease:
      case ButtonPress:
      case ButtonRelease:
      case MotionNotify:
         SWAP4(p->u.keyButtonPointer.time);
         SWAP4(p->u.keyButtonPointer.root);
         SWAP4(p->u.keyButtonPointer.event);
         SWAP4(p->u.keyButtonPointer.child);
         SWAP2(p->u.keyButtonPointer.rootX);
         SWAP2(p->u.keyButtonPointer.rootY);
         SWAP2(p->u.keyButtonPointer.eventX);
         SWAP2(p->u.keyButtonPointer.eventY);
         SWAP2(p->u.keyButtonPointer.state);
         break;
      case EnterNotify:
      case LeaveNotify:
         SWAP4(p->u.enterLeave.time);
         SWAP4(p->u.enterLeave.root);
         SWAP4(p->u.enterLeave.event);
         SWAP4(p->u.enterLeave.child);
         SWAP4(p->u.enterLeave.rootX);
         SWAP4(p->u.enterLeave.rootY);
         SWAP4(p->u.enterLeave.eventX);
         SWAP4(p->u.enterLeave.eventY);
         SWAP4(p->u.enterLeave.state);
         break;
      case FocusIn:
      case FocusOut:
         SWAP4(p->u.focus.window);
         break;
      case KeymapNotify:
         break;
      case Expose:
         SWAP4(p->u.expose.window);
         SWAP2(p->u.expose.x);
         SWAP2(p->u.expose.y);
         SWAP2(p->u.expose.width);
         SWAP2(p->u.expose.height);
         SWAP2(p->u.expose.count);
         break;
      case GraphicsExpose:
         SWAP4(p->u.graphicsExposure.drawable);
         SWAP2(p->u.graphicsExposure.x);
         SWAP2(p->u.graphicsExposure.y);
         SWAP2(p->u.graphicsExposure.width);
         SWAP2(p->u.graphicsExposure.height);
         SWAP2(p->u.graphicsExposure.minorEvent);
         SWAP2(p->u.graphicsExposure.count);
         break;
      case NoExpose:
         SWAP4(p->u.noExposure.drawable);
         SWAP2(p->u.noExposure.minorEvent);
         break;
      case VisibilityNotify:
         SWAP4(p->u.visibility.window);
         break;
      case CreateNotify:
         SWAP4(p->u.createNotify.parent);
         SWAP4(p->u.createNotify.window);
         SWAP2(p->u.createNotify.x);
         SWAP2(p->u.createNotify.y);
         SWAP2(p->u.createNotify.width);
         SWAP2(p->u.createNotify.height);
         SWAP2(p->u.createNotify.borderWidth);
         break;
      case DestroyNotify:
         SWAP4(p->u.destroyNotify.event);
         SWAP4(p->u.destroyNotify.window);
         break;
      case UnmapNotify:
         SWAP4(p->u.unmapNotify.event);
         SWAP4(p->u.unmapNotify.window);
         break;
      case MapNotify:
         SWAP4(p->u.mapNotify.event);
         SWAP4(p->u.mapNotify.window);
         break;
      case MapRequest:
         SWAP4(p->u.mapRequest.parent);
         SWAP4(p->u.mapRequest.window);
         break;
      case ReparentNotify:
         SWAP4(p->u.reparent.event);
         SWAP4(p->u.reparent.window);
         SWAP4(p->u.reparent.parent);
         SWAP2(p->u.reparent.x);
         SWAP2(p->u.reparent.y);
         break;
      case ConfigureNotify:
         SWAP4(p->u.configureNotify.event);
         SWAP4(p->u.configureNotify.window);
         SWAP4(p->u.configureNotify.aboveSibling);
         SWAP2(p->u.configureNotify.x);
         SWAP2(p->u.configureNotify.y);
         SWAP2(p->u.configureNotify.width);
         SWAP2(p->u.configureNotify.height);
         SWAP2(p->u.configureNotify.borderWidth);
         break;
      case ConfigureRequest:
         SWAP4(p->u.configureRequest.parent);
         SWAP4(p->u.configureRequest.window);
         SWAP4(p->u.configureRequest.sibling);
         SWAP2(p->u.configureRequest.x);
         SWAP2(p->u.configureRequest.y);
         SWAP2(p->u.configureRequest.width);
         SWAP2(p->u.configureRequest.height);
         SWAP2(p->u.configureRequest.borderWidth);
         SWAP2(p->u.configureRequest.valueMask);
         break;
      case GravityNotify:
         SWAP4(p->u.gravity.event);
         SWAP4(p->u.gravity.window);
         SWAP2(p->u.gravity.x);
         SWAP2(p->u.gravity.y);
         break;
      case ResizeRequest:
         SWAP4(p->u.resizeRequest.window);
         SWAP2(p->u.resizeRequest.width);
         SWAP2(p->u.resizeRequest.height);
         break;
      case CirculateNotify:
      case CirculateRequest:
         SWAP4(p->u.circulate.event);
         SWAP4(p->u.circulate.window);
         SWAP4(p->u.circulate.parent);
         break;
      case PropertyNotify:
         SWAP4(p->u.property.window);
         SWAP4(p->u.property.atom);
         SWAP4(p->u.property.time);
         break;
      case SelectionClear:
         SWAP4(p->u.selectionClear.time);
         SWAP4(p->u.selectionClear.window);
         SWAP4(p->u.selectionClear.atom);
         break;
      case SelectionRequest:
         SWAP4(p->u.selectionRequest.time);
         SWAP4(p->u.selectionRequest.owner);
         SWAP4(p->u.selectionRequest.requestor);
         SWAP4(p->u.selectionRequest.selection);
         SWAP4(p->u.selectionRequest.target);
         SWAP4(p->u.selectionRequest.property);
         break;
      case SelectionNotify:
         SWAP4(p->u.selectionNotify.time);
         SWAP4(p->u.selectionNotify.requestor);
         SWAP4(p->u.selectionNotify.selection);
         SWAP4(p->u.selectionNotify.target);
         SWAP4(p->u.selectionNotify.property);
         break;
      case ColormapNotify:
         SWAP4(p->u.colormap.window);
         SWAP4(p->u.colormap.colormap);
         break;
      case ClientMessage:
         SWAP4(p->u.clientMessage.window);
         switch (p->u.u.detail) {
            case 8:
               SWAP4(p->u.clientMessage.u.b.type);
               break;
            case 16:
               SWAP4(p->u.clientMessage.u.s.type);
               SWAP2(p->u.clientMessage.u.s.shorts0);
               SWAP2(p->u.clientMessage.u.s.shorts1);
               SWAP2(p->u.clientMessage.u.s.shorts2);
               SWAP2(p->u.clientMessage.u.s.shorts3);
               SWAP2(p->u.clientMessage.u.s.shorts4);
               SWAP2(p->u.clientMessage.u.s.shorts5);
               SWAP2(p->u.clientMessage.u.s.shorts6);
               SWAP2(p->u.clientMessage.u.s.shorts7);
               SWAP2(p->u.clientMessage.u.s.shorts8);
               SWAP2(p->u.clientMessage.u.s.shorts9);
               break;
            case 32:
               SWAP4(p->u.clientMessage.u.l.type);
               SWAP4(p->u.clientMessage.u.l.longs0);
               SWAP4(p->u.clientMessage.u.l.longs1);
               SWAP4(p->u.clientMessage.u.l.longs2);
               SWAP4(p->u.clientMessage.u.l.longs3);
               SWAP4(p->u.clientMessage.u.l.longs4);
               break;
         }
         break;
      case MappingNotify:
         break;
      default:
         ext_event_swap(p);
         break;
   }
}

void
swap_connsetup
   AL((cp))
   DB char *cp
   DE
{
   register xConnSetupPrefix *pp;
   register xConnSetup *sp;
   register xWindowRoot *rp;
   register xDepth *dp;
   register xVisualType *vp;

   pp = cblock_prefix(cp);
   SWAP2(pp->majorVersion);
   SWAP2(pp->minorVersion);
   SWAP2(pp->length);

   if (pp->success) {
      sp = cblock_setup(cp);
      while (rp = cblock_root(0)) {
         while (dp = cblock_depth(0)) {
            while (vp = cblock_visual(0)) {
               SWAP4(vp->visualID);
               SWAP2(vp->colormapEntries);
               SWAP4(vp->redMask);
               SWAP4(vp->greenMask);
               SWAP4(vp->blueMask);
            }
            SWAP2(dp->nVisuals);
         }
         SWAP4(rp->windowId);
         SWAP4(rp->defaultColormap);
         SWAP4(rp->whitePixel);
         SWAP4(rp->blackPixel);
         SWAP4(rp->currentInputMask);
         SWAP2(rp->pixWidth);
         SWAP2(rp->pixHeight);
         SWAP2(rp->mmWidth);
         SWAP2(rp->mmHeight);
         SWAP2(rp->minInstalledMaps);
         SWAP2(rp->maxInstalledMaps);
         SWAP4(rp->rootVisualID);
      }
      SWAP4(sp->release);
      SWAP4(sp->ridBase);
      SWAP4(sp->ridMask);
      SWAP4(sp->motionBufferSize);
      SWAP2(sp->nbytesVendor);
      SWAP2(sp->maxRequestSize);
   }
}

/************************************************************************
*									*
*   swap_reply								*
*									*
************************************************************************/
void
swap_reply
   AL((rp, major, minor))
   DB xGenericReply *rp
   DD int major
   DD u16_t minor
   DE
{
   register int i;
   register u16_t *sp;
   register u32_t *lp;
   register xTimecoord *tp;
   register xHostEntry *hp;

   DEBUG1(D_SWAP, "swap_reply: %s\n", dprx_reqType_str(major));
   switch (major) {
      case X_GetWindowAttributes:
         {  xGetWindowAttributesReply *p = (xGetWindowAttributesReply *)rp;
            SWAP4(p->visualID);
            SWAP2(p->class);
            SWAP4(p->backingBitPlanes);
            SWAP4(p->backingPixel);
            SWAP4(p->colormap);
            SWAP4(p->allEventMasks);
            SWAP4(p->yourEventMask);
            SWAP2(p->doNotPropagateMask);
         }
         break;
      case X_GetGeometry:
         {  xGetGeometryReply *p = (xGetGeometryReply *)rp;
            SWAP4(p->root);
            SWAP2(p->x);
            SWAP2(p->y);
            SWAP2(p->width);
            SWAP2(p->height);
            SWAP2(p->borderWidth);
         }
         break;
      case X_QueryTree:
         {  xQueryTreeReply *p = (xQueryTreeReply *)rp;
            SWAP4(p->root);
            SWAP4(p->parent);
            lp = (u32_t *)(p + 1);
            for (i=0; i<(int)p->nChildren; i++)
               SWAP4(lp[i]);
            SWAP2(p->nChildren);
         }
         break;
      case X_InternAtom:
         {  xInternAtomReply *p = (xInternAtomReply *)rp;
            SWAP4(p->atom);
         }
         break;
      case X_GetAtomName:
         {  xGetAtomNameReply *p = (xGetAtomNameReply *)rp;
            SWAP2(p->nameLength);
         }
         break;
      case X_GetProperty:
         {  xGetPropertyReply *p = (xGetPropertyReply *)rp;
            SWAP4(p->propertyType);
            SWAP4(p->bytesAfter);
            switch (p->format) {
               case 16:
                  sp = (u16_t *)(p + 1);
                  for (i=0; i<(int)p->nItems; i++)
                     SWAP2(sp[i]);
                  break;
               case 32:
                  lp = (u32_t *)(p + 1);
                  for (i=0; i<(int)p->nItems; i++)
                     SWAP4(lp[i]);
                  break;
            }
            SWAP4(p->nItems);
         }
         break;
      case X_ListProperties:
         {  xListPropertiesReply *p = (xListPropertiesReply *)rp;
            lp = (u32_t *)(p + 1);
            for (i=0; i<(int)p->nProperties; i++)
               SWAP4(lp[i]);
            SWAP2(p->nProperties);
         }
         break;
      case X_GetSelectionOwner:
         {  xGetSelectionOwnerReply *p = (xGetSelectionOwnerReply *)rp;
            SWAP4(p->owner);
         }
         break;
      case X_GrabPointer:
      case X_GrabKeyboard:
         break;
      case X_QueryPointer:
         {  xQueryPointerReply *p = (xQueryPointerReply *)rp;
            SWAP4(p->root);
            SWAP4(p->child);
            SWAP2(p->rootX);
            SWAP2(p->rootY);
            SWAP2(p->winX);
            SWAP2(p->winY);
            SWAP2(p->mask);
         }
         break;
      case X_GetMotionEvents:
         {  xGetMotionEventsReply *p = (xGetMotionEventsReply *)rp;
            tp = (xTimecoord *)(p + 1);
            for (i=0; i<(int)p->nEvents; i++) {
               SWAP4(tp[i].time);
               SWAP2(tp[i].x);
               SWAP2(tp[i].y);
            }
            SWAP4(p->nEvents);
         }
         break;
      case X_TranslateCoords:
         {  xTranslateCoordsReply *p = (xTranslateCoordsReply *)rp;
            SWAP4(p->child);
            SWAP2(p->dstX);
            SWAP2(p->dstY);
         }
         break;
      case X_GetInputFocus:
         {  xGetInputFocusReply *p = (xGetInputFocusReply *)rp;
            SWAP4(p->focus);
         }
         break;
      case X_QueryKeymap:
         break;
      case X_QueryFont:
         {  xQueryFontReply *p = (xQueryFontReply *)rp;
            (void) swap_charinfos((xCharInfo *)&p->minBounds, 1);
            (void) swap_charinfos((xCharInfo *)&p->maxBounds, 1);
            SWAP2(p->minCharOrByte2);
            SWAP2(p->maxCharOrByte2);
            SWAP2(p->defaultChar);
            SWAP2(p->fontAscent);
            SWAP2(p->fontDescent);	/* do an "nmore" here (TODO) */
            lp = (u32_t *)(p + 1);
            for (i=0; i<(int)p->nFontProps * 2; i++)
               SWAP4(lp[i]);
            (void) swap_charinfos((xCharInfo *)((xFontProp *)(p+1) +
						p->nFontProps), p->nCharInfos);
            SWAP2(p->nFontProps);
            SWAP4(p->nCharInfos);
         }
         break;
      case X_ListFontsWithInfo:		/* happens to match xQueryFontReply */
         {  xQueryFontReply *p = (xQueryFontReply *)rp;
            if (p->pad1 == 0)	/* last in series */
               break;
            (void) swap_charinfos((xCharInfo *)&p->minBounds, 1);
            (void) swap_charinfos((xCharInfo *)&p->maxBounds, 1);
/*
            (void) swap_charinfos((char *)&p->minBounds, sz_xCharInfo);
            (void) swap_charinfos((char *)&p->maxBounds, sz_xCharInfo);
*/
            SWAP2(p->minCharOrByte2);
            SWAP2(p->maxCharOrByte2);
            SWAP2(p->defaultChar);
            SWAP2(p->fontAscent);
            SWAP2(p->fontDescent);	/* do an "nmore" here (TODO) */
            lp = (u32_t *)((char *)(p + 1) + (int)p->pad1 + (int)PAD(p->pad1));
            for (i=0; i<(int)p->nFontProps * 2; i++)
               SWAP4(lp[i]);
            (void) swap_charinfos((xCharInfo *)lp+p->nFontProps,p->nCharInfos);
/*
            (void) swap_charinfos((char *)lp + (p->nFontProps * 8),
						p->nCharInfos * sz_xCharInfo);
*/
            SWAP2(p->nFontProps);
            SWAP2(p->nCharInfos);
         }
         break;
      case X_QueryTextExtents:
         {  xQueryTextExtentsReply *p = (xQueryTextExtentsReply *)rp;
            SWAP2(p->fontAscent);
            SWAP2(p->fontDescent);
            SWAP2(p->overallAscent);
            SWAP2(p->overallDescent);
            SWAP4(p->overallWidth);
            SWAP4(p->overallLeft);
            SWAP4(p->overallRight);
         }
         break;
      case X_ListFonts:
         {  xListFontsReply *p = (xListFontsReply *)rp;
            SWAP2(p->nFonts);
         }
         break;
      case X_GetFontPath:
         {  xGetFontPathReply *p = (xGetFontPathReply *)rp;
            SWAP2(p->nPaths);
         }
         break;
      case X_GetImage:
         {  xGetImageReply *p = (xGetImageReply *)rp;
            SWAP4(p->visual);
         }
         break;
      case X_ListInstalledColormaps:
         {  xListInstalledColormapsReply *p=(xListInstalledColormapsReply *)rp;
            lp = (u32_t *)(p + 1);
            for (i=0; i<(int)p->nColormaps; i++)
               SWAP4(lp[i]);
            SWAP2(p->nColormaps);
         }
         break;
      case X_AllocColor:
         {  xAllocColorReply *p = (xAllocColorReply *)rp;
            SWAP2(p->red);
            SWAP2(p->green);
            SWAP2(p->blue);
            SWAP4(p->pixel);
         }
         break;
      case X_AllocNamedColor:
         {  xAllocNamedColorReply *p = (xAllocNamedColorReply *)rp;
            SWAP4(p->pixel);
            SWAP2(p->exactRed);
            SWAP2(p->exactGreen);
            SWAP2(p->exactBlue);
            SWAP2(p->screenRed);
            SWAP2(p->screenGreen);
            SWAP2(p->screenBlue);
         }
         break;
      case X_AllocColorCells:
         {  xAllocColorCellsReply *p = (xAllocColorCellsReply *)rp;
            lp = (u32_t *)(p + 1);
            for (i=0; i<(int)(p->nPixels + p->nMasks); i++)
               SWAP4(lp[i]);
            SWAP2(p->nPixels);
            SWAP2(p->nMasks);
         }
         break;
      case X_AllocColorPlanes:
         {  xAllocColorPlanesReply *p = (xAllocColorPlanesReply *)rp;
            lp = (u32_t *)(p + 1);
            for (i=0; i<(int)p->nPixels; i++)
               SWAP4(lp[i]);
            SWAP2(p->nPixels);
            SWAP4(p->redMask);
            SWAP4(p->greenMask);
            SWAP4(p->blueMask);
         }
         break;
      case X_QueryColors:
         {  xQueryColorsReply *p = (xQueryColorsReply *)rp;
            sp = (u16_t *)(p + 1);
            for (i=0; i<(int)(p->nColors*4); i+=4) {
               SWAP2(sp[i]);	/* red */
               SWAP2(sp[i+1]);	/* green */
               SWAP2(sp[i+2]);	/* blue */
            }
            SWAP2(p->nColors);
         }
         break;
      case X_LookupColor:
         {  xLookupColorReply *p = (xLookupColorReply *)rp;
            SWAP2(p->exactRed);
            SWAP2(p->exactGreen);
            SWAP2(p->exactBlue);
            SWAP2(p->screenRed);
            SWAP2(p->screenGreen);
            SWAP2(p->screenBlue);
         }
         break;
      case X_QueryBestSize:
         {  xQueryBestSizeReply *p = (xQueryBestSizeReply *)rp;
            SWAP2(p->width);
            SWAP2(p->height);
         }
         break;
      case X_QueryExtension:
      case X_ListExtensions:
         break;
      case X_GetKeyboardMapping:
         {  xGetKeyboardMappingReply *p = (xGetKeyboardMappingReply *)rp;
            lp = (u32_t *)(p + 1);
            for (i=0; i<(int)p->length; i++)
               SWAP4(lp[i]);
         }
         break;
      case X_GetKeyboardControl:
         {  xGetKeyboardControlReply *p = (xGetKeyboardControlReply *)rp;
            SWAP4(p->ledMask);
            SWAP2(p->bellPitch);
            SWAP2(p->bellDuration);
         }
         break;
      case X_GetPointerControl:
         {  xGetPointerControlReply *p = (xGetPointerControlReply *)rp;
            SWAP2(p->accelNumerator);
            SWAP2(p->accelDenominator);
            SWAP2(p->threshold);
         }
         break;
      case X_GetScreenSaver:
         {  xGetScreenSaverReply *p = (xGetScreenSaverReply *)rp;
            SWAP2(p->timeout);
            SWAP2(p->interval);
         }
         break;
      case X_ListHosts:
         {  xListHostsReply *p = (xListHostsReply *)rp;
            hp = (xHostEntry *)(p + 1);
            for (i=0; i<(int)p->nHosts; i++)
               SWAP2(hp[i].length);
            SWAP2(p->nHosts);
         }
         break;
      case X_SetPointerMapping:
      case X_GetPointerMapping:
      case X_SetModifierMapping:
      case X_GetModifierMapping:
         break;
      default:
         ext_reply_swap(rp, major);
         break;
   }
   SWAP2(rp->sequenceNumber);
   SWAP4(rp->length);
}
