/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/************************************************************************
*									*
*   sm.h								*
*									*
************************************************************************/
#define SM_BLKSZ	256
#define SM_MAXCOUNT	255		/* 2 ^ (sizeof(u8_t) * 8) - 1 */
/*
**	sequence number map types
*/
typedef struct {
   u8_t			clinum;		/* client which originated request */
   u8_t			count;		/* consecutive req's from a client */
   u16_t		cseqno;		/* (base) client sequence number */
}sm_entry_t;

typedef struct _sm_blk_t {
   sm_entry_t		e[SM_BLKSZ];
   struct _sm_blk_t *	next;
}sm_blk_t;

typedef struct _sm_t {
   uint_t		hix;		/* head index */
   uint_t		tix;		/* tail index */
   u16_t		sseqno;		/* next server seqno */
   u16_t		rseqno;		/* last server reply seqno */
   u16_t		bseqno;		/* base sequence number of current e */
   uint_t		blkcnt;		/* for memory/sanity check */
   sm_blk_t *		head;		/* fifo out, search here */
   sm_blk_t *		tail;		/* fifo in, add entries here */
}sm_xxx;	/* sm_t defined in xmx.h */

#define sm_last_reply(smp)	(smp->rseqno)
