/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/************************************************************************
*									*
*   ptc_x.h								*
*									*
*	X Protocol translation macros.					*
*									*
*	Write translation operations for each protocol request.		*
*									*
************************************************************************/

/*
**  scan window attribute values for mappables.
*/
#define ptc_winvals(ptcp, basep, mask, _vp, mappixels) {\
	register mask_t m, tm;\
	register u32_t *vp = (u32_t *)(_vp);\
\
	for (m=1, tm=(mask); tm; m<<=1, tm>>=1)\
	   if (tm & 1) {\
	      switch (m) {\
	         case CWBackPixmap:\
	            if (*vp > 1)   /* optional mappable */\
	               PTC_RID(ptcp, basep, *vp);\
	            break;\
	         case CWBackPixel:\
	         case CWBorderPixel:\
	         case CWBackingPixel:\
	            if (mappixels)\
	               PTC_PIXEL(ptcp, basep, *vp);\
	            break;\
	         case CWBorderPixmap:\
	         case CWColormap:\
	         case CWCursor:\
	            if (*vp)       /* optional mappable */\
	               PTC_RID(ptcp, basep, *vp);\
	            break;\
	         case CWEventMask:\
	            PTC_EVENTMASK(ptcp, basep, *vp);\
	            break;\
	      }\
	      vp++;\
	   }\
}

/*
**  scan configure window values for mappables.
*/
#define ptc_confvals(ptcp, basep, mask, _vp) {\
	register mask_t m, tm;\
	register u32_t *vp = (u32_t *)(_vp);\
\
	for (m=1, tm=(mask); tm; m<<=1, tm>>=1)\
	   if (tm & 1) {\
	      switch (m) {\
	         case CWSibling:\
	            PTC_RID(ptcp, basep, *vp);\
	            break;\
	      }\
	      vp++;\
	   }\
}

/*
**  scan gc attribute values for mappables.
*/
#define ptc_gcvals(ptcp, basep, mask, _vp, mappixels) {\
	register mask_t m, tm;\
	register u32_t *vp = (u32_t *)(_vp);\
\
	for (m=1, tm=(mask); tm; m<<=1, tm>>=1)\
	   if (tm & 1) {\
	      switch (m) {\
	         case GCForeground:\
	         case GCBackground:\
	            if (mappixels)\
	               PTC_PIXEL(ptcp, basep, *vp);\
	            break;\
	         case GCTile:\
	         case GCStipple:\
	         case GCFont:\
	            PTC_RID(ptcp, basep, *vp);\
	            break;\
	         case GCGraphicsExposures:\
	            if (*vp)       /* optional mappable */\
	               PTC_GEXPOSE(ptcp, basep, *vp);\
	            break;\
	         case GCClipMask:\
	            if (*vp)       /* optional mappable */\
	               PTC_RID(ptcp, basep, *vp);\
	            break;\
	      }\
	      vp++;\
	   }\
}
/*
**  this common block must appear in every macro below.  it establishes
**  the ptc record for the given buffer, the base pointer for calculating
**  offsets, and bumps the sequence number count.
*/
#define COMMON(bp, _clinum, _seqno)\
	register ptc_t *ptcp = PTC_GET(bp, _clinum, _seqno);\
	register char *basep = buf_curdata(bp);\
	PTC_INCR_COUNT(ptcp)
/*
**  for requests with no mappables - just bump the sequence number count
*/
#define ptc_req(bp, clinum, seqno, p) {\
	register ptc_t *ptcp = PTC_GET(bp, clinum, seqno);\
	PTC_INCR_COUNT(ptcp);\
}
/*
**  for requests with only a single resource id to map
*/
#define ptc_id_req(bp, clinum, seqno, p, field) {\
	COMMON(bp, clinum, seqno);\
	PTC_RID(ptcp, basep, (p)->field);\
}
/*
**  for requests with two resource ids to map
*/
#define ptc_id2_req(bp, clinum, seqno, p, field1, field2) {\
	COMMON(bp, clinum, seqno);\
	PTC_RID(ptcp, basep, (p)->field1);\
	PTC_RID(ptcp, basep, (p)->field2);\
}
/************************************************************************
*									*
*  X protocol translation macros start here				*
*									*
************************************************************************/
#define ptc_CreateWindow(bp, clinum, seqno, p, mappixels) {\
	COMMON(bp, clinum, seqno);\
	PTC_RID(ptcp, basep, (p)->wid);\
	PTC_RID(ptcp, basep, (p)->parent);\
	if ((p)->visual)	/* optional mappable */\
	   PTC_RID(ptcp, basep, (p)->visual);\
	if ((p)->mask)\
	   ptc_winvals(ptcp, basep, (p)->mask, (p)+1, (mappixels));\
}
#define ptc_ChangeWindowAttributes(bp, clinum, seqno, p, mappixels) {\
	COMMON(bp, clinum, seqno);\
	PTC_RID(ptcp, basep, (p)->window);\
	if ((p)->valueMask)\
	   ptc_winvals(ptcp, basep, (p)->valueMask, (p)+1, (mappixels));\
}
#define ptc_GetWindowAttributes(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, id)
#define ptc_DestroyWindow(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, id)
#define ptc_DestroySubwindows(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, id)
#define ptc_ChangeSaveSet(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, window)
#define ptc_ReparentWindow(bp, clinum, seqno, p)\
	ptc_id2_req(bp, clinum, seqno, p, window, parent)
#define ptc_MapWindow(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, id)
#define ptc_MapSubwindows(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, id)
#define ptc_UnmapWindow(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, id)
#define ptc_UnmapSubwindows(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, id)

#define ptc_ConfigureWindow(bp, clinum, seqno, p) {\
	COMMON(bp, clinum, seqno);\
	PTC_RID(ptcp, basep, (p)->window);\
	ptc_confvals(ptcp, basep, (p)->mask, (p)+1)\
}

#define ptc_CirculateWindow(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, window)
#define ptc_GetGeometry(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, id)
#define ptc_QueryTree(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, id)
#define ptc_InternAtom(bp, clinum, seqno, p)\
	ptc_req(bp, clinum, seqno, p)
/*
**  never map the atom in this - if we can map it, we already know the name
*/
#define ptc_GetAtomName(bp, clinum, seqno, p)\
	ptc_req(bp, clinum, seqno, p)
/* has atom */
#define ptc_ChangeProperty(bp, clinum, seqno, p) {\
	COMMON(bp, clinum, seqno);\
\
	PTC_RID(ptcp, basep, (p)->window);\
	if ((p)->property == XA_WM_HINTS) {\
	   register XWMHints *hp = (XWMHints *)(p+1);\
\
	   if (hp->flags & IconPixmapHint)\
	      PTC_RID(ptcp, basep, hp->icon_pixmap);\
	   if (hp->flags & IconWindowHint) {\
	      PTC_RID(ptcp, basep, hp->icon_window);\
	   }\
	   if (hp->flags & IconMaskHint) {\
	      PTC_RID(ptcp, basep, hp->icon_mask);\
	   }\
	   if (hp->flags & WindowGroupHint) {\
	      PTC_RID(ptcp, basep, hp->window_group);\
	   }\
	}\
	else if (p->property == _WM_COLORMAP_WINDOWS) {\
	   register int i;\
	   register rid_t *rp;\
\
	   PTC_ATOM(ptcp, basep, (p)->property);\
	   rp = (rid_t *)(p+1);\
	   for (i=0; i<(p)->nUnits; i++)\
	      PTC_RID(ptcp, basep, rp[i]);\
	}\
}

/* has atom */
#define ptc_DeleteProperty(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, window)
/* has atom */
#define ptc_GetProperty(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, window)

#define ptc_ListProperties(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, id)

/* has atom */
#define ptc_SetSelectionOwner(bp, clinum, seqno, p) {\
	COMMON(bp, clinum, seqno);\
	if ((p)->window)	/* optional mappable */\
	   PTC_RID(ptcp, basep, (p)->window);\
}
/* has atom */
#define ptc_GetSelectionOwner(bp, clinum, seqno, p)\
	ptc_req(bp, clinum, seqno, p)
/* has atom */
#define ptc_ConvertSelection(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, requestor)

#define ptc_SendEvent(bp, clinum, seqno, p) {\
	COMMON(bp, clinum, seqno);\
	if ((p)->destination > 1)	/* optional mappable */\
	   PTC_RID(ptcp, basep, (p)->destination);\
}

#define ptc_GrabPointer(bp, clinum, seqno, p) {\
	COMMON(bp, clinum, seqno);\
	PTC_RID(ptcp, basep, (p)->grabWindow);\
	if ((p)->confineTo)	/* optional mappable */\
	   PTC_RID(ptcp, basep, (p)->confineTo);\
	if ((p)->cursor)	/* optional mappable */\
	   PTC_RID(ptcp, basep, (p)->cursor);\
}

#define ptc_UngrabPointer(bp, clinum, seqno, p)\
	ptc_req(bp, clinum, seqno, p)

#define ptc_GrabButton(bp, clinum, seqno, p) {\
	COMMON(bp, clinum, seqno);\
	PTC_RID(ptcp, basep, (p)->grabWindow);\
	if ((p)->confineTo)	/* optional mappable */\
	   PTC_RID(ptcp, basep, (p)->confineTo);\
	if ((p)->cursor)	/* optional mappable */\
	   PTC_RID(ptcp, basep, (p)->cursor);\
}

#define ptc_UngrabButton(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, grabWindow)

#define ptc_ChangeActivePointerGrab(bp, clinum, seqno, p) {\
	COMMON(bp, clinum, seqno);\
	if ((p)->cursor)	/* optional mappable */\
	   PTC_RID(ptcp, basep, (p)->cursor);\
}

#define ptc_GrabKeyboard(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, grabWindow)
#define ptc_UngrabKeyboard(bp, clinum, seqno, p)\
	ptc_req(bp, clinum, seqno, p)
#define ptc_GrabKey(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, grabWindow)
#define ptc_UngrabKey(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, grabWindow)
#define ptc_AllowEvents(bp, clinum, seqno, p)\
	ptc_req(bp, clinum, seqno, p)
#define ptc_GrabServer(bp, clinum, seqno, p)\
	ptc_req(bp, clinum, seqno, p)
#define ptc_UngrabServer(bp, clinum, seqno, p)\
	ptc_req(bp, clinum, seqno, p)
#define ptc_QueryPointer(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, id)
#define ptc_GetMotionEvents(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, window)
#define ptc_TranslateCoords(bp, clinum, seqno, p)\
	ptc_id2_req(bp, clinum, seqno, p, srcWid, dstWid)

#define ptc_WarpPointer(bp, clinum, seqno, p) {\
	COMMON(bp, clinum, seqno);\
	if ((p)->srcWid)	/* optional mappable */\
	   PTC_RID(ptcp, basep, (p)->srcWid);\
	if ((p)->dstWid)	/* optional mappable */\
	   PTC_RID(ptcp, basep, (p)->dstWid);\
}

#define ptc_SetInputFocus(bp, clinum, seqno, p) {\
	COMMON(bp, clinum, seqno);\
	if ((p)->focus > 1)	/* optional mappable */\
	   PTC_RID(ptcp, basep, (p)->focus);\
}
#define ptc_GetInputFocus(bp, clinum, seqno, p)\
	ptc_req(bp, clinum, seqno, p)
#define ptc_QueryKeymap(bp, clinum, seqno, p)\
	ptc_req(bp, clinum, seqno, p)
#define ptc_OpenFont(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, fid)
#define ptc_CloseFont(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, id)
#define ptc_QueryFont(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, id)
#define ptc_QueryTextExtents(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, fid)
#define ptc_ListFonts(bp, clinum, seqno, p)\
	ptc_req(bp, clinum, seqno, p)
#define ptc_ListFontsWithInfo(bp, clinum, seqno, p)\
	ptc_req(bp, clinum, seqno, p)
#define ptc_SetFontPath(bp, clinum, seqno, p)\
	ptc_req(bp, clinum, seqno, p)
#define ptc_GetFontPath(bp, clinum, seqno, p)\
	ptc_req(bp, clinum, seqno, p)
#define ptc_CreatePixmap(bp, clinum, seqno, p)\
	ptc_id2_req(bp, clinum, seqno, p, pid, drawable)
#define ptc_FreePixmap(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, id)

#define ptc_CreateGC(bp, clinum, seqno, p, mappixels) {\
	COMMON(bp, clinum, seqno);\
	PTC_RID(ptcp, basep, (p)->gc);\
	PTC_RID(ptcp, basep, (p)->drawable);\
	ptc_gcvals(ptcp, basep, (p)->mask, (p)+1, mappixels);\
}

#define ptc_ChangeGC(bp, clinum, seqno, p, mappixels) {\
	COMMON(bp, clinum, seqno);\
	PTC_RID(ptcp, basep, (p)->gc);\
	ptc_gcvals(ptcp, basep, (p)->mask, (p)+1, mappixels);\
}
#define ptc_CopyGC(bp, clinum, seqno, p)\
	ptc_id2_req(bp, clinum, seqno, p, srcGC, dstGC)
#define ptc_SetDashes(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, gc)
#define ptc_SetClipRectangles(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, gc)
#define ptc_FreeGC(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, id)
#define ptc_ClearArea(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, window)

#define ptc_CopyArea(bp, clinum, seqno, p) {\
	COMMON(bp, clinum, seqno);\
	PTC_RID(ptcp, basep, (p)->srcDrawable);\
	PTC_RID(ptcp, basep, (p)->dstDrawable);\
	PTC_RID(ptcp, basep, (p)->gc);\
}

#define ptc_CopyPlane(bp, clinum, seqno, p) {\
	COMMON(bp, clinum, seqno);\
	PTC_RID(ptcp, basep, (p)->srcDrawable);\
	PTC_RID(ptcp, basep, (p)->dstDrawable);\
	PTC_RID(ptcp, basep, (p)->gc);\
}
#define ptc_PolyPoint(bp, clinum, seqno, p)\
	ptc_id2_req(bp, clinum, seqno, p, drawable, gc)
#define ptc_PolyLine(bp, clinum, seqno, p)\
	ptc_id2_req(bp, clinum, seqno, p, drawable, gc)
#define ptc_PolySegment(bp, clinum, seqno, p)\
	ptc_id2_req(bp, clinum, seqno, p, drawable, gc)
#define ptc_PolyRectangle(bp, clinum, seqno, p)\
	ptc_id2_req(bp, clinum, seqno, p, drawable, gc)
#define ptc_PolyArc(bp, clinum, seqno, p)\
	ptc_id2_req(bp, clinum, seqno, p, drawable, gc)
#define ptc_FillPoly(bp, clinum, seqno, p)\
	ptc_id2_req(bp, clinum, seqno, p, drawable, gc)
#define ptc_PolyFillRectangle(bp, clinum, seqno, p)\
	ptc_id2_req(bp, clinum, seqno, p, drawable, gc)
#define ptc_PolyFillArc(bp, clinum, seqno, p)\
	ptc_id2_req(bp, clinum, seqno, p, drawable, gc)

#define ptc_PutImage(bp, clinum, seqno, p) {\
	COMMON(bp, clinum, seqno);\
	PTC_IMAGELEN(	ptcp,\
			basep,\
			(p)->length,\
			(p)->format,\
			(p)->width,\
			(p)->height,\
			(p)->leftPad,\
			(p)->depth);\
	PTC_RID(ptcp, basep, (p)->drawable);\
	PTC_RID(ptcp, basep, (p)->gc);\
}
#define ptc_GetImage(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, drawable)
#define ptc_PolyText8(bp, clinum, seqno, p)\
	ptc_id2_req(bp, clinum, seqno, p, drawable, gc)
#define ptc_PolyText16(bp, clinum, seqno, p)\
	ptc_id2_req(bp, clinum, seqno, p, drawable, gc)
#define ptc_ImageText8(bp, clinum, seqno, p)\
	ptc_id2_req(bp, clinum, seqno, p, drawable, gc)
#define ptc_ImageText16(bp, clinum, seqno, p)\
	ptc_id2_req(bp, clinum, seqno, p, drawable, gc)

#define ptc_CreateColormap(bp, clinum, seqno, p) {\
	COMMON(bp, clinum, seqno);\
	PTC_RID(ptcp, basep, (p)->mid);\
	PTC_RID(ptcp, basep, (p)->window);\
	PTC_RID(ptcp, basep, (p)->visual);\
}
#define ptc_FreeColormap(bp, clinum, seqno, p)\
		ptc_id_req(bp, clinum, seqno, p, id)
#define ptc_CopyColormapAndFree(bp, clinum, seqno,p)\
	ptc_id2_req(bp, clinum, seqno, p, mid, srcCmap)
#define ptc_InstallColormap(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, id)
#define ptc_UninstallColormap(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, id)
#define ptc_ListInstalledColormaps(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, id)
#define ptc_AllocColor(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, cmap)
#define ptc_AllocNamedColor(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, cmap)
#define ptc_AllocColorCells(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, cmap)
#define ptc_AllocColorPlanes(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, cmap)
#define ptc_FreeColors(bp, clinum, seqno, p, mappixels) {\
	COMMON(bp, clinum, seqno);\
	PTC_RID(ptcp, basep, (p)->cmap);\
	if ((p)->cmap & RID_SERVER_MASK && (mappixels)) {/* root colormap */\
	   register int i, n;\
	   register pixel_t *pixelp;\
\
	   pixelp = (pixel_t *)((p)+1);\
	   n = (int)((p)->length-sz_xFreeColorsReq/4);\
	   for (i=0; i<n; i++) {\
	      PTC_PIXEL(ptcp, basep, pixelp[i]);\
	   }\
	}\
}
#define ptc_StoreColors(bp, clinum, seqno, p, mappixels) {\
	COMMON(bp, clinum, seqno);\
	PTC_RID(ptcp, basep, (p)->cmap);\
	if ((p)->cmap & RID_SERVER_MASK && (mappixels)) {/* root colormap */\
	   register int i, n;\
	   register xColorItem *c;\
\
	   c = (xColorItem *)((p)+1);\
	   n = (int)(((p)->length*4)-sz_xStoreColorsReq) / sz_xColorItem;\
	   for (i=0; i<n; i++) {\
	      PTC_PIXEL(ptcp, basep, c[i].pixel);\
	   }\
	}\
}
#define ptc_StoreNamedColor(bp, clinum, seqno, p, mappixels) {\
	COMMON(bp, clinum, seqno);\
	PTC_RID(ptcp, basep, (p)->cmap);\
	if ((p)->cmap & RID_SERVER_MASK && (mappixels)) {/* root colormap */\
	   PTC_PIXEL(ptcp, basep, (p)->pixel);\
	}\
}
#define ptc_QueryColors(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, cmap)
#define ptc_LookupColor(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, cmap)

#define ptc_CreateCursor(bp, clinum, seqno, p) {\
	COMMON(bp, clinum, seqno);\
	PTC_RID(ptcp, basep, (p)->cid);\
	PTC_RID(ptcp, basep, (p)->source);\
	if ((p)->mask) {	/* optional mappable */\
	   PTC_RID(ptcp, basep, (p)->mask);\
	}\
}
#define ptc_CreateGlyphCursor(bp, clinum, seqno, p) {\
	COMMON(bp, clinum, seqno);\
	PTC_RID(ptcp, basep, (p)->cid);\
	PTC_RID(ptcp, basep, (p)->source);\
	if ((p)->mask) {	/* optional mappable */\
	   PTC_RID(ptcp, basep, (p)->mask);\
	}\
}
#define ptc_FreeCursor(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, id)
#define ptc_RecolorCursor(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, cursor)
#define ptc_QueryBestSize(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, drawable)
#define ptc_QueryExtension(bp, clinum, seqno, p)\
	ptc_req(bp, clinum, seqno, p)
#define ptc_ListExtensions(bp, clinum, seqno, p)\
	ptc_req(bp, clinum, seqno, p)
#define ptc_ChangeKeyboardMapping(bp, clinum, seqno, p)\
	ptc_req(bp, clinum, seqno, p)
#define ptc_GetKeyboardMapping(bp, clinum, seqno, p)\
	ptc_req(bp, clinum, seqno, p)
#define ptc_ChangeKeyboardControl(bp, clinum, seqno, p)\
	ptc_req(bp, clinum, seqno, p)
#define ptc_GetKeyboardControl(bp, clinum, seqno, p)\
	ptc_req(bp, clinum, seqno, p)
#define ptc_Bell(bp, clinum, seqno, p)\
	ptc_req(bp, clinum, seqno, p)
#define ptc_ChangePointerControl(bp, clinum, seqno, p)\
	ptc_req(bp, clinum, seqno, p)
#define ptc_GetPointerControl(bp, clinum, seqno, p)\
	ptc_req(bp, clinum, seqno, p)
#define ptc_SetScreenSaver(bp, clinum, seqno, p)\
	ptc_req(bp, clinum, seqno, p)
#define ptc_GetScreenSaver(bp, clinum, seqno, p)\
	ptc_req(bp, clinum, seqno, p)
#define ptc_ChangeHosts(bp, clinum, seqno, p)\
	ptc_req(bp, clinum, seqno, p)
#define ptc_ListHosts(bp, clinum, seqno, p)\
	ptc_req(bp, clinum, seqno, p)
#define ptc_SetAccessControl(bp, clinum, seqno, p)\
	ptc_req(bp, clinum, seqno, p)
#define ptc_SetCloseDownMode(bp, clinum, seqno, p)\
	ptc_req(bp, clinum, seqno, p)

#define ptc_KillClient(bp, clinum, seqno, p) {\
	COMMON(bp, clinum, seqno);\
	if ((p)->id) {	/* optional mappable */\
	   PTC_RID(ptcp, basep, (p)->id);\
	}\
}
/* has atom */
#define ptc_RotateProperties(bp, clinum, seqno, p)\
	ptc_id_req(bp, clinum, seqno, p, window)
#define ptc_ForceScreenSaver(bp, clinum, seqno, p)\
	ptc_req(bp, clinum, seqno, p)
#define ptc_SetPointerMapping(bp, clinum, seqno, p)\
	ptc_req(bp, clinum, seqno, p)
#define ptc_GetPointerMapping(bp, clinum, seqno, p)\
	ptc_req(bp, clinum, seqno, p)
#define ptc_SetModifierMapping(bp, clinum, seqno, p)\
	ptc_req(bp, clinum, seqno, p)
#define ptc_GetModifierMapping(bp, clinum, seqno, p)\
	ptc_req(bp, clinum, seqno, p)
#define ptc_NoOperation(bp, clinum, seqno, p)\
	ptc_req(bp, clinum, seqno, p)
