/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/************************************************************************
*									*
*   pmap.c								*
*									*
************************************************************************/
#define NEED_REPLIES
#define NEED_EVENTS
#include <X11/X.h>
#include <X11/Xproto.h>
#include "xmx.h"
#include "incl/pmap.pvt.h"

/************************************************************************
*									*
*   pmap_new								*
*									*
************************************************************************/
void
pmap_new
   AL((sp))
   DB server_t *sp
   DE
{
   register uint_t i, ncols;
   pixel_t *pxlp;

   DEBUG1(D_PMAP, "pmap_new: class [%s]\n",
			dprx_visual_class_str(vscreen.wp->mp->vp->class));

   switch (vscreen.wp->mp->vp->class) {
      case GrayScale:
      case PseudoColor:
         ncols = vscreen.wp->mp->vp->nentries;
         break;
      case DirectColor:
         warn("pmap_new: DirectColor colormap sharing not implemented\n");
         return;
      case StaticGray:
      case StaticColor:
      case TrueColor:
         return;
   }
   if (MALLOC(pxlp, pixel_t *, ncols * sizeof(pixel_t)))
      return;
   /*
   **  initialize as identity mapping
   */
   for (i=0; i<ncols; i++)
      pxlp[i] = i;
   /*
   **  but add local server black & white mappings
   */
   if (sp->smap.root.whitePixel < ncols)
      pxlp[vscreen.whitePixel] = sp->smap.root.whitePixel;
   if (sp->smap.root.blackPixel < ncols)
      pxlp[vscreen.blackPixel] = sp->smap.root.blackPixel;

   sp->smap.root.pmap = pxlp;
}

void
pmap_free
   AL((pxlp))
   DB pixel_t *pxlp
   DE
{
   free(pxlp);
}

void
pmap_map
   AL((sp, mp, ncols, vpixelp, vmask, pixelp, mask))
   DB server_t *sp
   DD colormap_t *mp
   DD int ncols
   DD pixel_t *vpixelp
   DD mask_t vmask
   DD pixel_t *pixelp
   DD mask_t mask
   DE
{
   register int i;

   DEBUG5(D_PMAP, "pmap_map: server [%d/%s] ncols [%d] 1st [%d->%d]\n",
			sp->fd, sp->tag, ncols, vpixelp[0], pixelp[0]);

   switch (mp->vp->class) {
      case GrayScale:
      case PseudoColor:
         if (vmask || mask)
            warn("pmap_map: ignoring masks! (implement me)\n");

         for (i=0; i<ncols; i++)
            sp->smap.root.pmap[vpixelp[i]] =  pixelp[i];
         break;
      case DirectColor:
         warn("pmap_map: DirectColor colormaps not supported\n");
         return;
      case StaticGray:
      case StaticColor:
      case TrueColor:
         return;
   }
}

void
pmap_map_coloritems
   AL((sp, mp, ncols, cip, pixelp))
   DB server_t *sp
   DD colormap_t *mp
   DD int ncols
   DD xColorItem *cip
   DD pixel_t *pixelp
   DE
{
   register int i;

   switch (mp->vp->class) {
      case GrayScale:
      case PseudoColor:
         for (i=0; i<ncols; i++)
            sp->smap.root.pmap[cip[i].pixel] =  pixelp[i];
         break;
      case DirectColor:
         warn("pmap_map_coloritems: DirectColor colormaps not supported\n");
         return;
      case StaticGray:
      case StaticColor:
      case TrueColor:
         return;
   }
}
