/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/************************************************************************
*									*
*   ext.c								*
*									*
*	Server extension interface.					*
*									*
************************************************************************/
#define NEED_REPLIES
#define NEED_EVENTS
#include <X11/Xproto.h>
#include "xmx.h"
#include "ptc.h"
#include "incl/ext.pvt.h"

#ifdef SHAPE
extern void shape_init();
#endif
#ifdef PEXEXT
extern void pex_init();
#endif
#ifdef MULTIBUFFER
extern void multibuf_init();
#endif

/************************************************************************
*									*
*   ext_init								*
*									*
************************************************************************/
void
ext_init
   VOID
{
#ifdef SHAPE
   shape_init();
#endif
#ifdef PEXEXT
   pex_init();
#endif
#ifdef MULTIBUFFER
   multibuf_init();
#endif
}

/************************************************************************
*									*
*   ext_query								*
*									*
************************************************************************/
void
ext_query
   AL((cp, p))
   DB client_t *cp
   DD xQueryExtensionReq *p
   DE
{
   proto_QueryExtensionReply(cp, 0, 0, 0, 0);	/* none yet */
}

/************************************************************************
*									*
*   ext_list								*
*									*
************************************************************************/
void
ext_list
   AL((cp, p))
   DB client_t *cp
   DD xReq *p
   DE
{
   proto_ListExtensionsReply(cp, 0, 0);		/* none yet */
}

/************************************************************************
*									*
*   ext_request_process							*
*									*
************************************************************************/
int
ext_request_process
   AL((cp, rp, left))
   DB client_t *cp
   DD xReq *rp
   DD uint_t left
   DE
{
   return 0;
}

/************************************************************************
*									*
*   ext_supported							*
*									*
************************************************************************/
int
ext_supported
   AL((name))
   DB char *name
   DE
{
   return 0;	/* no extensions supported, yet */
}

/************************************************************************
*									*
*   ext_list_supported							*
*									*
************************************************************************/
ext_t *
ext_list_supported
   VOID
{
   return 0;	/* no extensions supported, yet */
}

/************************************************************************
*									*
*   ext_gets_reply							*
*									*
************************************************************************/
int
ext_gets_reply
   AL((major, minor))
   DB u8_t major
   DD u16_t minor
   DE
{
   return 0;
}

/************************************************************************
*									*
*   ext_ptc								*
*									*
************************************************************************/
void
ext_ptc
   AL((code, op, sp, chp))
   DB u8_t code
   DD op_extension_t *op
   DD server_t *sp
   DD chunk_t *chp
   DE
{
}

/************************************************************************
*									*
*   ext_event_mask							*
*									*
************************************************************************/
void
ext_event_mask
   VOID
{
}

/************************************************************************
*									*
*   ext_unmap_reply							*
*									*
************************************************************************/
chunk_t *
ext_unmap_reply
   AL((bp, sp, major, minor, seqno))
   DB buffer_t *bp
   DD server_t *sp
   DD u8_t major
   DD u16_t minor
   DD u16_t seqno
   DE
{
}

/************************************************************************
*									*
*   ext_ketchup								*
*									*
************************************************************************/
void
ext_ketchup
   VOID
{
}

/************************************************************************
*									*
*   ext_request_swap							*
*									*
************************************************************************/
void
ext_request_swap
   AL((rp, left))
   DB xReq *rp
   DD uint_t left
   DE
{
}

/************************************************************************
*									*
*   ext_error_swap							*
*									*
************************************************************************/
void
ext_error_swap
   AL((p))
   DB xError *p
   DE
{
}

/************************************************************************
*									*
*   ext_event_swap							*
*									*
************************************************************************/
void
ext_event_swap
   AL((p))
   DB xEvent *p
   DE
{
}

/************************************************************************
*									*
*   ext_reply_swap							*
*									*
************************************************************************/
void
ext_reply_swap
   AL((rp, reqtype))
   DB xGenericReply *rp
   DD int reqtype
   DE
{
}
