/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/************************************************************************
*									*
*   dprxmc.c								*
*									*
*	Routines to print XMC protocol structures.			*
*									*
************************************************************************/
#include <stdlib.h>

#include <xmc.h>
#include <xmcp.h>

#include "xmx.h"
#include "incl/dprxmc.pvt.h"

char *
dprxmc_req_str
   AL((code))
   DB u8_t code
   DE
{
   switch (code) {
      case XMC_Register:		return "Register";
      case XMC_Unregister:		return "Unregister";
      case XMC_SetAuth:			return "SetAuth";
      case XMC_GetAuth:			return "GetAuth";
      case XMC_AddDisplay:		return "AddDisplay";
      case XMC_SetDisplayTag:		return "SetDisplayTag";
      case XMC_QueryDisplay:		return "QueryDisplay";
      case XMC_ListDisplays:		return "ListDisplays";
      case XMC_ListDisplaysWithInfo:	return "ListDisplaysWithInfo";
      case XMC_DropDisplay:		return "DropDisplay";
      case XMC_Sync:			return "Sync";
      case XMC_SetConfig:		return "SetConfig";
      case XMC_GetConfig:		return "GetConfig";
      case XMC_SetConfigMode:		return "SetConfigMode";
      case XMC_ChangeInputMode:		return "ChangeInputMode";
      case XMC_SetEventMask:		return "SetEventMask";
      case XMC_GetEventMask:		return "GetEventMask";
      case XMC_SetXEventMask:		return "SetXEventMask";
      case XMC_GetXEventMask:		return "GetXEventMask";
      case XMC_GrabPointer:		return "GrabPointer";
      case XMC_UngrabPointer:		return "UngrabPointer";
      case XMC_GrabKeyboard:		return "GrabKeyboard";
      case XMC_UngrabKeyboard:		return "UngrabKeyboard";
      case XMC_ShareSelections:		return "ShareSelections";
      case XMC_UnshareSelections:	return "UnshareSelections";
      case XMC_CreateTptr:		return "CreateTptr";
      case XMC_CreateGlyphTptr:		return "CreateGlyphTptr";
      case XMC_DestroyTptr:		return "DestroyTptr";
      case XMC_AssignTptr:		return "AssignTptr";
      case XMC_HideTptr:		return "HideTptr";
      case XMC_ShowTptr:		return "ShowTptr";
      default:				return "<unknown request>";
   }
}

char *
dprxmc_mode_str
   AL((mode))
   DB int mode
   DE
{
   switch (mode) {
      case View:		return "View";
      case Seat:		return "Seat";
      case Floor:		return "Floor";
      default:			return "<unknown mode>";
   }
}

void
dprxmc_req
   AL((rp))
   DB xmcReq *rp
   DE
{
   warn("%s\n", dprxmc_req_str(rp->code));
   warn("\tlength________%d\n", rp->length);

   switch (rp->code) {
      case XMC_Register:
         {  register xmcRegisterReq *p = (xmcRegisterReq *)rp;
            warn("\tfamily________ %d\n", p->family);
            warn("\tregID_________ 0x%08x\n", p->regID);
            warn("\tport__________ %d\n", p->port);
            warn("\tnBytesAddress_ %d\n", p->nBytesAddress);
            warn("\tnBytesName____ %d\n", p->nBytesName);
            warn("\tnBytesURL_____ %d\n", p->nBytesURL);
            warn("\tnBytesDesc____ %d\n", p->nBytesDesc);
         }
         break;
      case XMC_Unregister:
      case XMC_QueryDisplay:
      case XMC_DropDisplay:
      case XMC_GetXEventMask:
      case XMC_GrabPointer:
      case XMC_UngrabPointer:
      case XMC_GrabKeyboard:
      case XMC_UngrabKeyboard:
      case XMC_ShareSelections:
      case XMC_UnshareSelections:
      case XMC_DestroyTptr:
      case XMC_HideTptr:
      case XMC_ShowTptr:
         {  register xmcIdReq *p = (xmcIdReq *)rp;
            warn("\tid____________ 0x%08x\n", p->id);
         }
         break;
      case XMC_SetAuth:
         {  register xmcSetAuthReq *p = (xmcSetAuthReq *)rp;
            warn("\tpMask_________ 0x%08x\n", p->pMask);
            warn("\tnBytesName____ %d\n", p->nBytesName);
            warn("\tnBytesData____ %d\n", p->nBytesData);
         }
         break;
      case XMC_GetAuth:
         {  register xmcGetAuthReq *p = (xmcGetAuthReq *)rp;
            warn("\tnBytesName____ %d\n", p->nBytesName);
            warn("\tnBytesData____ %d\n", p->nBytesData);
         }
         break;
      case XMC_AddDisplay:
         {  register xmcAddDisplayReq *p = (xmcAddDisplayReq *)rp;
            warn("\tmode__________ %d (%s)\n", p->mode,
						dprxmc_mode_str(p->mode));
            warn("\tdispID________ 0x%08x\n", p->dispID);
            warn("\tscreen________ %d\n", p->screen);
            warn("\tfamily________ %d\n", p->family);
            warn("\tconfigMode____ %d\n", p->configMode);
            warn("\tnBytesAddress_ %d\n", p->nBytesAddress);
            warn("\tdisplayNumber_ %d\n", p->displayNumber);
            warn("\twindow________ 0x%08x\n", p->window);
            warn("\tnBytesGeom____ %d\n", p->nBytesGeom);
            warn("\tnBytesTag_____ %d\n", p->nBytesTag);
            warn("\tnBytesName____ %d\n", p->nBytesName);
            warn("\tnBytesData____ %d\n", p->nBytesData);
            warn("\ttpID__________ 0x%08x\n", p->tpID);
         }
         break;
      case XMC_SetDisplayTag:
         {  register xmcSetDisplayTagReq *p = (xmcSetDisplayTagReq *)rp;
            warn("\tdispID________ 0x%08x\n", p->dispID);
            warn("\tnBytesTag_____ %d\n", p->nBytesTag);
         }
         break;
      case XMC_ListDisplays:
      case XMC_ListDisplaysWithInfo:
      case XMC_Sync:
      case XMC_GetConfig:
      case XMC_GetEventMask:
         break;
      case XMC_SetConfig:
         {  register xmcSetConfigReq *p = (xmcSetConfigReq *)rp;
            warn("\twidth_________ %d\n", p->width);
            warn("\theight________ %d\n", p->height);
            warn("\tnDepthTypes___ %d\n", p->nDepthTypes);
            warn("\tnExtensions___ %d\n", p->nExtensions);
         }
         break;
      case XMC_SetConfigMode:
         {  register xmcSetConfigModeReq *p = (xmcSetConfigModeReq *)rp;
            warn("\tmode__________ %d\n", p->mode);
         }
         break;
      case XMC_ChangeInputMode:
         {  register xmcChangeInputModeReq *p = (xmcChangeInputModeReq *)rp;
            warn("\tmode__________ %d (%s)\n", p->mode,
						dprxmc_mode_str(p->mode));
            warn("\tdispID________ 0x%08x\n", p->dispID);
         }
         break;
      case XMC_SetEventMask:
         {  register xmcSetEventMaskReq *p = (xmcSetEventMaskReq *)rp;
            warn("\tmask__________ %d\n", p->mask);
         }
         break;
      case XMC_SetXEventMask:
         {  register xmcSetXEventMaskReq *p = (xmcSetXEventMaskReq *)rp;
            warn("\twindow________ 0x%08x\n", p->window);
            warn("\tmask__________ %d\n", p->mask);
         }
         break;
      case XMC_CreateTptr:
         {  register xmcCreateTptrReq *p = (xmcCreateTptrReq *)rp;
            warn("\tmask__________ %d\n", p->mask);
            warn("\ttpID__________ 0x%08x\n", p->tpID);
            warn("\tsrcID_________ 0x%08x\n", p->srcID);
            warn("\tmskID_________ 0x%08x\n", p->mskID);
            warn("\thotx__________ %d\n", p->hotx);
            warn("\thoty__________ %d\n", p->hoty);
            warn("\tforeRed_______ %d\n", p->foreRed);
            warn("\tforeGreen_____ %d\n", p->foreGreen);
            warn("\tforeBlue______ %d\n", p->foreBlue);
            warn("\tbackRed_______ %d\n", p->backRed);
            warn("\tbackGreen_____ %d\n", p->backGreen);
            warn("\tbackBlue______ %d\n", p->backBlue);
         }
         break;
      case XMC_CreateGlyphTptr:
         {  register xmcCreateGlyphTptrReq *p = (xmcCreateGlyphTptrReq *)rp;
            warn("\tmask__________ %d\n", p->mask);
            warn("\ttpID__________ 0x%08x\n", p->tpID);
            warn("\tsrcID_________ 0x%08x\n", p->srcID);
            warn("\tmskID_________ 0x%08x\n", p->mskID);
            warn("\tsrcChar_______ %d\n", p->srcChar);
            warn("\tmskChar_______ %d\n", p->mskChar);
            warn("\tforeRed_______ %d\n", p->foreRed);
            warn("\tforeGreen_____ %d\n", p->foreGreen);
            warn("\tforeBlue______ %d\n", p->foreBlue);
            warn("\tbackRed_______ %d\n", p->backRed);
            warn("\tbackGreen_____ %d\n", p->backGreen);
            warn("\tbackBlue______ %d\n", p->backBlue);
         }
      case XMC_AssignTptr:
         {  register xmcAssignTptrReq *p = (xmcAssignTptrReq *)rp;
            warn("\tdispID________ 0x%08%x\n", p->dispID);
            warn("\ttpID__________ 0x%08x\n", p->tpID);
         }
         break;
   }
}

char *
dprxmc_error_str
   AL((code))
   DB u8_t code
   DE
{
   switch (code) {
      case ErrDisplay:		return("ErrDisplay");
      case ErrConfig:		return("ErrConfig");
      case ErrMerge:		return("ErrMerge");
      case ErrEvent:		return("ErrEvent");
      case ErrAlloc:		return("ErrAlloc");
      case ErrConnect:		return("ErrConnect");
      case ErrTelepointer:	return("ErrTelepointer");
      case ErrId:		return("ErrId");
      case ErrGeometry:		return("ErrGeometry");
      default:			return("<unknown error code>");
   }
}

void
dprxmc_reply
   AL((rp, code))
   DB xmcReply *rp
   DD u8_t code
   DE
{
   if (rp->reply == 0) {
      register xmcError *p = (xmcError *)rp;

      warn("Error\n");
      warn("\terrorCode _________ %d (%s)\n", p->errorCode,
					dprxmc_error_str(p->errorCode));
      warn("\tseqNo _____________ %d\n", p->seqNo);
      warn("\topcode ____________ %d (%s)\n", p->opcode,
						dprxmc_req_str(p->opcode));
      warn("\tdata ______________ %d\n", p->data);
      return;
   }
   warn("%sReply\n", dprxmc_req_str(code));
   warn("\tlength________ %d\n", rp->length);
   warn("\tseqNo_________ %d\n", rp->seqNo);

   switch (code) {
      case XMC_GetAuth:
         {  register xmcGetAuthReply *p = (xmcGetAuthReply *)rp;
            warn("\tpMask_________ %d\n", p->pMask);
         }
         break;
      case XMC_QueryDisplay:
         {  register xmcQueryDisplayReply *p = (xmcQueryDisplayReply *)rp;
            warn("\tfamily________ %d\n", p->family);
            warn("\tnBytesAddress_ %d\n", p->nBytesAddress);
            warn("\tdisplayNumber_ %d\n", p->displayNumber);
            warn("\tmode__________ %d (%s)\n", p->mode,
						dprxmc_mode_str(p->mode));
            warn("\tnBytesTag_____ %d\n", p->nBytesTag);
            warn("\ttpID__________ 0x%08x\n", p->tpID);
            warn("\twindow________ 0x%08x\n", p->window);
            warn("\tscreen________ %d\n", p->screen);
		/* print address */
         }
         break;
      case XMC_ListDisplays:
         {  register xmcListDisplaysReply *p = (xmcListDisplaysReply *)rp;
            warn("\tnDisplays_____ %d\n", p->nDisplays);
		/* print displays */
         }
         break;
      case XMC_ListDisplaysWithInfo:
         {  register xmcListDisplaysWithInfoReply *p =
					(xmcListDisplaysWithInfoReply *)rp;
            warn("\tfamily________ %d\n", p->family);
            warn("\tdispID________ 0x%08x\n", p->dispID);
            warn("\tnBytesAddress_ %d\n", p->nBytesAddress);
            warn("\tdisplayNumber_ %d\n", p->displayNumber);
            warn("\tmode__________ %d (%s)\n", p->mode,
						dprxmc_mode_str(p->mode));
            warn("\tnBytesTag_____ %d\n", p->nBytesTag);
            warn("\ttpID__________ 0x%08x\n", p->tpID);
            warn("\twindow________ 0x%08x\n", p->window);
            warn("\tscreen________ %d\n", p->screen);
            warn("\tcount_________ %d\n", p->count);
		/* print address */
         }
         break;
      case XMC_GetConfig:
         {  register xmcGetConfigReply *p = (xmcGetConfigReply *)rp;
            warn("\twidth_________ %d\n", p->width);
            warn("\theight________ %d\n", p->height);
            warn("\tnDepthTypes___ %d\n", p->nDepthTypes);
            warn("\tnExtensions___ %d\n", p->nExtensions);
         }
         break;
      case XMC_GetEventMask:
      case XMC_GetXEventMask:
         {  register xmcGetEventMaskReply *p = (xmcGetEventMaskReply *)rp;
            warn("\tmask__________ %d\n", p->mask);
         }
         break;
   }
}
