/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/************************************************************************
*									*
*   cookie.c								*
*									*
************************************************************************/
#include "xmx.h"
#include "incl/cookie.pvt.h"

/************************************************************************
*									*
*   cookie_new								*
*									*
************************************************************************/
cookie_t *
cookie_new
   AL((namelen, name, datalen, data))
   DB u16_t namelen
   DD char *name
   DD u16_t datalen
   DD char *data
   DE
{
   register cookie_t *cookie;

   if (MALLOC(cookie, cookie_t *, sizeof(cookie_t)))
      return 0;

   if (MALLOC(cookie->name, char *, namelen + datalen + 1)) {
      free(cookie);
      return 0;
   }
   cookie->data = cookie->name + namelen + 1;

   cookie->namelen = namelen;
   bcopy(name, cookie->name, namelen);
   cookie->name[namelen] = '\0';	/* a convenience */
   cookie->datalen = datalen;
   bcopy(data, cookie->data, datalen);

   return cookie;
}

/************************************************************************
*									*
*   cookie_free								*
*									*
*	The cookie is zero'd out for added security.			*
*									*
************************************************************************/
void
cookie_free
   AL((cookie))
   DB cookie_t *cookie
   DE
{
   bzero(cookie->name, cookie->namelen + cookie->datalen + 1);
   free(cookie->name);
   free(cookie);
}
