/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/************************************************************************
*									*
*   cmapwin.c								*
*									*
*	Colormap window list routines.  These just keep track of the	*
*	value of the WM_COLORMAP_WINDOWS property.			*
*									*
************************************************************************/
#include "xmx.h"
#include "incl/cmapwin.pvt.h"

#define WINVECINCR	32

static rid_t *winvec;
static int winvecsz;
static int index;

/************************************************************************
*									*
*   cmapwin_install							*
*									*
*	Adds id to winvec.  The must not be in there.			*
*									*
************************************************************************/
void
cmapwin_install
   AL((id))
   DB rid_t id
   DE
{
   register rid_t *ridp;

   if (index == 0) {
      if (MALLOC(ridp, rid_t *, (winvecsz + WINVECINCR) * sizeof(rid_t))) {
         warn("cmapwin_install: can't add to WM_COLORMAP_WINDOWS property\n");
         return;
      }
      if (winvecsz) {
         bcopy(	(char *)winvec,
		(char *)&ridp[WINVECINCR],
		winvecsz * sizeof(rid_t));
         free(winvec);
      }
      winvec = ridp;
      winvecsz += WINVECINCR;
      index = WINVECINCR;
   }
   winvec[--index] = id;
}

/************************************************************************
*									*
*   cmapwin_uninstall							*
*									*
*	Removes id from winvec.  The id must be there.			*
*									*
************************************************************************/
void
cmapwin_uninstall
   AL((id))
   DB rid_t id
   DE
{
   register int i;
   register rid_t last, next;

   last = 0;
   for (i=index; i<winvecsz; i++) {
      next = winvec[i];
      winvec[i] = last;
      last = next;

      if (next == id)
         break;
   }
   index++;

#ifdef DEBUG
   if (i == winvecsz)
      warn("cmapwin_uninstall: id [0x%08x] not found - nuked winvec!\n", id);
#endif
}

/************************************************************************
*									*
*   cmapwin_winvec							*
*									*
*	Returns winvec, the value of the WM_COLORMAP_WINDOWS property.	*
*									*
************************************************************************/
int
cmapwin_winvec
   AL((idpp))
   DB rid_t **idpp
   DE
{
   *idpp = &winvec[index];
   return winvecsz - index;
}
