/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/*
**      Portability
*/
#if defined(_AIX) || defined(__SVR4) || defined(SVR4)
#define uchar_t uchar__t
#define ushort_t ushort__t
#define uint_t uint__t
#define ulong_t ulong__t
#endif

#ifdef SYSV
#define bcopy(a,b,c)    memcpy(b,a,c)
#define bcmp(a,b,c)     memcmp(a,b,c)
#endif

#define RUP(n,inc)      ((((n)+(inc)-1)/(inc))*(inc))
#ifndef MIN
#define MIN(a,b)	((a)<(b)?(a):(b))
#endif

/*
**      Types
*/
typedef unsigned char uchar_t;
typedef unsigned short ushort_t;
typedef unsigned int uint_t;
typedef unsigned long int ulong_t;

#define buf_active(bp)		((bp)->n)
#define buf_used(bp)		((unsigned int)((bp)->cp - (bp)->bp))
#define buf_free(bp)		((bp)->sz - buf_used(bp) - buf_active(bp))
#define buf_data(bp)		((bp)->cp)
#define buf_next(bp)		((bp)->cp + (bp)->n)
#define buf_setactive(bp,N)	(bp)->n = (N)

#include "../../include/funcproto.h"

/*
**	libXmc internal routines
*/
extern FUNC(int, Xmc_get_auth, (ushort_t, int, char *, ushort_t, int, char **, ushort_t *, char **, ushort_t *, char **));
extern FUNC(XmcEventList *, Xmc_eventlist_new, (void));
extern FUNC(void, Xmc_eventlist_free, (XmcEventList *));
extern FUNC(void, Xmc_event_push, (Mux *, xmcEvent *));
extern FUNC(int, Xmc_event_shift, (Mux *, XmcEvent *));
extern FUNC(void, Xmc_event_convert, (xmcEvent *, XmcEvent *));
extern FUNC(ulong_t, Xmc_seq2serial, (ushort_t));
extern FUNC(ulong_t, Xmc_newId, (Mux *));
extern FUNC(void, Xmc_zerobuf, (XmcBuf *));
extern FUNC(void, Xmc_clearbuf, (XmcBuf *, int));
extern FUNC(int, Xmc_bufadj, (XmcBuf *, int));
extern FUNC(char *, Xmc_allocout, (Mux *, int));
extern FUNC(void, Xmc_inclear, (Mux *, int));
extern FUNC(int, Xmc_flush, (Mux *));
extern FUNC(void, Xmc_sync, (Mux *));
extern FUNC(char *, Xmc_read, (Mux *, int));
extern FUNC(int, Xmc_read_noblock, (Mux *));
extern FUNC(int, Xmc_queue_events, (Mux *, xmcReply **));
extern FUNC(xmcReply *, Xmc_reply, (Mux *));
extern FUNC(int, Xmc_event, (Mux *, XmcEvent *));
extern FUNC(int, Xmc_parse_display, (char *, char **, int *, int *, int *));
extern FUNC(char *, Xmc_host_me, (void));
extern FUNC(int, Xmc_host_addr, (char *, int *, int *, char **));
extern FUNC(ushort_t, Xmc_family_utox, (ushort_t));
extern FUNC(ushort_t, Xmc_family_xtou, (ushort_t));

/*
**	Globals
*/
#ifdef COMMON
#define extern
#endif

#ifdef COMMON
#undef extern
#endif
