/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
#include <sys/param.h>
#include <stdio.h>
#include <stdlib.h>
#include <xmc.h>
#include <xmclib.h>
#include <xmcp.h>
#include "common.h"

#define XAUTHFILE	".Xauthority"

#define BUFSIZE		1024

static FUNC(int, read_short, (FILE *, ushort_t *));
static FUNC(int, read_string, (FILE *, char *, int, ushort_t));

int
Xmc_get_auth
   AL((family, length, address, display, authslen, auths,
					namelenp, namep, datalenp, datap))
   DB ushort_t family
   DD int length
   DD char *address
   DD ushort_t display
   DD int authslen
   DD char **auths
   DD ushort_t *namelenp
   DD char **namep
   DD ushort_t *datalenp
   DD char **datap
   DE
{
   register int i, rank;
   ushort_t fam, len, len2, disp;
   char *filename, *home;
   FILE *fp;
   char buf[MAXPATHLEN];
   char tbuf[BUFSIZE], dbuf[64];
   ushort_t namelen, datalen;
   static char namebuf[BUFSIZE];	/* return this */
   static char databuf[BUFSIZE];	/* return this */

   if ((filename = getenv("XAUTHORITY")) == 0)
      if (	(home = getenv("HOME")) &&
		strlen(home) <= MAXPATHLEN - strlen(XAUTHFILE) - 2) {
         sprintf(buf, "%s/.Xauthority", home);
         filename = buf;
      }
      else
         return 0;

   if ((fp = fopen(filename, "r")) == 0)
      return 0;

   /*
   **  flip through the authority file, look for the "best" auth data
   **  based on the vector of auth names provided.
   */
   namelen = 0;		/* test this later for a match */
   rank = authslen + 2;
   for (;;) {
      if (read_short(fp, &fam))		/* family */
         break;
      if (read_short(fp, &len))		/* address length */
         break;
      if (read_string(fp, &tbuf[0], BUFSIZE, len))	/* address */
         len = 0;				/* force match to fail */
      if (read_short(fp, &len2))	/* display string length */
         break;
      if (read_string(fp, &dbuf[0], BUFSIZE-1, len2))	/* display string */
         len = 0;				/* force match to fail */
      else {
         dbuf[len2] = '\0';
         disp = (ushort_t)atoi(dbuf);		/* display number */
      }
      if (	len &&			/* address:display matched */
		fam == family &&
		len == length &&
                disp == display &&
                bcmp(tbuf, address, len) == 0) {

         if (read_short(fp, &len))		/* name length */
            break;
         if (read_string(fp, &tbuf[0], BUFSIZE, len))	/* name */
            len = 0;
         if (read_short(fp, &len2))		/* data length */
            break;
         if (read_string(fp, &dbuf[0], BUFSIZE, len2))	/* data */
            len2 = 0;

         if (len && len2) {
            /*
            **  search the auth name list, stop if we find a match
            */
            for (i=0; i<authslen; i++)
               if (len == strlen(auths[i]) && strncmp(tbuf, auths[i], len) == 0)
                  if (i < rank)
                     break;
            /*
            **  prefer auths in the list, but take any if no match
            */
            if (i < rank) {
               namelen = len;
               bcopy(tbuf, namebuf, namelen);
               datalen = len2;
               bcopy(dbuf, databuf, datalen);
               rank = i;
            }
         }
      }
      else {
         if (read_short(fp, &len))	/* name length */
            break;
         fseek(fp, len, SEEK_CUR);	/* skip name */
         if (read_short(fp, &len))	/* data length */
            break;
         fseek(fp, len, SEEK_CUR);	/* skip data */
      }
   }
   if (namelen) {
      *namelenp = namelen;
      *namep = namebuf;
      *datalenp = datalen;
      *datap = databuf;

      return 1;
   }
   else
      return 0;
}

static int
read_short
   AL((fp, sp))
   DB FILE *fp
   DD ushort_t *sp
   DE
{
   ushort_t val;
   char *cp, ch;
   static ushort_t Bl = 0x426c;

   if (fread(&val, sizeof(ushort_t), 1, fp) != 1)	/* family */
      return -1;

   if (*((char *)&Bl) == 'l') {		/* swap if little endian */
      cp = (char *)&val;
      ch = cp[0];
      cp[0] = cp[1];
      cp[1] = ch;
   }
   *sp = val;
   return 0;
}

/*
**	guarantees space for a null char if needed
**	always advances file pointer
*/
static int
read_string
   AL((fp, cp, sz, len))
   DB FILE *fp
   DD char *cp
   DD int sz
   DD ushort_t len
   DE
{
   if ((int)len < sz)
      if (fread(cp, len, 1, fp) == 1)
         return 0;
   else
      fseek(fp, len, SEEK_CUR);		/* skip it */

   return -1;
}
