/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
#include <xmc.h>
#include <xmclib.h>
#include <xmcp.h>
#include "common.h"

int
XmcGetConfig
   AL((muxp, widthp, heightp, ndepthtypesp, depthtypesp, nextp, extp))
   DB Mux *muxp
   DD unsigned int *widthp
   DD unsigned int *heightp
   DD int *ndepthtypesp
   DD XmcDepthType **depthtypesp
   DD int *nextp
   DD char ***extp
   DE
{
   register int i;
   register int dtsz, exsz, len, rv;
   xmcGetConfigReq *p;
   xmcGetConfigReply *r;
   XmcDepthType *dtp;
   xmcDepthType *rdtp;
   register char *cp, *rcp, **ep;

   p = (xmcGetConfigReq *)Xmc_allocout(muxp, sz_xmcGetConfigReq);

   p->code = XMC_GetConfig;
   p->length = sz_xmcGetConfigReq;

   muxp->outseqno++;

   Xmc_flush(muxp);

   if ((r = (xmcGetConfigReply *)Xmc_reply(muxp)) == 0)
      return -1;

   dtsz = r->nDepthTypes * sizeof(XmcDepthType);
   exsz = r->nExtensions * sizeof(char **) +
		r->length - sz_xmcGetConfigReply - dtsz;

   if (r->nDepthTypes && (dtp = (XmcDepthType *)malloc(dtsz)) == 0) {
      rv = -1;
   }
   else if (r->nExtensions && (ep = (char **)malloc(exsz)) == 0) {
      if (r->nDepthTypes)
         free(dtp);
      rv = -1;
   }
   else {
      /*
      **  all systems go, load'er up
      */
      rdtp = (xmcDepthType *)(r+1);
      for (i=0; i<r->nDepthTypes; i++) {
         dtp[i].depth = rdtp[i].depth;
         dtp[i].visualclass = rdtp[i].visualClass;
      }
      rcp = (char *)(r+1) + sz_xmcGetConfigReply + dtsz;
      cp = (char *)&ep[r->nExtensions];
      for (i=0; i<r->nExtensions; i++) {
         len = *rcp++;
         ep[i] = cp;
         bcopy(rcp, cp, len);
         rcp += len;
         cp += len;
         *cp++ = '\0';
      }
      *widthp = r->width;
      *heightp = r->height;
      *ndepthtypesp = r->nDepthTypes;
      *depthtypesp = dtp;
      *nextp = r->nExtensions;
      *extp = ep;
      rv = 0;
   }
   Xmc_inclear(muxp, r->length);
   return rv;
}

void
XmcFreeDepthTypeInfo
   AL((depthtypesp, ndepthtypes))
   DB XmcDepthType *depthtypesp
   DD int ndepthtypes
   DE
{
   free(depthtypesp);
}

void
XmcFreeExtensionList
   AL((extensionsp, nextensions))
   DB char **extensionsp
   DD int nextensions
   DE
{
   /*
   **  it's all one contiguous block
   */
   free(extensionsp);
}
