/*
 * Copyright 1991-1997, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
#include <stdio.h>
#if defined(__SVR4) || defined(SVR4)
#include <sys/utsname.h>
#else
#include <sys/param.h>
#endif
#ifndef MAXHOSTNAMELEN
#ifdef SYS_NMLN
#define MAXHOSTNAMELEN  SYS_NMLN
#else
#define MAXHOSTNAMELEN  not_defined
#endif
#endif

#include <X11/Intrinsic.h>
#include "ig.h"
#include "node.h"

#ifdef SYSV
#ifdef index
#undef index
#endif
#define index(a,b)	strchr(a,b)
#endif

#define TABSZ	1024

int nnodes;
node_t *tab[TABSZ];

static node_t *find_bytag();
static char *make_new_tag();

node_t *
node_add(id, display, mode, w)
   unsigned long int id;
   char *display;
   int mode;
   Widget w;
{
   register int key;
   register node_t *np;
   register char *cp;
   char buf[MAXHOSTNAMELEN];
   key = id % TABSZ;

   if ((np = (node_t *)malloc(sizeof(node_t))) == 0) {
      fprintf(stderr, "node_add: malloc returned zero, fatal\n");
      exit(-1);
   }

   np->id = id;
   np->mode = mode;
   np->w = w;

   /*
   ** This isn't right - make_new_tag will differentiate identical
   ** tags in this client, but without modifying the tags stored
   ** in the server.  Punted for now (TODO)
   */
   if ((np->display = make_new_tag(display)) == 0) {
      fprintf(stderr, "node_add: can't create a unique tag, fatal\n");
      exit(-1);
   }
   np->ip = 0;
   nnodes++;

   if (tab[key])
      np->next = tab[key];
   else
      np->next = 0;

   tab[key] = np;

   return np;
}

void
node_remove(np)
   node_t *np;
{
   register int key;
   register node_t *tp;

   key = np->id % TABSZ;

   if (tab[key]->id == np->id)
      tab[key] = np->next;
   else
      for (tp=tab[key]; tp->next; tp=tp->next)
         if (tp->next->id == np->id) {
            tp->next = tp->next->next;
            break;
         }
   if (np->display)
      free(np->display);

   nnodes--;
   free(np);
}

node_t *
node_byid(id)
   unsigned long int id;
{
   register int key;
   register node_t *np;

   key = id % TABSZ;

   for (np=tab[key]; np && np->id != id; np=np->next);

   return np;
}

void
node_foreach(rtn, dp)
   nodeproc_t rtn;
   void *dp;
{
   register int i, n;
   register node_t *np, *tp;

   n = nnodes;
   for (i=0; n && i<TABSZ; i++)
      for (np=tab[i]; np;) {
         tp = np->next;
         (*rtn)(np, dp);	/* might remove np! */
         np = tp;
         n--;
      }
}

static node_t *
find_bytag(tag)
   char *tag;
{
   register int i, n;
   register node_t *np;

   n = nnodes;
   for (i=0; n && i<TABSZ; i++)
      for (np=tab[i]; np; np=np->next) {
         if (strcmp(tag, np->display) == 0)
            return np;
         n--;
      }

   return 0;
}

static char *
make_new_tag(display)
   char *display;
{
   register int i, len;
   char *cp;
   char buf[MAXHOSTNAMELEN];
   static char alpha[] = { 'a', 'b', 'c', 'd', 'e', 'f',
				'g', 'h', 'i', 'j', 'k',
				'l', 'm', 'n', 'o', 'p',
				'q', 'r', 's', 't', 'u',
				'v', 'w', 'x', 'y', 'z' };

   if (display == 0 || *display == '\0' || *display == ':') {
      if (gethostname(buf, MAXHOSTNAMELEN) < 0)
         strcpy(buf, "local");
      if (display == 0 || *display == '\0')
         strcat(buf, ":0");
      else
         strcat(buf, display);
   }
   else {
      strcpy(buf, display);
      if (index(display, ':') == 0)
         strcat(buf, ":0");
   }
   len = strlen(buf);

   if (find_bytag(buf)) {
      buf[len++] = '-';
      buf[len++] = alpha[0];
      buf[len] = '\0';

      for (i=1; i<sizeof(alpha); i++)
         if (find_bytag(buf))
            buf[len-1] = alpha[i];
         else
            break;

      if (i == sizeof(alpha)) {
         fprintf(stderr, "ran out of icon tags!\n");
         return 0;
      }
   }
   if ((cp = (char *)malloc(len + 1)) == 0)
      fprintf(stderr, "node_add: malloc returned zero, fatal\n");
   else
      strcpy(cp, buf);

   return cp;
}
