Installation supplements
========================

Caution: You need to have fehQlibs installed!

This ucspi-ssl release assumes a +SSL version supporting TLS 1.3.
Within the ./src directory you find some conf-+ files for your adjustments.

0. Requirements
---------------
- fehQlibs >= 25
- OpenSSL 3.x
- LibreSSL > 3.7

1. Customization
----------------
- conf-man (man page target) => /usr/share/man

2. Compilation - files are autogenerated
----------------------------------------
- conf-cc (don't need to be touched)
- conf-ccperl (no adjustments required) 
- conf-ldperl (no adjustments required)

Note: The current version detects the AMD64 environment 
and the possible support for dynamic load libraries.

3. Installation dependencies & default - autogenerated
------------------------------------------------------
- conf-qlibs (the fehQlibs install directory; default: /usr/local/qlibs)
- conf-perl (no adjustments required)
- conf-ssl (default; add path to inlcude alternative or  additional openssl header file)
- conf-ssllib (default; the cryto libs to include)

  Note: Some popular examples are given in the conf-* files.

4. Certificate and key file handling 
------------------------------------
These are parms declared for each server; thus may stay empty/untouched.
Default values MAY be provided as:

- conf-cafile
- conf-ccafile
- conf-certfile
- conf-certchainfile
- conf-ciphers (a current sample is provided, but not active)
- conf-dhfile (you may use the 'dh2048.pem' in ucspi-ssl's ./etc dir)
- conf-keyfile

5. Installation procedure
-------------------------
   Usually, you just install the package with

- package/install

or -- in case the Perl install failes --

- package/install base
(- package/man)

6. OmniOS specifics - FD3
-------------------------
On some OS -- in particular OmniOS -- the shell does not support
reading from file descriptor FD 3. This is required for sslclient
to read the password keys for encrypted X.509 key files.

You may succeed with a particular shell, for instance 'zsh',
providing this capability.

- If calling sslclient together with an encrypted key file, use
  this shell.
- In order to succeed testing (see below), invoke the tests from
  a capabable shell as well.

7. Testing
----------
- package/rts -- or  --
- package/rts base (if Perl is not installed/working).

Testing can be done after the step

- package/compile

  and before

- package/install or
- package/upgrade 

- package/rts 
  utilizes the files available in

- ucspi-ssl-X.Y.Z/etc -> crypto material
- ucspi-ssl-X.Y.Z/compile -> path to executables

Thus, the etc/ directory includes some X.509 certs and keyfiles
for testing. Have a look at those!

8. ucspi-tcp dependencies 
-------------------------
The vanilla ucspi-tcp-0.88 package from Dan Bernstein does not support
building 'tcprules' with CIDR support; however is binary compatible.
   
Download and install 'ucspi-tcp6' from 
https://www.fehcom.de/ipnet/ucspi-tcp6.html

9. Compatibility
----------------
This version has been successfully tested against:

- OpenSSL  1.1.1t, 3.0.7, 3.1.6, 3.2.3, 3.3.2, 3.4.0-alpha1
- LibreSSL 3.7.2, 3.8.4, 3.9.2

Other intermittend releases are expected to work as well.

You can sucessfully use ucspi-ssl with 'foreign' SSL installations.
Apart from the header files used open compilation, the execution
requires a tailored LD_LIBRARY_PATH pointing to the SSL libs. 
This can be done in the run script calling ie. sslserver together
with the application. Otherwise, the ssl* modules will always
use the default libraries; which may not work.
See src/rts.it for a sample given LibreSSL. 

10. LibreSSL 
------------
   LibreSSL has a different understanding of 

- how to work with CIPHER_SUITES and
- how to use the 'libssl' and 'libcrypto'.

libssl and libcrypto are enumerated (eg. libssl.so.52). 
In case you are building ucspi-ssl based on static libs,
you need to do the following in the LibreSSL dir:

-  ln -s ssl/.libs/libssl.a .
-  ln -s crypto/.libs/libcrypto.a .

11. OpenSSL 3.0/3.1/3.2/3.3/3.4
-------------------------------
OpenSSL have changed their APIs significantly. 
The current ucspi-ssl includes deprecated calls:

		- RSA_new(), RSA_generate_key_ex(), RSA_free()
		- PEM_read_bio_DHparams(), EC_KEY_new_by_curve_name(), EC_KEY_free()
	
In case you install openssl-3.x.y manually, you not only need to
- modify conf-ssl and conf-ssllib
but also to inlude libssl.so.3 in your library path:

		(1) export LD_LIBRARY_PATH=<path>/opensssl-3.x.y
		(2) include that path to your standard lib path or 
		(3) copy libssl.so.3 to your standard lib path.

A check would show the statically linked OpenSSL libs like this:

  $ ldd sslserver

  sslserver:
	  libssl.so.3 => /home/ucspi/_SSL/openssl-3.0.7/libssl.so.3 (0x800260000)
	  libcrypto.so.3 => /home/ucspi/_SSL/openssl-3.0.7/libcrypto.so.3 (0x80030b000)
	  libc.so.7 => /lib/libc.so.7 (0x800745000)
	  libthr.so.3 => /lib/libthr.so.3 (0x800b4f000)

  Verify everything is working while perfoming the tests:

- package/rts !!

Erwin Hoffmann, September 2024

