/*
  options.c

  For TuxMath
  The options screen loop.

  by Bill Kendrick
  bill@newbreedsoftware.com
  http://www.newbreedsoftware.com/


  Part of "Tux4Kids" Project
  http://www.tux4kids.org/
      
  August 26, 2001 - September 6, 2001
*/


#define OPTIONS_DEVEL

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <SDL.h>
#include "options.h"
#include "images.h"
#include "setup.h"
#include "sounds.h"

#ifdef OPTIONS_DEVEL
#include <SDL_image.h>
#endif


int options(void)
{
  int opt, old_opt, done, quit, img, blinking;
  SDL_Rect dest;
  SDL_Event event;
  Uint32 last_time, now_time;
  SDLKey key;
  SDL_Surface * bkgd;
  
  
  /* Clear window: */
  
  SDL_FillRect(screen, NULL, SDL_MapRGB(screen->format, 0, 0, 0));


#ifdef OPTIONS_DEVEL
  bkgd = IMG_Load(DATA_PREFIX "/images/options-devel.jpg");
  if (bkgd == NULL)
  {
    fprintf(stderr,
	    "\nWarning: Could not load:\n"
	    DATA_PREFIX "/images/options-devel.jpg\n"
	    "The Simple DirectMedia error that occured was: %s\n",
	    SDL_GetError());

    return 0;
  }

  SDL_BlitSurface(bkgd, NULL, screen, NULL);
  SDL_Flip(screen);
#endif
  
  
  /* --- MAIN OPTIONS SCREEN LOOP: --- */

  blinking = 0;
  opt = 0;
  done = 0;
  quit = 0;
  
  do
    {
      last_time = SDL_GetTicks();
      old_opt = opt;
      
      
      /* Handle any incoming events: */
      
      while (SDL_PollEvent(&event) > 0)
	{
	  if (event.type == SDL_QUIT)
	    {
	      /* Window close event - quit! */
	      
	      quit = 1;
	      done = 1;
	    }
	  else if (event.type == SDL_KEYDOWN)
	    {
	      key = event.key.keysym.sym;
	      
	      if (key == SDLK_ESCAPE)
		{
		  /* Escape key - quit! */
		  
		  done = 1;
		}
	      else if (key == SDLK_DOWN)
		{
		  opt++;
		  
		  if (opt >= NUM_OPTS)
		    opt = NUM_OPTS - 1;
		}
	      else if (key == SDLK_UP)
		{
		  opt--;
		  
		  if (opt < 0)
		    opt = 0;
		}
	      else if (key == SDLK_RETURN)
		{
		  done = 1;
		}
	    }
	}
      
      
      /* Erase Tux (cursor) */
      
      if (opt != old_opt)
	{
	  blinking = 0;
	  
	  
	  dest.x = 32;
	  dest.y = (images[IMG_TITLE]->h + 8 + 
		    (old_opt * images[IMG_TUX_HELMET1]->h));
	  dest.w = images[IMG_TUX_HELMET1]->w;
	  dest.h = images[IMG_TUX_HELMET1]->h;
	  
	  SDL_FillRect(screen, &dest,
		       SDL_MapRGB(screen->format, 200, 232, 255));
	}
      
      
      /* Handling Tux (cursor) blinking: */
      
      if ((rand() % 50) == 0 && blinking == 0)
	{
	  blinking = 6;
	}
      
      if (blinking > 0)
	blinking--;
      
      
      /* Draw Tux (cursor) */
      
      dest.x = 32;
      dest.y = images[IMG_TITLE]->h + 8 + (opt * images[IMG_TUX_HELMET1]->h);
      dest.w = images[IMG_TUX_HELMET1]->w;
      dest.h = images[IMG_TUX_HELMET1]->h;
      
      img = IMG_TUX_HELMET1;
      
      if (blinking >= 4 || (blinking >= 1 && blinking < 2))
	img = IMG_TUX_HELMET2;
      else if (blinking >= 2 && blinking < 4)
	img = IMG_TUX_HELMET3;
     
#ifndef OPTIONS_DEVEL 
      SDL_BlitSurface(images[img], NULL, screen, &dest);
      
      SDL_Flip(screen);
#endif

      
      /* Pause (keep frame-rate event) */
      
      now_time = SDL_GetTicks();
      if (now_time < last_time + (1000 / 20))
	{
	  SDL_Delay(last_time + (1000 / 20) - now_time);
	}
    }
  while (!done);


#ifdef OPTIONS_DEVEL
  SDL_FreeSurface(bkgd);
#endif
  
  
  /* Return the chosen command: */
  
  return quit;
}
